/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jython.shaded.jnr.posix;

import org.scijava.jython.shaded.jnr.ffi.Pointer;
import org.scijava.jython.shaded.jnr.ffi.Runtime;
import org.scijava.jython.shaded.jnr.ffi.StructLayout;
import org.scijava.jython.shaded.jnr.posix.BaseIovec;
import org.scijava.jython.shaded.jnr.posix.BaseMsgHdr;
import org.scijava.jython.shaded.jnr.posix.CmsgHdr;
import org.scijava.jython.shaded.jnr.posix.LinuxCmsgHdr;
import org.scijava.jython.shaded.jnr.posix.MacOSCmsgHdr;
import org.scijava.jython.shaded.jnr.posix.NativePOSIX;

class LinuxMsgHdr
extends BaseMsgHdr {
    private static final Layout layout = new Layout(Runtime.getSystemRuntime());

    protected LinuxMsgHdr(NativePOSIX posix) {
        super(posix, layout);
        this.setName(null);
    }

    CmsgHdr allocateCmsgHdrInternal(NativePOSIX posix, Pointer pointer, int len) {
        if (len > 0) {
            return new LinuxCmsgHdr(posix, pointer, len);
        }
        return new LinuxCmsgHdr(posix, pointer);
    }

    void setControlPointer(Pointer control) {
        LinuxMsgHdr.layout.msg_control.set(this.memory, control);
    }

    void setControlLen(int len) {
        LinuxMsgHdr.layout.msg_controllen.set(this.memory, len);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("msghdr {\n");
        buf.append("  msg_name=").append(this.getName()).append(",\n");
        buf.append("  msg_namelen=").append(this.getNameLen()).append(",\n");
        buf.append("  msg_iov=[\n");
        Pointer iovp = LinuxMsgHdr.layout.msg_iov.get(this.memory);
        int numIov = this.getIovLen();
        for (int i = 0; i < numIov; ++i) {
            Pointer eachp = iovp.slice(i * BaseIovec.layout.size());
            buf.append(new BaseIovec(this.posix, eachp).toString("    "));
            if (i < numIov - 1) {
                buf.append(",\n");
                continue;
            }
            buf.append("\n");
        }
        buf.append("  ],\n");
        buf.append("  msg_control=[\n");
        CmsgHdr[] controls = this.getControls();
        for (int i = 0; i < controls.length; ++i) {
            buf.append(((MacOSCmsgHdr)controls[i]).toString("    "));
            if (i < controls.length - 1) {
                buf.append(",\n");
                continue;
            }
            buf.append("\n");
        }
        buf.append("  ],\n");
        buf.append("  msg_controllen=").append(LinuxMsgHdr.layout.msg_controllen.get(this.memory)).append("\n");
        buf.append("  msg_iovlen=").append(this.getIovLen()).append(",\n");
        buf.append("  msg_flags=").append(this.getFlags()).append(",\n");
        buf.append("}");
        return buf.toString();
    }

    void setNamePointer(Pointer name) {
        LinuxMsgHdr.layout.msg_name.set(this.memory, name);
    }

    Pointer getNamePointer() {
        return LinuxMsgHdr.layout.msg_name.get(this.memory);
    }

    void setNameLen(int len) {
        LinuxMsgHdr.layout.msg_namelen.set(this.memory, len);
    }

    int getNameLen() {
        return (int)LinuxMsgHdr.layout.msg_namelen.get(this.memory);
    }

    void setIovPointer(Pointer iov) {
        LinuxMsgHdr.layout.msg_iov.set(this.memory, iov);
    }

    Pointer getIovPointer() {
        return LinuxMsgHdr.layout.msg_iov.get(this.memory);
    }

    void setIovLen(int len) {
        LinuxMsgHdr.layout.msg_iovlen.set(this.memory, len);
    }

    int getIovLen() {
        return (int)LinuxMsgHdr.layout.msg_iovlen.get(this.memory);
    }

    Pointer getControlPointer() {
        return LinuxMsgHdr.layout.msg_control.get(this.memory);
    }

    public int getControlLen() {
        return (int)LinuxMsgHdr.layout.msg_controllen.get(this.memory);
    }

    public void setFlags(int flags) {
        LinuxMsgHdr.layout.msg_flags.set(this.memory, flags);
    }

    public int getFlags() {
        return LinuxMsgHdr.layout.msg_flags.get(this.memory);
    }

    public static class Layout
    extends StructLayout {
        public final StructLayout.Pointer msg_name = new StructLayout.Pointer();
        public final StructLayout.socklen_t msg_namelen = new StructLayout.socklen_t();
        public final StructLayout.Pointer msg_iov = new StructLayout.Pointer();
        public final StructLayout.size_t msg_iovlen = new StructLayout.size_t();
        public final StructLayout.Pointer msg_control = new StructLayout.Pointer();
        public final StructLayout.size_t msg_controllen = new StructLayout.size_t();
        public final StructLayout.Signed32 msg_flags = new StructLayout.Signed32();

        protected Layout(Runtime runtime) {
            super(runtime);
        }
    }
}

