/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jython.shaded.jnr.posix;

import org.scijava.jython.shaded.jnr.ffi.Pointer;
import org.scijava.jython.shaded.jnr.ffi.Runtime;
import org.scijava.jython.shaded.jnr.ffi.StructLayout;
import org.scijava.jython.shaded.jnr.posix.NativePasswd;
import org.scijava.jython.shaded.jnr.posix.Passwd;

public class SolarisPasswd
extends NativePasswd
implements Passwd {
    private static final Layout layout = new Layout(Runtime.getSystemRuntime());

    public SolarisPasswd(Pointer memory) {
        super(memory);
    }

    public String getAccessClass() {
        return "unknown";
    }

    public String getGECOS() {
        return SolarisPasswd.layout.pw_gecos.get(this.memory);
    }

    public long getGID() {
        return SolarisPasswd.layout.pw_gid.get(this.memory);
    }

    public String getHome() {
        return SolarisPasswd.layout.pw_dir.get(this.memory);
    }

    public String getLoginName() {
        return SolarisPasswd.layout.pw_name.get(this.memory);
    }

    public int getPasswdChangeTime() {
        return 0;
    }

    public String getPassword() {
        return SolarisPasswd.layout.pw_passwd.get(this.memory);
    }

    public String getShell() {
        return SolarisPasswd.layout.pw_shell.get(this.memory);
    }

    public long getUID() {
        return SolarisPasswd.layout.pw_uid.get(this.memory);
    }

    public int getExpire() {
        return Integer.MAX_VALUE;
    }

    static final class Layout
    extends StructLayout {
        public final StructLayout.UTF8StringRef pw_name = new StructLayout.UTF8StringRef();
        public final StructLayout.UTF8StringRef pw_passwd = new StructLayout.UTF8StringRef();
        public final StructLayout.Signed32 pw_uid = new StructLayout.Signed32();
        public final StructLayout.Signed32 pw_gid = new StructLayout.Signed32();
        public final StructLayout.Pointer pw_age = new StructLayout.Pointer();
        public final StructLayout.Pointer pw_comment = new StructLayout.Pointer();
        public final StructLayout.UTF8StringRef pw_gecos = new StructLayout.UTF8StringRef();
        public final StructLayout.UTF8StringRef pw_dir = new StructLayout.UTF8StringRef();
        public final StructLayout.UTF8StringRef pw_shell = new StructLayout.UTF8StringRef();

        private Layout(Runtime runtime) {
            super(runtime);
        }
    }
}

