/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jython.shaded.com.ziclix.python.sql;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import org.python.core.Py;
import org.python.core.PyFile;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.scijava.jython.shaded.com.ziclix.python.sql.Procedure;
import org.scijava.jython.shaded.com.ziclix.python.sql.PyCursor;
import org.scijava.jython.shaded.com.ziclix.python.sql.zxJDBC;

public class DataHandler {
    private static final int INITIAL_SIZE = 4096;
    private static final String[] SYSTEM_DATAHANDLERS = new String[]{"org.scijava.jython.shaded.com.ziclix.python.sql.JDBC20DataHandler"};

    public String getMetaDataName(PyObject name) {
        return name == Py.None ? null : name.__str__().toString();
    }

    public Procedure getProcedure(PyCursor cursor, PyObject name) throws SQLException {
        return new Procedure(cursor, name);
    }

    public PyObject getRowId(Statement stmt2) throws SQLException {
        return Py.None;
    }

    public void preExecute(Statement stmt2) throws SQLException {
    }

    public void postExecute(Statement stmt2) throws SQLException {
    }

    public void setJDBCObject(PreparedStatement stmt2, int index, PyObject object) throws SQLException {
        try {
            Object o = object.__tojava__(Object.class);
            if (o instanceof BigInteger) {
                stmt2.setObject(index, o, -5);
            } else {
                stmt2.setObject(index, o);
            }
        }
        catch (Exception e) {
            SQLException cause = null;
            SQLException ex = new SQLException("error setting index [" + index + "]");
            cause = e instanceof SQLException ? (SQLException)e : new SQLException(e.getMessage());
            ex.setNextException(cause);
            throw ex;
        }
    }

    public void setJDBCObject(PreparedStatement stmt2, int index, PyObject object, int type) throws SQLException {
        try {
            if (DataHandler.checkNull(stmt2, index, object, type)) {
                return;
            }
            switch (type) {
                case 91: {
                    Date date = (Date)object.__tojava__(Date.class);
                    stmt2.setDate(index, date);
                    break;
                }
                case 92: {
                    Time time = (Time)object.__tojava__(Time.class);
                    stmt2.setTime(index, time);
                    break;
                }
                case 93: {
                    Timestamp timestamp = (Timestamp)object.__tojava__(Timestamp.class);
                    stmt2.setTimestamp(index, timestamp);
                    break;
                }
                case -1: {
                    if (object instanceof PyFile) {
                        object = ((PyFile)object).read();
                    }
                    String varchar = (String)object.__tojava__(String.class);
                    BufferedReader reader = new BufferedReader(new StringReader(varchar));
                    stmt2.setCharacterStream(index, (Reader)reader, varchar.length());
                    break;
                }
                case -7: {
                    stmt2.setBoolean(index, object.__nonzero__());
                    break;
                }
                default: {
                    if (object instanceof PyFile) {
                        object = ((PyFile)object).read();
                    }
                    stmt2.setObject(index, object.__tojava__(Object.class), type);
                    break;
                }
            }
        }
        catch (Exception e) {
            SQLException cause = null;
            SQLException ex = new SQLException("error setting index [" + index + "], type [" + type + "]");
            cause = e instanceof SQLException ? (SQLException)e : new SQLException(e.getMessage());
            ex.setNextException(cause);
            throw ex;
        }
    }

    public PyObject getPyObject(ResultSet set, int col, int type) throws SQLException {
        PyObject obj = Py.None;
        switch (type) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                String string2 = set.getString(col);
                obj = string2 == null ? Py.None : Py.newUnicode(string2);
                break;
            }
            case -16: 
            case -1: {
                Reader reader = set.getCharacterStream(col);
                obj = reader == null ? Py.None : Py.newUnicode(DataHandler.read(reader));
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bd = set.getBigDecimal(col);
                obj = bd == null ? Py.None : Py.newFloat(bd.doubleValue());
                break;
            }
            case -7: 
            case 16: {
                obj = set.getBoolean(col) ? Py.True : Py.False;
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                obj = Py.newInteger(set.getInt(col));
                break;
            }
            case -5: {
                obj = Py.newLong(set.getLong(col));
                break;
            }
            case 6: 
            case 7: {
                obj = Py.newFloat(set.getFloat(col));
                break;
            }
            case 8: {
                obj = Py.newFloat(set.getDouble(col));
                break;
            }
            case 92: {
                obj = Py.newTime(set.getTime(col));
                break;
            }
            case 93: {
                obj = Py.newDatetime(set.getTimestamp(col));
                break;
            }
            case 91: {
                Object date = set.getObject(col);
                obj = date instanceof Date ? Py.newDate((Date)date) : Py.java2py(date);
                break;
            }
            case 0: {
                obj = Py.None;
                break;
            }
            case 1111: 
            case 2000: {
                obj = Py.java2py(set.getObject(col));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                obj = Py.java2py(set.getBytes(col));
                break;
            }
            case 2004: {
                Blob blob = set.getBlob(col);
                obj = blob == null ? Py.None : Py.java2py(DataHandler.read(blob.getBinaryStream()));
                break;
            }
            case 2005: 
            case 2009: 
            case 2011: {
                Clob clob = set.getClob(col);
                obj = clob == null ? Py.None : Py.java2py(DataHandler.read(clob.getCharacterStream()));
                break;
            }
            case 2003: {
                throw this.createUnsupportedTypeSQLException("ARRAY", col);
            }
            case 70: {
                throw this.createUnsupportedTypeSQLException("DATALINK", col);
            }
            case 2001: {
                throw this.createUnsupportedTypeSQLException("DISTINCT", col);
            }
            case 2006: {
                throw this.createUnsupportedTypeSQLException("REF", col);
            }
            case -8: {
                throw this.createUnsupportedTypeSQLException("STRUCT", col);
            }
            case 2002: {
                throw this.createUnsupportedTypeSQLException("STRUCT", col);
            }
            default: {
                throw this.createUnsupportedTypeSQLException(new Integer(type), col);
            }
        }
        return set.wasNull() || obj == null ? Py.None : obj;
    }

    protected final SQLException createUnsupportedTypeSQLException(Object type, int col) {
        Object[] vals = new Object[]{type, new Integer(col)};
        String msg = zxJDBC.getString("unsupportedTypeForColumn", vals);
        return new SQLException(msg);
    }

    public PyObject getPyObject(CallableStatement stmt2, int col, int type) throws SQLException {
        PyObject obj = Py.None;
        switch (type) {
            case -1: 
            case 1: 
            case 12: {
                String string2 = stmt2.getString(col);
                obj = string2 == null ? Py.None : Py.newUnicode(string2);
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bd = stmt2.getBigDecimal(col);
                obj = bd == null ? Py.None : Py.newFloat(bd.doubleValue());
                break;
            }
            case -7: {
                obj = stmt2.getBoolean(col) ? Py.True : Py.False;
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                obj = Py.newInteger(stmt2.getInt(col));
                break;
            }
            case -5: {
                obj = Py.newLong(stmt2.getLong(col));
                break;
            }
            case 6: 
            case 7: {
                obj = Py.newFloat(stmt2.getFloat(col));
                break;
            }
            case 8: {
                obj = Py.newFloat(stmt2.getDouble(col));
                break;
            }
            case 92: {
                obj = Py.newTime(stmt2.getTime(col));
                break;
            }
            case 93: {
                obj = Py.newDatetime(stmt2.getTimestamp(col));
                break;
            }
            case 91: {
                obj = Py.newDate(stmt2.getDate(col));
                break;
            }
            case 0: {
                obj = Py.None;
                break;
            }
            case 1111: {
                obj = Py.java2py(stmt2.getObject(col));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                obj = Py.java2py(stmt2.getBytes(col));
                break;
            }
            default: {
                this.createUnsupportedTypeSQLException(type, col);
            }
        }
        return stmt2.wasNull() || obj == null ? Py.None : obj;
    }

    public void registerOut(CallableStatement statement, int index, int colType, int dataType, String dataTypeName) throws SQLException {
        try {
            statement.registerOutParameter(index, dataType);
        }
        catch (Throwable t) {
            SQLException cause = null;
            SQLException ex = new SQLException("error setting index [" + index + "], coltype [" + colType + "], datatype [" + dataType + "], datatypename [" + dataTypeName + "]");
            cause = t instanceof SQLException ? (SQLException)t : new SQLException(t.getMessage());
            ex.setNextException(cause);
            throw ex;
        }
    }

    public static final boolean checkNull(PreparedStatement stmt2, int index, PyObject object, int type) throws SQLException {
        if (object == null || Py.None == object) {
            stmt2.setNull(index, type);
            return true;
        }
        return false;
    }

    public static final byte[] read(InputStream stream) {
        int size = 0;
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        try {
            while ((size = stream.read(buffer)) != -1) {
                baos.write(buffer, 0, size);
            }
        }
        catch (IOException ioe) {
            throw zxJDBC.makeException(ioe);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ioe) {
                throw zxJDBC.makeException(ioe);
            }
        }
        return baos.toByteArray();
    }

    public static String read(Reader reader) {
        int size = 0;
        char[] buffer = new char[4096];
        StringBuilder builder = new StringBuilder(4096);
        try {
            while ((size = reader.read(buffer)) != -1) {
                builder.append(buffer, 0, size);
            }
        }
        catch (IOException ioe) {
            throw zxJDBC.makeException(ioe);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ioe) {
                throw zxJDBC.makeException(ioe);
            }
        }
        return builder.toString();
    }

    public static final DataHandler getSystemDataHandler() {
        DataHandler dh = new DataHandler();
        for (String element : SYSTEM_DATAHANDLERS) {
            try {
                Class<?> c = Class.forName(element);
                Constructor<?> cons = c.getConstructor(DataHandler.class);
                dh = (DataHandler)cons.newInstance(dh);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return dh;
    }

    public PyObject __chain__() {
        return new PyList(Py.javas2pys(this));
    }

    public String toString() {
        return this.getClass().getName();
    }
}

