/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jython.shaded.javatests;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Pattern;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class Issue1972 {
    static int DEBUG_PORT = 0;
    static int VERBOSE = 0;
    static String[] STDOUT_IGNORE = new String[]{"Listening for transport dt_socket"};
    static String[] STDERR_IGNORE = new String[]{"Jython 2", "\\*sys-package-mgr"};
    static final String DEBUG_OPTS = "-agentlib:jdwp=transport=dt_socket,server=y,address=%d,suspend=y";
    private Process proc = null;
    private OutputStream toProc;
    private LineQueue inFromProc;
    private LineQueue errFromProc;
    static final Properties props = System.getProperties();
    static final String lineSeparator = props.getProperty("line.separator");
    static final String pythonHome = props.getProperty("python.home");
    private static List<Pattern> stdoutIgnore;
    private static List<Pattern> stderrIgnore;
    private static final String ESC_CHARS = "\r\n\t\\\b\f";
    private static final String[] ESC_STRINGS;

    @After
    public void afterEachTest() {
        if (this.proc != null) {
            this.proc.destroy();
        }
        this.errFromProc = null;
        this.inFromProc = null;
    }

    @Test
    public void readStderr() throws Exception {
        Issue1972.announceTest(VERBOSE, "readStderr");
        this.setProcJava("-version");
        this.proc.waitFor();
        Issue1972.outputAsHexDump(VERBOSE, this.inFromProc, this.errFromProc);
        Assert.assertEquals((String)"Unexpected text in stdout", (long)0L, (long)this.inFromProc.size());
        Assert.assertTrue((String)"No text output to stderr", (this.errFromProc.size() > 0 ? 1 : 0) != 0);
        String res = this.errFromProc.asStrings().get(0);
        Assert.assertTrue((String)"stderr should mention version", (boolean)res.contains("version"));
    }

    @Test
    public void readStdout() throws Exception {
        Issue1972.announceTest(VERBOSE, "readStdout");
        this.setProcJava(this.getClass().getName());
        this.proc.waitFor();
        Issue1972.outputAsHexDump(VERBOSE, this.inFromProc, this.errFromProc);
        this.checkErrFromProc(new String[0]);
        this.checkInFromProc("Hello");
    }

    @Test
    public void echoStdin() throws Exception {
        Issue1972.announceTest(VERBOSE, "echoStdin");
        this.setProcJava(this.getClass().getName(), "echo");
        this.writeToProc("spam");
        this.writeToProc("spam\r");
        this.writeToProc("spam\r\n");
        this.toProc.close();
        this.proc.waitFor();
        Issue1972.outputAsHexDump(VERBOSE, this.inFromProc, this.errFromProc);
        this.checkErrFromProc(new String[0]);
        this.checkInFromProc(false, "Hello\\r\\n", "spamspam\\r", "spam\\r\\n");
    }

    @Test
    public void echoStdinAsHex() throws Exception {
        Issue1972.announceTest(VERBOSE, "echoStdinAsHex");
        this.setProcJava(this.getClass().getName(), "hex");
        this.writeToProc("a\r");
        this.writeToProc("b\n");
        this.writeToProc("c\r\n");
        this.toProc.close();
        this.proc.waitFor();
        Issue1972.outputAsStrings(VERBOSE, this.inFromProc, this.errFromProc);
        this.checkErrFromProc(new String[0]);
        this.checkInFromProc("Hello", " 61", " 0d", " 62", " 0a", " 63", " 0d", " 0a");
    }

    @Test
    public void jythonSubprocess() throws Exception {
        Issue1972.announceTest(VERBOSE, "jythonSubprocess");
        this.setProcJava("org.python.util.jython", "-c", "print 'Hello'");
        this.proc.waitFor();
        Issue1972.outputAsHexDump(VERBOSE, this.inFromProc, this.errFromProc);
        this.checkErrFromProc(new String[0]);
        this.checkInFromProc("Hello");
    }

    @Test
    public void jythonNonInteractive() throws Exception {
        Issue1972.announceTest(VERBOSE, "jythonNonInteractiveConsole");
        this.setProcJava("org.python.util.jython", "-c", "import sys; print type(sys._jy_console).__name__; print sys.stdin.isatty()");
        this.proc.waitFor();
        Issue1972.outputAsStrings(VERBOSE, this.inFromProc, this.errFromProc);
        this.checkErrFromProc(new String[0]);
        this.checkInFromProc("PlainConsole", "False");
    }

    @Test
    public void jythonInteractive() throws Exception {
        Issue1972.announceTest(VERBOSE, "jythonInteractiveConsole");
        this.setProcJava("-Dpython.home=" + pythonHome, "org.python.util.jython");
        this.writeToProc("12+3\n");
        this.writeToProc("import sys\n");
        this.writeToProc("print type(sys._jy_console).__name__\n");
        this.writeToProc("print sys.stdin.isatty()\n");
        this.toProc.close();
        this.proc.waitFor();
        Issue1972.outputAsStrings(VERBOSE, this.inFromProc, this.errFromProc);
        this.checkErrFromProc("");
        this.checkInFromProc("15", "PlainConsole", "False");
    }

    @Test
    public void jythonJLineConsole() throws Exception {
        Issue1972.announceTest(VERBOSE, "jythonJLineConsole");
        this.setProcJava("-Dpython.console=org.python.util.JLineConsole", "-Dpython.home=" + pythonHome, "org.python.util.jython");
        this.writeToProc("12+3\n");
        this.writeToProc("import sys\n");
        this.writeToProc("print type(sys._jy_console).__name__\n");
        this.writeToProc("print sys.stdin.isatty()\n");
        this.toProc.close();
        this.proc.waitFor();
        Issue1972.outputAsStrings(VERBOSE, this.inFromProc, this.errFromProc);
        this.checkErrFromProc("");
        this.checkInFromProc("15", "PlainConsole", "False");
    }

    @Test
    public void jythonReadline() throws Exception {
        int count2;
        Issue1972.announceTest(VERBOSE, "jythonReadline");
        this.setProcJava("-Dpython.console=org.python.util.JLineConsole", "-Dpython.home=" + pythonHome, "org.python.util.jython", "-c", "import sys; sys.stdout.write(sys.stdin.readline()); sys.stdout.flush();");
        this.inFromProc.clear();
        this.errFromProc.clear();
        String spamString = "spam" + lineSeparator;
        byte[] spam = spamString.getBytes();
        int limit = 9000;
        for (count2 = 0; count2 <= limit; count2 += spam.length) {
            this.toProc.write(spam);
            this.toProc.flush();
            if (count2 == 0 || count2 + spam.length > limit) {
                Thread.sleep(10000L);
            }
            if (this.inFromProc.size() > 0 || this.errFromProc.size() > 0) break;
        }
        if (VERBOSE >= 1) {
            System.out.println(String.format("  count = %4d", count2));
        }
        this.toProc.close();
        this.proc.waitFor();
        Issue1972.outputAsHexDump(VERBOSE, this.inFromProc, this.errFromProc);
        Assert.assertTrue((String)"Subprocess did not respond promptly to first line", (count2 == 0 ? 1 : 0) != 0);
        this.checkInFromProc("spam");
    }

    public static void main(String[] args) throws IOException {
        System.out.println("Hello");
        if (args.length > 0) {
            String arg = args[0];
            if ("echo".equals(arg)) {
                int c;
                while ((c = System.in.read()) != -1) {
                    System.out.write(c);
                    System.out.flush();
                }
            } else if ("hex".equals(arg)) {
                int c;
                while ((c = System.in.read()) != -1) {
                    System.out.printf(" %02x", c);
                    System.out.println();
                }
            } else {
                System.err.println("Huh?");
            }
        }
    }

    static Process startJavaProcess(String ... args) throws IOException {
        String javaClassPath = props.getProperty("java.class.path");
        ArrayList<String> cmd2 = new ArrayList<String>();
        cmd2.add("java");
        cmd2.add("-classpath");
        cmd2.add(javaClassPath);
        if (DEBUG_PORT > 0) {
            cmd2.add(String.format(DEBUG_OPTS, DEBUG_PORT));
        }
        for (String arg : args) {
            cmd2.add(arg);
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(cmd2);
        return pb.start();
    }

    private void setProcJava(String ... args) throws IOException {
        this.proc = Issue1972.startJavaProcess(args);
        this.inFromProc = new LineQueue(this.proc.getInputStream());
        this.errFromProc = new LineQueue(this.proc.getErrorStream());
        this.toProc = this.proc.getOutputStream();
    }

    private void writeToProc(String s) throws IOException {
        this.toProc.write(s.getBytes());
        this.toProc.flush();
    }

    private void checkFromProc(String message2, boolean addSeparator, LineQueue queue, List<Pattern> toIgnore, String ... expected) {
        if (addSeparator) {
            String escapedSeparator = "";
            try {
                escapedSeparator = Issue1972.escape(lineSeparator.getBytes("US-ASCII"));
            }
            catch (UnsupportedEncodingException e) {
                Assert.fail((String)"Could not encode line separator as ASCII");
            }
            int i = 0;
            while (i < expected.length) {
                int n = i++;
                expected[n] = expected[n] + escapedSeparator;
            }
        }
        List<String> results = queue.asStrings();
        int count2 = 0;
        for (String r : results) {
            if (Issue1972.beginsWithAnyOf(r, toIgnore)) continue;
            if (count2 < expected.length) {
                Assert.assertEquals((String)message2, (Object)expected[count2++], (Object)r);
                continue;
            }
            ++count2;
        }
        Assert.assertEquals((String)message2, (long)expected.length, (long)count2);
    }

    private static void compileToIgnore() {
        if (stdoutIgnore == null || stderrIgnore == null) {
            stdoutIgnore = Issue1972.compileAll(STDOUT_IGNORE);
            stderrIgnore = Issue1972.compileAll(STDERR_IGNORE);
        }
    }

    private static List<Pattern> compileAll(String[] regex) {
        LinkedList<Pattern> result2 = new LinkedList<Pattern>();
        if (regex != null) {
            for (String s : regex) {
                Pattern p = Pattern.compile(s);
                result2.add(p);
            }
        }
        return result2;
    }

    private static boolean beginsWithAnyOf(String s, List<Pattern> patterns) {
        for (Pattern p : patterns) {
            if (!p.matcher(s).lookingAt()) continue;
            return true;
        }
        return false;
    }

    private void checkInFromProc(boolean addSeparator, String ... expected) {
        Issue1972.compileToIgnore();
        this.checkFromProc("subprocess stdout", addSeparator, this.inFromProc, stdoutIgnore, expected);
    }

    private void checkInFromProc(String ... expected) {
        this.checkInFromProc(true, expected);
    }

    private void checkErrFromProc(boolean addSeparator, String ... expected) {
        Issue1972.compileToIgnore();
        this.checkFromProc("subprocess stderr", addSeparator, this.errFromProc, stderrIgnore, expected);
    }

    private void checkErrFromProc(String ... expected) {
        this.checkErrFromProc(true, expected);
    }

    static void announceTest(int verbose, String name) {
        if (verbose >= 1) {
            System.out.println(String.format("------- Test: %-40s -------", name));
        }
    }

    static void outputAsStrings(int verbose, LineQueue inFromProc) {
        if (verbose >= 2) {
            Issue1972.outputStreams(inFromProc.asStrings(), null);
        }
    }

    static void outputAsStrings(int verbose, LineQueue inFromProc, LineQueue errFromProc) {
        if (verbose >= 2) {
            Issue1972.outputStreams(inFromProc.asStrings(), errFromProc.asStrings());
        }
    }

    static void outputAsHexDump(int verbose, LineQueue inFromProc) {
        if (verbose >= 2) {
            Issue1972.outputStreams(inFromProc.asHexDump(), null);
        }
    }

    static void outputAsHexDump(int verbose, LineQueue inFromProc, LineQueue errFromProc) {
        if (verbose >= 2) {
            Issue1972.outputStreams(inFromProc.asHexDump(), errFromProc.asHexDump());
        }
    }

    private static void outputStreams(List<String> stdout, List<String> stderr) {
        PrintStream out = System.out;
        out.println("Output stream:");
        for (String line : stdout) {
            out.println(line);
        }
        if (stderr != null && stderr.size() > 0) {
            out.println("Error stream:");
            for (String line : stderr) {
                out.println(line);
            }
        }
    }

    private static void stringDump(StringBuilder sb, ByteBuffer bb) {
        sb.setLength(0);
        int n = bb.remaining();
        for (int i = 0; i < n; ++i) {
            char c = (char)(0xFF & bb.get());
            int j = ESC_CHARS.indexOf(c);
            if (j >= 0) {
                sb.append(ESC_STRINGS[j]);
                continue;
            }
            if (c < ' ' || c > '~') {
                sb.append(String.format("\\x%02x", Character.valueOf(c)));
                continue;
            }
            sb.append(c);
        }
    }

    public static String escape(byte[] b) {
        StringBuilder sb = new StringBuilder(100);
        ByteBuffer bb = ByteBuffer.wrap(b);
        Issue1972.stringDump(sb, bb);
        return sb.toString();
    }

    static {
        ESC_STRINGS = new String[]{"\\r", "\\n", "\\t", "\\\\", "\\b", "\\f"};
    }

    static class LineQueue
    extends LinkedBlockingQueue<ByteBuffer> {
        static final int BUFFER_SIZE = 1024;
        private InputStream in;
        ByteBuffer buf;
        boolean seenCR;
        Thread scribe;

        LineQueue(InputStream in) {
            this.in = in;
            this.scribe = new Thread(){

                @Override
                public void run() {
                    try {
                        LineQueue.this.runScribe();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            this.scribe.start();
        }

        private void runScribe() throws IOException {
            int c;
            this.newBuffer();
            while ((c = this.in.read()) != -1) {
                byte b = (byte)c;
                if (c == 10) {
                    this.buf.put(b);
                    this.emitBuffer();
                    this.newBuffer();
                    continue;
                }
                if (this.seenCR) {
                    this.emitBuffer();
                    this.newBuffer();
                    this.buf.put(b);
                    continue;
                }
                if (c == 13) {
                    this.buf.put(b);
                    this.seenCR = true;
                    continue;
                }
                this.buf.put(b);
            }
            if (this.buf.position() > 0) {
                this.emitBuffer();
            }
        }

        private void newBuffer() {
            this.buf = ByteBuffer.allocate(1024);
            this.seenCR = false;
        }

        private void emitBuffer() {
            this.buf.flip();
            this.add(this.buf);
        }

        public List<String> asStrings() {
            StringBuilder sb = new StringBuilder(100);
            LinkedList<String> list = new LinkedList<String>();
            for (ByteBuffer bb : this) {
                Issue1972.stringDump(sb, bb);
                list.add(sb.toString());
                bb.rewind();
            }
            return list;
        }

        public List<String> asHexDump() {
            int LEN = 16;
            StringBuilder sb = new StringBuilder(84);
            LinkedList<String> list = new LinkedList<String>();
            for (ByteBuffer bb : this) {
                int n;
                while ((n = bb.remaining()) >= 16) {
                    LineQueue.hexDump(sb, bb, n, 16);
                    list.add(sb.toString());
                }
                if (n > 0) {
                    LineQueue.hexDump(sb, bb, n, 16);
                    list.add(sb.toString());
                }
                bb.rewind();
            }
            return list;
        }

        private static void hexDump(StringBuilder sb, ByteBuffer bb, int n, int len) {
            int i;
            sb.setLength(0);
            if (n > len) {
                n = len;
            }
            bb.mark();
            sb.append(String.format("%4d: ", bb.position()));
            for (i = 0; i < n; ++i) {
                sb.append(String.format(" %02x", bb.get()));
            }
            for (i = n; i < len; ++i) {
                sb.append("   ");
            }
            bb.reset();
            sb.append("|");
            for (i = 0; i < n; ++i) {
                char c = (char)(0xFF & bb.get());
                if (c < ' ' || c > '~') {
                    c = '.';
                }
                sb.append(c);
            }
        }
    }
}

