/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.nativelib;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import org.scijava.nativelib.DefaultJniExtractor;
import org.scijava.nativelib.JniExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeLibraryUtil {
    public static final String DELIM = "/";
    public static final String DEFAULT_SEARCH_PATH = "natives/";
    private static Architecture architecture = Architecture.UNKNOWN;
    private static String archStr = null;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"org.scijava.nativelib.NativeLibraryUtil");

    public static Architecture getArchitecture() {
        Processor processor;
        if (Architecture.UNKNOWN == architecture && Processor.UNKNOWN != (processor = NativeLibraryUtil.getProcessor())) {
            String name = System.getProperty("os.name").toLowerCase();
            if (name.contains("nix") || name.contains("nux")) {
                if (Processor.INTEL_32 == processor) {
                    architecture = Architecture.LINUX_32;
                } else if (Processor.INTEL_64 == processor) {
                    architecture = Architecture.LINUX_64;
                } else if (Processor.ARM == processor) {
                    architecture = Architecture.LINUX_ARM;
                } else if (Processor.AARCH_64 == processor) {
                    architecture = Architecture.LINUX_ARM64;
                }
            } else if (name.contains("aix")) {
                if (Processor.PPC == processor) {
                    architecture = Architecture.AIX_32;
                } else if (Processor.PPC_64 == processor) {
                    architecture = Architecture.AIX_64;
                }
            } else if (name.contains("win")) {
                if (Processor.INTEL_32 == processor) {
                    architecture = Architecture.WINDOWS_32;
                } else if (Processor.INTEL_64 == processor) {
                    architecture = Architecture.WINDOWS_64;
                }
            } else if (name.contains("mac")) {
                if (Processor.INTEL_32 == processor) {
                    architecture = Architecture.OSX_32;
                } else if (Processor.INTEL_64 == processor) {
                    architecture = Architecture.OSX_64;
                } else if (Processor.PPC == processor) {
                    architecture = Architecture.OSX_PPC;
                }
            }
        }
        LOGGER.debug("architecture is " + (Object)((Object)architecture) + " os.name is " + System.getProperty("os.name").toLowerCase());
        return architecture;
    }

    private static Processor getProcessor() {
        Processor processor = Processor.UNKNOWN;
        String arch = System.getProperty("os.arch").toLowerCase();
        if (arch.contains("arm")) {
            processor = Processor.ARM;
        } else if (arch.contains("aarch64")) {
            processor = Processor.AARCH_64;
        } else if (arch.contains("ppc")) {
            int bits = 32;
            if (arch.contains("64")) {
                bits = 64;
            }
            processor = 32 == bits ? Processor.PPC : Processor.PPC_64;
        } else if (arch.contains("86") || arch.contains("amd")) {
            int bits = 32;
            if (arch.contains("64")) {
                bits = 64;
            }
            processor = 32 == bits ? Processor.INTEL_32 : Processor.INTEL_64;
        }
        LOGGER.debug("processor is " + (Object)((Object)processor) + " os.arch is " + System.getProperty("os.arch").toLowerCase());
        return processor;
    }

    public static String getPlatformLibraryPath(String searchPath) {
        if (archStr == null) {
            archStr = NativeLibraryUtil.getArchitecture().name().toLowerCase();
        }
        String fullSearchPath = (searchPath.equals("") || searchPath.endsWith(DELIM) ? searchPath : searchPath + DELIM) + archStr + DELIM;
        LOGGER.debug("platform specific path is " + fullSearchPath);
        return fullSearchPath;
    }

    public static String getPlatformLibraryName(String libName) {
        String name = null;
        switch (NativeLibraryUtil.getArchitecture()) {
            case AIX_32: 
            case AIX_64: 
            case LINUX_32: 
            case LINUX_64: 
            case LINUX_ARM: 
            case LINUX_ARM64: {
                name = "lib" + libName + ".so";
                break;
            }
            case WINDOWS_32: 
            case WINDOWS_64: {
                name = libName + ".dll";
                break;
            }
            case OSX_32: 
            case OSX_64: {
                name = "lib" + libName + ".dylib";
                break;
            }
        }
        LOGGER.debug("native library name " + name);
        return name;
    }

    public static String getVersionedLibraryName(Class<?> libraryJarClass, String libName) {
        String version = libraryJarClass.getPackage().getImplementationVersion();
        if (null != version && version.length() > 0) {
            libName = libName + "-" + version;
        }
        return libName;
    }

    public static boolean loadVersionedNativeLibrary(Class<?> libraryJarClass, String libName) {
        libName = NativeLibraryUtil.getVersionedLibraryName(libraryJarClass, libName);
        return NativeLibraryUtil.loadNativeLibrary(libraryJarClass, libName);
    }

    public static boolean loadNativeLibrary(JniExtractor jniExtractor, String libName, String ... searchPaths) {
        if (Architecture.UNKNOWN == NativeLibraryUtil.getArchitecture()) {
            LOGGER.warn("No native library available for this platform.");
        } else {
            try {
                LinkedList<String> libPaths = searchPaths == null ? new LinkedList<String>() : new LinkedList<String>(Arrays.asList(searchPaths));
                libPaths.add(0, DEFAULT_SEARCH_PATH);
                libPaths.add(1, "");
                libPaths.add(2, "META-INF/lib");
                for (String libPath : libPaths) {
                    File extracted = jniExtractor.extractJni(NativeLibraryUtil.getPlatformLibraryPath(libPath), libName);
                    if (extracted == null) continue;
                    System.load(extracted.getAbsolutePath());
                    return true;
                }
            }
            catch (UnsatisfiedLinkError e) {
                LOGGER.debug("Problem with library", (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.debug("Problem with extracting the library", (Throwable)e);
            }
        }
        return false;
    }

    @Deprecated
    public static boolean loadNativeLibrary(Class<?> libraryJarClass, String libName) {
        try {
            return NativeLibraryUtil.loadNativeLibrary(new DefaultJniExtractor(libraryJarClass), libName, new String[0]);
        }
        catch (IOException e) {
            LOGGER.debug("IOException creating DefaultJniExtractor", (Throwable)e);
            return false;
        }
    }

    private static enum Processor {
        UNKNOWN,
        INTEL_32,
        INTEL_64,
        PPC,
        PPC_64,
        ARM,
        AARCH_64;

    }

    public static enum Architecture {
        UNKNOWN,
        LINUX_32,
        LINUX_64,
        LINUX_ARM,
        LINUX_ARM64,
        WINDOWS_32,
        WINDOWS_64,
        OSX_32,
        OSX_64,
        OSX_PPC,
        AIX_32,
        AIX_64;

    }
}

