/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.dfdl.parser;

import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.daffodil.infoset.DIArray;
import org.apache.daffodil.infoset.DIComplex;
import org.apache.daffodil.infoset.DIElement;
import org.apache.daffodil.infoset.DISimple;
import org.apache.daffodil.japi.DataProcessor;
import org.apache.daffodil.japi.Diagnostic;
import org.apache.daffodil.japi.ParseResult;
import org.apache.daffodil.japi.infoset.InfosetOutputter;
import org.apache.daffodil.japi.io.InputSourceDataInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.lifecycle.LifecycleManager;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.reader.SmooksXMLReader;
import org.smooks.cartridges.dfdl.DataProcessorFactory;
import org.smooks.engine.injector.Scope;
import org.smooks.engine.lifecycle.PostConstructLifecyclePhase;
import org.smooks.engine.lookup.LifecycleManagerLookup;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.AttributesImpl;
import scala.xml.NamespaceBinding;
import scala.xml.TopScope$;

public class DfdlParser
implements SmooksXMLReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DfdlParser.class);
    private static final char[] INDENT = "\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t".toCharArray();
    protected DataProcessor dataProcessor;
    @Inject
    protected ApplicationContext applicationContext;
    @Inject
    private ResourceConfig resourceConfig;
    @Inject
    @Named(value="dataProcessorFactory")
    private Class<? extends DataProcessorFactory> dataProcessorFactoryClass;
    @Inject
    @Named(value="schemaURI")
    private String schemaUri;
    @Inject
    private Boolean indent = false;
    private DataProcessorFactory dataProcessorFactory;
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;
    private DTDHandler dtdHandler;

    public void setExecutionContext(ExecutionContext executionContext) {
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public void setEntityResolver(EntityResolver resolver) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setDTDHandler(DTDHandler dtdHandler) {
        this.dtdHandler = dtdHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @PostConstruct
    public void postConstruct() throws IllegalAccessException, InstantiationException {
        this.dataProcessorFactory = this.dataProcessorFactoryClass.newInstance();
        ((LifecycleManager)this.applicationContext.getRegistry().lookup((Function)new LifecycleManagerLookup())).applyPhase((Object)this.dataProcessorFactory, (LifecyclePhase)new PostConstructLifecyclePhase(new Scope(this.applicationContext.getRegistry(), this.resourceConfig, (Object)this.dataProcessorFactory)));
        this.dataProcessor = this.dataProcessorFactory.createDataProcessor();
    }

    public void parse(InputSource input) {
        InputSourceDataInputStream inputSourceDataInputStream = new InputSourceDataInputStream(input.getByteStream());
        ParseResult parseResult = null;
        while (parseResult == null || !parseResult.location().isAtEnd()) {
            parseResult = this.dataProcessor.parse(inputSourceDataInputStream, new InfosetOutputter(){
                private int elementLevel = 0;

                public void reset() {
                }

                public boolean startDocument() {
                    try {
                        DfdlParser.this.contentHandler.startDocument();
                    }
                    catch (SAXException e) {
                        throw new SmooksException(e.getMessage(), (Throwable)e);
                    }
                    return true;
                }

                public boolean endDocument() {
                    try {
                        DfdlParser.this.contentHandler.endDocument();
                    }
                    catch (SAXException e) {
                        throw new SmooksException(e.getMessage(), (Throwable)e);
                    }
                    return true;
                }

                public boolean startSimple(DISimple diSimple) {
                    try {
                        AttributesImpl attributes = this.createAttributes((DIElement)diSimple);
                        if (this.isNilled((DIElement)diSimple)) {
                            attributes.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "xsi:nil", "NMTOKEN", "true");
                        }
                        DfdlParser.this.indent(this.elementLevel);
                        DfdlParser.this.contentHandler.startElement(DfdlParser.this.getNamespaceUri((DIElement)diSimple), diSimple.erd().name(), this.getQName((DIElement)diSimple), attributes);
                        if (!this.isNilled((DIElement)diSimple) && diSimple.hasValue()) {
                            DfdlParser.this.contentHandler.characters(diSimple.dataValueAsString().toCharArray(), 0, diSimple.dataValueAsString().length());
                        }
                    }
                    catch (Exception e) {
                        throw new SmooksException(e.getMessage(), (Throwable)e);
                    }
                    return true;
                }

                public boolean endSimple(DISimple diSimple) {
                    try {
                        DfdlParser.this.contentHandler.endElement(DfdlParser.this.getNamespaceUri((DIElement)diSimple), diSimple.erd().name(), this.getQName((DIElement)diSimple));
                    }
                    catch (Exception e) {
                        throw new SmooksException(e.getMessage(), (Throwable)e);
                    }
                    return true;
                }

                public boolean startComplex(DIComplex diComplex) {
                    try {
                        DfdlParser.this.indent(this.elementLevel);
                        String nsUri = DfdlParser.this.getNamespaceUri((DIElement)diComplex);
                        DfdlParser.this.contentHandler.startElement(nsUri, diComplex.erd().name(), this.getQName((DIElement)diComplex), this.createAttributes((DIElement)diComplex));
                        ++this.elementLevel;
                        if (diComplex.isEmpty()) {
                            --this.elementLevel;
                            DfdlParser.this.contentHandler.endElement(nsUri, diComplex.erd().name(), this.getQName((DIElement)diComplex));
                        }
                    }
                    catch (SAXException e) {
                        throw new SmooksException(e.getMessage(), (Throwable)e);
                    }
                    return true;
                }

                private AttributesImpl createAttributes(DIElement diElement) {
                    NamespaceBinding nsbStart = diElement.erd().minimizedScope();
                    TopScope$ nsbEnd = diElement.isRoot() ? TopScope$.MODULE$ : diElement.diParent().erd().minimizedScope();
                    AttributesImpl attributes = new AttributesImpl();
                    if (nsbStart != nsbEnd) {
                        for (NamespaceBinding namespaceBinding = nsbStart; namespaceBinding != TopScope$.MODULE$; namespaceBinding = namespaceBinding.copy$default$3()) {
                            attributes.addAttribute("http://www.w3.org/2000/xmlns/", namespaceBinding.prefix(), "xmlns:" + namespaceBinding.prefix(), "CDATA", namespaceBinding.uri());
                        }
                    }
                    return attributes;
                }

                public boolean endComplex(DIComplex diComplex) {
                    try {
                        --this.elementLevel;
                        DfdlParser.this.indent(this.elementLevel);
                        DfdlParser.this.contentHandler.endElement(diComplex.erd().targetNamespace().toString(), diComplex.erd().name(), this.getQName((DIElement)diComplex));
                    }
                    catch (SAXException e) {
                        throw new SmooksException(e.getMessage(), (Throwable)e);
                    }
                    return true;
                }

                public boolean startArray(DIArray diArray) {
                    return true;
                }

                public boolean endArray(DIArray diArray) {
                    return true;
                }

                private String getQName(DIElement diElement) {
                    String prefix = diElement.erd().namedQName().prefixOrNull();
                    return prefix == null || prefix.equals("") ? "" : prefix + ":" + diElement.erd().name();
                }
            });
            if (parseResult.isError()) {
                for (Diagnostic diagnostic : parseResult.getDiagnostics()) {
                    if (diagnostic.isError()) {
                        throw new SmooksException(diagnostic.getSomeMessage(), diagnostic.getSomeCause());
                    }
                    LOGGER.debug(diagnostic.getSomeMessage());
                }
            }
            for (Diagnostic diagnostic : parseResult.getDiagnostics()) {
                LOGGER.debug(diagnostic.getSomeMessage());
            }
        }
    }

    public void parse(String systemId) {
    }

    private void indent(int elementLevel) throws SAXException {
        if (this.indent.booleanValue()) {
            this.contentHandler.characters(INDENT, 0, elementLevel + 1);
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setIndent(Boolean indent) {
        this.indent = indent;
    }

    public Class<? extends DataProcessorFactory> getDataProcessorFactoryClass() {
        return this.dataProcessorFactoryClass;
    }

    public void setDataProcessorFactoryClass(Class<? extends DataProcessorFactory> dataProcessorFactoryClass) {
        this.dataProcessorFactoryClass = dataProcessorFactoryClass;
    }

    public ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public void setResourceConfig(ResourceConfig resourceConfig) {
        this.resourceConfig = resourceConfig;
    }

    public String getSchemaUri() {
        return this.schemaUri;
    }

    public void setSchemaUri(String schemaUri) {
        this.schemaUri = schemaUri;
    }

    private String getNamespaceUri(DIElement diElement) {
        return diElement.erd().namedQName().namespace().isNoNamespace() ? "" : diElement.erd().namedQName().namespace().toString();
    }
}

