/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import java.util.UUID;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.MessageConverter;

public abstract class AbstractMessageConverter
implements MessageConverter {
    private boolean createMessageIds = false;

    public void setCreateMessageIds(boolean createMessageIds) {
        this.createMessageIds = createMessageIds;
    }

    protected boolean isCreateMessageIds() {
        return this.createMessageIds;
    }

    public final Message toMessage(Object object, MessageProperties messageProperties) throws MessageConversionException {
        if (messageProperties == null) {
            messageProperties = new MessageProperties();
        }
        Message message = this.createMessage(object, messageProperties);
        messageProperties = message.getMessageProperties();
        if (this.createMessageIds && messageProperties.getMessageId() == null) {
            messageProperties.setMessageId(UUID.randomUUID().toString());
        }
        return message;
    }

    protected abstract Message createMessage(Object var1, MessageProperties var2);

    public abstract Object fromMessage(Message var1) throws MessageConversionException;
}

