/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.annotation.support;

import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class PayloadArgumentResolver
implements HandlerMethodArgumentResolver {
    private final MessageConverter converter;

    public PayloadArgumentResolver(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"converter must not be null");
        this.converter = messageConverter;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return true;
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, Message<?> message) throws Exception {
        Class<?> sourceClass = message.getPayload().getClass();
        Class targetClass = parameter.getParameterType();
        if (ClassUtils.isAssignable((Class)targetClass, sourceClass)) {
            return message.getPayload();
        }
        Payload annot = (Payload)parameter.getParameterAnnotation(Payload.class);
        if (this.isEmptyPayload(message) && annot != null && !annot.required()) {
            return null;
        }
        if (annot != null && StringUtils.hasText((String)annot.value())) {
            throw new IllegalStateException("@Payload SpEL expressions not supported by this resolver.");
        }
        return this.converter.fromMessage(message, targetClass);
    }

    protected boolean isEmptyPayload(Message<?> message) {
        Object payload = message.getPayload();
        if (payload instanceof byte[]) {
            return ((byte[])message.getPayload()).length == 0;
        }
        if (payload instanceof String) {
            return ((String)payload).trim().equals("");
        }
        return false;
    }
}

