/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.stomp;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompConversionException;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class StompDecoder {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final byte[] HEARTBEAT_PAYLOAD = new byte[]{10};
    private final Log logger = LogFactory.getLog(StompDecoder.class);

    public Message<byte[]> decode(ByteBuffer buffer) {
        Message<byte[]> decodedMessage = null;
        this.skipLeadingEol(buffer);
        buffer.mark();
        String command = this.readCommand(buffer);
        if (command.length() > 0) {
            MultiValueMap<String, String> headers = this.readHeaders(buffer);
            byte[] payload = this.readPayload(buffer, headers);
            if (payload != null) {
                StompCommand stompCommand = StompCommand.valueOf(command);
                if (payload.length > 0 && !stompCommand.isBodyAllowed()) {
                    throw new StompConversionException((Object)((Object)stompCommand) + " shouldn't have but " + "has a payload with length=" + payload.length + ", headers=" + headers);
                }
                decodedMessage = MessageBuilder.withPayload(payload).setHeaders(StompHeaderAccessor.create(stompCommand, headers)).build();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Decoded " + decodedMessage));
                }
            } else {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Received incomplete frame. Resetting buffer");
                }
                buffer.reset();
            }
        } else {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Decoded heartbeat");
            }
            decodedMessage = MessageBuilder.withPayload(HEARTBEAT_PAYLOAD).setHeaders(StompHeaderAccessor.create(SimpMessageType.HEARTBEAT)).build();
        }
        return decodedMessage;
    }

    private void skipLeadingEol(ByteBuffer buffer) {
        while (this.isEol(buffer)) {
        }
    }

    private String readCommand(ByteBuffer buffer) {
        ByteArrayOutputStream command = new ByteArrayOutputStream();
        while (buffer.remaining() > 0 && !this.isEol(buffer)) {
            command.write(buffer.get());
        }
        return new String(command.toByteArray(), UTF8_CHARSET);
    }

    private MultiValueMap<String, String> readHeaders(ByteBuffer buffer) {
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        while (true) {
            ByteArrayOutputStream headerStream = new ByteArrayOutputStream();
            while (buffer.remaining() > 0 && !this.isEol(buffer)) {
                headerStream.write(buffer.get());
            }
            if (headerStream.size() <= 0) break;
            String header = new String(headerStream.toByteArray(), UTF8_CHARSET);
            int colonIndex = header.indexOf(58);
            if (colonIndex <= 0 || colonIndex == header.length() - 1) {
                if (buffer.remaining() <= 0) continue;
                throw new StompConversionException("Illegal header: '" + header + "'. A header must be of the form <name>:<value>");
            }
            String headerName = this.unescape(header.substring(0, colonIndex));
            String headerValue = this.unescape(header.substring(colonIndex + 1));
            headers.add((Object)headerName, (Object)headerValue);
        }
        return headers;
    }

    private String unescape(String input) {
        return input.replaceAll("\\\\n", "\n").replaceAll("\\\\r", "\r").replaceAll("\\\\c", ":").replaceAll("\\\\\\\\", "\\\\");
    }

    private byte[] readPayload(ByteBuffer buffer, MultiValueMap<String, String> headers) {
        String contentLengthString = (String)headers.getFirst((Object)"content-length");
        if (contentLengthString != null) {
            int contentLength = Integer.valueOf(contentLengthString);
            if (buffer.remaining() > contentLength) {
                byte[] payload = new byte[contentLength];
                buffer.get(payload);
                if (buffer.get() != 0) {
                    throw new StompConversionException("Frame must be terminated with a null octet");
                }
                return payload;
            }
            return null;
        }
        ByteArrayOutputStream payload = new ByteArrayOutputStream();
        while (buffer.remaining() > 0) {
            byte b = buffer.get();
            if (b == 0) {
                return payload.toByteArray();
            }
            payload.write(b);
        }
        return null;
    }

    private boolean isEol(ByteBuffer buffer) {
        if (buffer.remaining() > 0) {
            byte b = buffer.get();
            if (b == 10) {
                return true;
            }
            if (b == 13) {
                if (buffer.remaining() > 0 && buffer.get() == 10) {
                    return true;
                }
                throw new StompConversionException("'\\r' must be followed by '\\n'");
            }
            buffer.position(buffer.position() - 1);
        }
        return false;
    }
}

