/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.converter;

import java.nio.charset.Charset;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.util.MimeType;

public class StringMessageConverter
extends AbstractMessageConverter {
    private final Charset defaultCharset;

    public StringMessageConverter() {
        this(Charset.forName("UTF-8"));
    }

    public StringMessageConverter(Charset defaultCharset) {
        super(new MimeType("text", "plain", defaultCharset));
        this.defaultCharset = defaultCharset;
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return String.class.equals(clazz);
    }

    @Override
    public Object convertFromInternal(Message<?> message, Class<?> targetClass) {
        Charset charset = this.getContentTypeCharset(this.getMimeType(message.getHeaders()));
        Object payload = message.getPayload();
        return payload instanceof String ? payload : new String((byte[])payload, charset);
    }

    @Override
    public Object convertToInternal(Object payload, MessageHeaders headers) {
        if (byte[].class.equals(this.getSerializedPayloadClass())) {
            Charset charset = this.getContentTypeCharset(this.getMimeType(headers));
            payload = ((String)payload).getBytes(charset);
        }
        return payload;
    }

    private Charset getContentTypeCharset(MimeType mimeType) {
        if (mimeType != null && mimeType.getCharSet() != null) {
            return mimeType.getCharSet();
        }
        return this.defaultCharset;
    }
}

