/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.broker;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.broker.AbstractSubscriptionRegistry;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.PathMatcher;

public class DefaultSubscriptionRegistry
extends AbstractSubscriptionRegistry {
    public static final int DEFAULT_CACHE_LIMIT = 1024;
    private volatile int cacheLimit = 1024;
    private PathMatcher pathMatcher = new AntPathMatcher();
    private String selectorHeaderName = "selector";
    private ExpressionParser expressionParser = new SpelExpressionParser();
    private final DestinationCache destinationCache = new DestinationCache();
    private final SessionSubscriptionRegistry subscriptionRegistry = new SessionSubscriptionRegistry();

    public void setCacheLimit(int cacheLimit) {
        this.cacheLimit = cacheLimit;
    }

    public int getCacheLimit() {
        return this.cacheLimit;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public void setSelectorHeaderName(String selectorHeaderName) {
        Assert.notNull((Object)selectorHeaderName);
        this.selectorHeaderName = selectorHeaderName;
    }

    public String getSelectorHeaderName() {
        return this.selectorHeaderName;
    }

    @Override
    protected void addSubscriptionInternal(String sessionId, String subsId, String destination, Message<?> message) {
        Expression expression;
        block4: {
            expression = null;
            MessageHeaders headers = message.getHeaders();
            String selector = SimpMessageHeaderAccessor.getFirstNativeHeader(this.getSelectorHeaderName(), headers);
            if (selector != null) {
                try {
                    expression = this.expressionParser.parseExpression(selector);
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Subscription selector: [" + selector + "]"));
                    }
                }
                catch (Throwable ex) {
                    if (!this.logger.isDebugEnabled()) break block4;
                    this.logger.debug((Object)("Failed to parse selector: " + selector), ex);
                }
            }
        }
        this.subscriptionRegistry.addSubscription(sessionId, subsId, destination, expression);
        this.destinationCache.updateAfterNewSubscription(destination, sessionId, subsId);
    }

    @Override
    protected void removeSubscriptionInternal(String sessionId, String subsId, Message<?> message) {
        String destination;
        SessionSubscriptionInfo info = this.subscriptionRegistry.getSubscriptions(sessionId);
        if (info != null && (destination = info.removeSubscription(subsId)) != null) {
            this.destinationCache.updateAfterRemovedSubscription(sessionId, subsId);
        }
    }

    @Override
    public void unregisterAllSubscriptions(String sessionId) {
        SessionSubscriptionInfo info = this.subscriptionRegistry.removeSubscriptions(sessionId);
        if (info != null) {
            this.destinationCache.updateAfterRemovedSession(info);
        }
    }

    @Override
    protected MultiValueMap<String, String> findSubscriptionsInternal(String destination, Message<?> message) {
        LinkedMultiValueMap result = this.destinationCache.getSubscriptions(destination);
        if (result != null) {
            return this.filterSubscriptions((MultiValueMap<String, String>)result, message);
        }
        result = new LinkedMultiValueMap();
        for (SessionSubscriptionInfo info : this.subscriptionRegistry.getAllSubscriptions()) {
            for (String destinationPattern : info.getDestinations()) {
                if (!this.pathMatcher.match(destinationPattern, destination)) continue;
                for (Subscription subscription : info.getSubscriptions(destinationPattern)) {
                    result.add((Object)info.sessionId, (Object)subscription.getId());
                }
            }
        }
        if (!result.isEmpty()) {
            this.destinationCache.addSubscriptions(destination, (LinkedMultiValueMap<String, String>)result);
        }
        return this.filterSubscriptions((MultiValueMap<String, String>)result, message);
    }

    private MultiValueMap<String, String> filterSubscriptions(MultiValueMap<String, String> allMatches, Message<?> message) {
        StandardEvaluationContext context = null;
        LinkedMultiValueMap result = new LinkedMultiValueMap(allMatches.size());
        for (String sessionId : allMatches.keySet()) {
            for (String subId : (List)allMatches.get((Object)sessionId)) {
                Subscription sub;
                SessionSubscriptionInfo info = this.subscriptionRegistry.getSubscriptions(sessionId);
                if (info == null || (sub = info.getSubscription(subId)) == null) continue;
                Expression expression = sub.getSelectorExpression();
                if (expression == null) {
                    result.add((Object)sessionId, (Object)subId);
                    continue;
                }
                if (context == null) {
                    context = new StandardEvaluationContext(message);
                    context.getPropertyAccessors().add(new SimpMessageHeaderPropertyAccessor());
                }
                try {
                    if (!((Boolean)expression.getValue((EvaluationContext)context, Boolean.TYPE)).booleanValue()) continue;
                    result.add((Object)sessionId, (Object)subId);
                }
                catch (SpelEvaluationException ex) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Failed to evaluate selector: " + ex.getMessage()));
                }
                catch (Throwable ex) {
                    this.logger.debug((Object)"Failed to evaluate selector", ex);
                }
            }
        }
        return result;
    }

    public String toString() {
        return "DefaultSubscriptionRegistry[" + this.destinationCache + ", " + this.subscriptionRegistry + "]";
    }

    private static class SimpMessageHeaderPropertyAccessor
    implements PropertyAccessor {
        private SimpMessageHeaderPropertyAccessor() {
        }

        public Class<?>[] getSpecificTargetClasses() {
            return new Class[]{MessageHeaders.class};
        }

        public boolean canRead(EvaluationContext context, Object target, String name) {
            return true;
        }

        public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
            Object value;
            MessageHeaders headers = (MessageHeaders)target;
            SimpMessageHeaderAccessor accessor = MessageHeaderAccessor.getAccessor(headers, SimpMessageHeaderAccessor.class);
            if ("destination".equalsIgnoreCase(name)) {
                value = accessor.getDestination();
            } else {
                value = accessor.getFirstNativeHeader(name);
                if (value == null) {
                    value = headers.get(name);
                }
            }
            return new TypedValue(value);
        }

        public boolean canWrite(EvaluationContext context, Object target, String name) {
            return false;
        }

        public void write(EvaluationContext context, Object target, String name, Object value) {
        }
    }

    private static class Subscription {
        private final String id;
        private final Expression selectorExpression;

        public Subscription(String id, Expression selector) {
            this.id = id;
            this.selectorExpression = selector;
        }

        public String getId() {
            return this.id;
        }

        public Expression getSelectorExpression() {
            return this.selectorExpression;
        }

        public String toString() {
            return "subscription(id=" + this.id + ")";
        }
    }

    private static class SessionSubscriptionInfo {
        private final String sessionId;
        private final Map<String, Set<Subscription>> destinationLookup = new ConcurrentHashMap<String, Set<Subscription>>(4);

        public SessionSubscriptionInfo(String sessionId) {
            Assert.notNull((Object)sessionId, (String)"sessionId must not be null");
            this.sessionId = sessionId;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public Set<String> getDestinations() {
            return this.destinationLookup.keySet();
        }

        public Set<Subscription> getSubscriptions(String destination) {
            return this.destinationLookup.get(destination);
        }

        public Subscription getSubscription(String subscriptionId) {
            for (String destination : this.destinationLookup.keySet()) {
                Set<Subscription> subs = this.destinationLookup.get(destination);
                if (subs == null) continue;
                for (Subscription sub : subs) {
                    if (!sub.getId().equalsIgnoreCase(subscriptionId)) continue;
                    return sub;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSubscription(String destination, String subscriptionId, Expression selectorExpression) {
            Set<Subscription> subs = this.destinationLookup.get(destination);
            if (subs == null) {
                Map<String, Set<Subscription>> map = this.destinationLookup;
                synchronized (map) {
                    subs = this.destinationLookup.get(destination);
                    if (subs == null) {
                        subs = new CopyOnWriteArraySet<Subscription>();
                        this.destinationLookup.put(destination, subs);
                    }
                }
            }
            subs.add(new Subscription(subscriptionId, selectorExpression));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String removeSubscription(String subscriptionId) {
            for (String destination : this.destinationLookup.keySet()) {
                Set<Subscription> subs = this.destinationLookup.get(destination);
                if (subs == null) continue;
                for (Subscription sub : subs) {
                    if (!sub.getId().equals(subscriptionId) || !subs.remove(sub)) continue;
                    Map<String, Set<Subscription>> map = this.destinationLookup;
                    synchronized (map) {
                        if (subs.isEmpty()) {
                            this.destinationLookup.remove(destination);
                        }
                    }
                    return destination;
                }
            }
            return null;
        }

        public String toString() {
            return "[sessionId=" + this.sessionId + ", subscriptions=" + this.destinationLookup + "]";
        }
    }

    private static class SessionSubscriptionRegistry {
        private final ConcurrentMap<String, SessionSubscriptionInfo> sessions = new ConcurrentHashMap<String, SessionSubscriptionInfo>();

        private SessionSubscriptionRegistry() {
        }

        public SessionSubscriptionInfo getSubscriptions(String sessionId) {
            return (SessionSubscriptionInfo)this.sessions.get(sessionId);
        }

        public Collection<SessionSubscriptionInfo> getAllSubscriptions() {
            return this.sessions.values();
        }

        public SessionSubscriptionInfo addSubscription(String sessionId, String subscriptionId, String destination, Expression selectorExpression) {
            SessionSubscriptionInfo value;
            SessionSubscriptionInfo info = (SessionSubscriptionInfo)this.sessions.get(sessionId);
            if (info == null && (value = this.sessions.putIfAbsent(sessionId, info = new SessionSubscriptionInfo(sessionId))) != null) {
                info = value;
            }
            info.addSubscription(destination, subscriptionId, selectorExpression);
            return info;
        }

        public SessionSubscriptionInfo removeSubscriptions(String sessionId) {
            return (SessionSubscriptionInfo)this.sessions.remove(sessionId);
        }

        public String toString() {
            return "registry[" + this.sessions.size() + " sessions]";
        }
    }

    private class DestinationCache {
        private final Map<String, LinkedMultiValueMap<String, String>> accessCache = new ConcurrentHashMap<String, LinkedMultiValueMap<String, String>>(1024);
        private final Map<String, LinkedMultiValueMap<String, String>> updateCache = new LinkedHashMap<String, LinkedMultiValueMap<String, String>>(1024, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, LinkedMultiValueMap<String, String>> eldest) {
                return this.size() > DefaultSubscriptionRegistry.this.getCacheLimit();
            }
        };

        private DestinationCache() {
        }

        public LinkedMultiValueMap<String, String> getSubscriptions(String destination) {
            return this.accessCache.get(destination);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSubscriptions(String destination, LinkedMultiValueMap<String, String> subscriptions) {
            Map<String, LinkedMultiValueMap<String, String>> map = this.updateCache;
            synchronized (map) {
                this.updateCache.put(destination, (LinkedMultiValueMap<String, String>)subscriptions.deepCopy());
                this.accessCache.put(destination, subscriptions);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateAfterNewSubscription(String destination, String sessionId, String subsId) {
            Map<String, LinkedMultiValueMap<String, String>> map = this.updateCache;
            synchronized (map) {
                for (Map.Entry<String, LinkedMultiValueMap<String, String>> entry : this.updateCache.entrySet()) {
                    String cachedDestination = entry.getKey();
                    if (!DefaultSubscriptionRegistry.this.getPathMatcher().match(destination, cachedDestination)) continue;
                    LinkedMultiValueMap<String, String> subs = entry.getValue();
                    subs.add((Object)sessionId, (Object)subsId);
                    this.accessCache.put(cachedDestination, (LinkedMultiValueMap<String, String>)subs.deepCopy());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateAfterRemovedSubscription(String sessionId, String subsId) {
            Map<String, LinkedMultiValueMap<String, String>> map = this.updateCache;
            synchronized (map) {
                HashSet<String> destinationsToRemove = new HashSet<String>();
                for (Map.Entry<String, LinkedMultiValueMap<String, String>> entry : this.updateCache.entrySet()) {
                    String destination = entry.getKey();
                    LinkedMultiValueMap<String, String> sessionMap = entry.getValue();
                    List subscriptions = sessionMap.get((Object)sessionId);
                    if (subscriptions == null) continue;
                    subscriptions.remove(subsId);
                    if (subscriptions.isEmpty()) {
                        sessionMap.remove((Object)sessionId);
                    }
                    if (sessionMap.isEmpty()) {
                        destinationsToRemove.add(destination);
                        continue;
                    }
                    this.accessCache.put(destination, (LinkedMultiValueMap<String, String>)sessionMap.deepCopy());
                }
                for (String destination : destinationsToRemove) {
                    this.updateCache.remove(destination);
                    this.accessCache.remove(destination);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateAfterRemovedSession(SessionSubscriptionInfo info) {
            Map<String, LinkedMultiValueMap<String, String>> map = this.updateCache;
            synchronized (map) {
                HashSet<String> destinationsToRemove = new HashSet<String>();
                for (Map.Entry<String, LinkedMultiValueMap<String, String>> entry : this.updateCache.entrySet()) {
                    String destination = entry.getKey();
                    LinkedMultiValueMap<String, String> sessionMap = entry.getValue();
                    if (sessionMap.remove((Object)info.getSessionId()) == null) continue;
                    if (sessionMap.isEmpty()) {
                        destinationsToRemove.add(destination);
                        continue;
                    }
                    this.accessCache.put(destination, (LinkedMultiValueMap<String, String>)sessionMap.deepCopy());
                }
                for (String destination : destinationsToRemove) {
                    this.updateCache.remove(destination);
                    this.accessCache.remove(destination);
                }
            }
        }

        public String toString() {
            return "cache[" + this.accessCache.size() + " destination(s)]";
        }
    }
}

