/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.messaging.simp.config.TaskExecutorRegistration;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class ChannelRegistration {
    private TaskExecutorRegistration registration;
    private final List<ChannelInterceptor> interceptors = new ArrayList<ChannelInterceptor>();

    public TaskExecutorRegistration taskExecutor() {
        if (this.registration == null) {
            this.registration = new TaskExecutorRegistration();
        }
        return this.registration;
    }

    public TaskExecutorRegistration taskExecutor(ThreadPoolTaskExecutor taskExecutor) {
        if (this.registration == null) {
            this.registration = new TaskExecutorRegistration(taskExecutor);
        }
        return this.registration;
    }

    public ChannelRegistration setInterceptors(ChannelInterceptor ... interceptors) {
        if (interceptors != null) {
            this.interceptors.addAll(Arrays.asList(interceptors));
        }
        return this;
    }

    protected boolean hasTaskExecutor() {
        return this.registration != null;
    }

    protected TaskExecutorRegistration getTaskExecRegistration() {
        return this.registration;
    }

    protected TaskExecutorRegistration getOrCreateTaskExecRegistration() {
        return this.taskExecutor();
    }

    protected boolean hasInterceptors() {
        return !this.interceptors.isEmpty();
    }

    protected List<ChannelInterceptor> getInterceptors() {
        return this.interceptors;
    }
}

