/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.context;

import java.security.Principal;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.portlet.context.PortletRequestAttributes;

public class PortletWebRequest
extends PortletRequestAttributes
implements WebRequest {
    public PortletWebRequest(PortletRequest request) {
        super(request);
    }

    public String getParameter(String paramName) {
        return this.getRequest().getParameter(paramName);
    }

    public String[] getParameterValues(String paramName) {
        return this.getRequest().getParameterValues(paramName);
    }

    public Map getParameterMap() {
        return this.getRequest().getParameterMap();
    }

    public Locale getLocale() {
        return this.getRequest().getLocale();
    }

    public String getContextPath() {
        return this.getRequest().getContextPath();
    }

    public String getRemoteUser() {
        return this.getRequest().getRemoteUser();
    }

    public Principal getUserPrincipal() {
        return this.getRequest().getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        return this.getRequest().isUserInRole(role);
    }

    public boolean isSecure() {
        return this.getRequest().isSecure();
    }

    public String getDescription(boolean includeClientInfo) {
        PortletRequest request = this.getRequest();
        StringBuffer buffer = new StringBuffer();
        buffer.append("context=").append(request.getContextPath());
        if (includeClientInfo) {
            String user;
            PortletSession session = request.getPortletSession(false);
            if (session != null) {
                buffer.append(";session=").append(session.getId());
            }
            if (StringUtils.hasLength((String)(user = this.getRequest().getRemoteUser()))) {
                buffer.append(";user=" + user);
            }
        }
        return buffer.toString();
    }

    public String toString() {
        return "PortletWebRequest: " + this.getDescription(true);
    }
}

