/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.mvc.annotation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortalContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.style.StylerUtils;
import org.springframework.ui.ModelMap;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.DefaultSessionAttributeStore;
import org.springframework.web.bind.support.SessionAttributeStore;
import org.springframework.web.bind.support.SimpleSessionStatus;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.portlet.HandlerAdapter;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.MissingPortletRequestParameterException;
import org.springframework.web.portlet.bind.PortletRequestDataBinder;
import org.springframework.web.portlet.context.PortletWebRequest;
import org.springframework.web.portlet.handler.PortletContentGenerator;
import org.springframework.web.portlet.handler.PortletSessionRequiredException;
import org.springframework.web.portlet.multipart.MultipartActionRequest;
import org.springframework.web.portlet.util.PortletUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationMethodHandlerAdapter
extends PortletContentGenerator
implements HandlerAdapter {
    private static final String IMPLICIT_MODEL_ATTRIBUTE = "org.springframework.web.portlet.mvc.ImplicitModel";
    private WebBindingInitializer webBindingInitializer;
    private SessionAttributeStore sessionAttributeStore = new DefaultSessionAttributeStore();
    private final Map<Class<?>, HandlerMethodResolver> methodResolverCache = new ConcurrentHashMap();
    private final Map<Class<?>, Set<String>> sessionAttributeNames = new ConcurrentHashMap();

    public void setWebBindingInitializer(WebBindingInitializer webBindingInitializer) {
        this.webBindingInitializer = webBindingInitializer;
    }

    public void setSessionAttributeStore(SessionAttributeStore sessionAttributeStore) {
        Assert.notNull((Object)sessionAttributeStore, (String)"SessionAttributeStore must not be null");
        this.sessionAttributeStore = sessionAttributeStore;
    }

    @Override
    public boolean supports(Object handler) {
        return this.getMethodResolver(handler.getClass()).hasHandlerMethods();
    }

    @Override
    public void handleAction(ActionRequest request, ActionResponse response, Object handler) throws Exception {
        ModelAndView returnValue = this.doHandle((PortletRequest)request, (PortletResponse)response, handler);
        if (returnValue != null) {
            throw new IllegalStateException("Invalid action method return value: " + returnValue);
        }
    }

    @Override
    public ModelAndView handleRender(RenderRequest request, RenderResponse response, Object handler) throws Exception {
        this.checkAndPrepare(request, response);
        return this.doHandle((PortletRequest)request, (PortletResponse)response, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView doHandle(PortletRequest request, PortletResponse response, Object handler) throws Exception {
        ModelMap implicitModel = null;
        SessionAttributes sessionAttributes = handler.getClass().getAnnotation(SessionAttributes.class);
        Set<String> sessionAttrNames = null;
        if (sessionAttributes != null && (sessionAttrNames = this.sessionAttributeNames.get(handler.getClass())) == null) {
            Map<Class<?>, Set<String>> map = this.sessionAttributeNames;
            synchronized (map) {
                sessionAttrNames = this.sessionAttributeNames.get(handler.getClass());
                if (sessionAttrNames == null) {
                    sessionAttrNames = Collections.synchronizedSet(new HashSet(4));
                    this.sessionAttributeNames.put(handler.getClass(), sessionAttrNames);
                }
            }
        }
        if (request instanceof RenderRequest) {
            PortletSession session;
            RenderRequest renderRequest = (RenderRequest)request;
            RenderResponse renderResponse = (RenderResponse)response;
            if (renderRequest.getParameter(IMPLICIT_MODEL_ATTRIBUTE) != null && (session = request.getPortletSession(false)) != null) {
                implicitModel = (ModelMap)session.getAttribute(IMPLICIT_MODEL_ATTRIBUTE);
            }
            if (sessionAttributes != null) {
                this.checkAndPrepare(renderRequest, renderResponse, 0);
            } else {
                this.checkAndPrepare(renderRequest, renderResponse);
            }
        }
        if (implicitModel == null) {
            implicitModel = new ModelMap();
        }
        PortletWebRequest webRequest = new PortletWebRequest(request);
        HandlerMethodResolver methodResolver = this.getMethodResolver(handler.getClass());
        Method handlerMethod = methodResolver.resolveHandlerMethod(request);
        ArgumentsResolver argResolver = new ArgumentsResolver(methodResolver.getInitBinderMethods());
        for (Method attributeMethod : methodResolver.getModelAttributeMethods()) {
            Object[] args = argResolver.resolveArguments(handler, attributeMethod, request, response, webRequest, implicitModel, sessionAttrNames);
            ReflectionUtils.makeAccessible((Method)attributeMethod);
            Object attrValue = ReflectionUtils.invokeMethod((Method)attributeMethod, (Object)handler, (Object[])args);
            String attrName = attributeMethod.getAnnotation(ModelAttribute.class).value();
            if ("".equals(attrName)) {
                implicitModel.addAttribute(attrValue);
                continue;
            }
            implicitModel.addAttribute(attrName, attrValue);
        }
        Object[] args = argResolver.resolveArguments(handler, handlerMethod, request, response, webRequest, implicitModel, sessionAttrNames);
        ReflectionUtils.makeAccessible((Method)handlerMethod);
        Object result = ReflectionUtils.invokeMethod((Method)handlerMethod, (Object)handler, (Object[])args);
        ModelAndView mav = argResolver.getModelAndView(handlerMethod, result, implicitModel);
        if (sessionAttributes != null) {
            if (argResolver.isProcessingComplete()) {
                if (sessionAttrNames != null) {
                    for (String attrName : sessionAttrNames) {
                        this.sessionAttributeStore.cleanupAttribute((WebRequest)webRequest, attrName);
                    }
                }
            } else {
                Map model = mav != null ? mav.getModel() : implicitModel;
                HashSet<Object> sessionAttributeSet = new HashSet<Object>();
                sessionAttributeSet.addAll(Arrays.asList(sessionAttributes.value()));
                sessionAttributeSet.addAll(Arrays.asList(sessionAttributes.types()));
                for (Map.Entry entry : new HashSet(model.entrySet())) {
                    String attrName = (String)entry.getKey();
                    Object attrValue = entry.getValue();
                    if (!sessionAttributeSet.contains(attrName) && (attrValue == null || !sessionAttributeSet.contains(attrValue.getClass()))) continue;
                    sessionAttrNames.add(attrName);
                    this.sessionAttributeStore.storeAttribute((WebRequest)webRequest, attrName, attrValue);
                    String bindingResultKey = BindingResult.MODEL_KEY_PREFIX + attrName;
                    if (mav == null || model.containsKey(bindingResultKey)) continue;
                    PortletRequestDataBinder binder = new PortletRequestDataBinder(attrValue, attrName);
                    if (this.webBindingInitializer != null) {
                        this.webBindingInitializer.initBinder((WebDataBinder)binder, (WebRequest)webRequest);
                    }
                    mav.addObject(bindingResultKey, binder.getBindingResult());
                }
            }
        }
        if (response instanceof ActionResponse && !implicitModel.isEmpty()) {
            ActionResponse actionResponse = (ActionResponse)response;
            try {
                actionResponse.setRenderParameter(IMPLICIT_MODEL_ATTRIBUTE, Boolean.TRUE.toString());
                request.getPortletSession().setAttribute(IMPLICIT_MODEL_ATTRIBUTE, (Object)implicitModel);
            }
            catch (IllegalStateException ex) {
                // empty catch block
            }
        }
        return mav;
    }

    private HandlerMethodResolver getMethodResolver(Class<?> handlerType) {
        HandlerMethodResolver resolver = this.methodResolverCache.get(handlerType);
        if (resolver == null) {
            resolver = new HandlerMethodResolver(handlerType);
            this.methodResolverCache.put(handlerType, resolver);
        }
        return resolver;
    }

    private static class RequestMappingInfo {
        public String[] modes = new String[0];
        public String[] params = new String[0];
        private boolean action = false;
        private boolean render = false;

        private RequestMappingInfo() {
        }

        public boolean equals(Object obj) {
            RequestMappingInfo other = (RequestMappingInfo)obj;
            return this.action == other.action && this.render == other.render && this.modes.equals(other.modes) && this.params.equals(other.params);
        }

        public int hashCode() {
            return Arrays.hashCode(this.modes) * 29 + Arrays.hashCode(this.params);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArgumentsResolver {
        private final Set<Method> initBinderMethods;
        private final SimpleSessionStatus sessionStatus = new SimpleSessionStatus();

        public ArgumentsResolver(Set<Method> initBinderMethods) {
            this.initBinderMethods = initBinderMethods;
        }

        public Object[] resolveArguments(Object handler, Method handlerMethod, PortletRequest request, PortletResponse response, WebRequest webRequest, ModelMap implicitModel, Set<String> sessionAttrNames) throws PortletException, IOException {
            SessionAttributes sessionAttributes = handler.getClass().getAnnotation(SessionAttributes.class);
            HashSet<Object> sessionAttributeSet = null;
            if (sessionAttributes != null) {
                sessionAttributeSet = new HashSet<Object>();
                sessionAttributeSet.addAll(Arrays.asList(sessionAttributes.value()));
                sessionAttributeSet.addAll(Arrays.asList(sessionAttributes.types()));
            }
            SimpleTypeConverter converter = new SimpleTypeConverter();
            Object[] args = new Object[handlerMethod.getParameterTypes().length];
            String[] paramNames = null;
            boolean paramNamesResolved = false;
            for (int i = 0; i < args.length; ++i) {
                Object bindObject;
                MethodParameter param = new MethodParameter(handlerMethod, i);
                args[i] = this.resolveStandardArgument(param.getParameterType(), request, response, webRequest);
                if (args[i] == null) {
                    if (param.getParameterType().isInstance(implicitModel)) {
                        args[i] = implicitModel;
                    } else if (param.getParameterType().isInstance(this.sessionStatus)) {
                        args[i] = this.sessionStatus;
                    }
                }
                if (args[i] != null) continue;
                boolean isParam = false;
                String paramName = "";
                boolean paramRequired = false;
                String attrName = ClassUtils.getShortNameAsProperty((Class)param.getParameterType());
                Annotation[] paramAnns = (Annotation[])param.getParameterAnnotations();
                for (int j = 0; j < paramAnns.length; ++j) {
                    ModelAttribute attr;
                    Annotation paramAnn = paramAnns[j];
                    if (RequestParam.class.isInstance(paramAnn)) {
                        RequestParam requestParam = (RequestParam)paramAnn;
                        isParam = true;
                        paramName = requestParam.value();
                        paramRequired = requestParam.required();
                        break;
                    }
                    if (!ModelAttribute.class.isInstance(paramAnn) || "".equals((attr = (ModelAttribute)paramAnn).value())) continue;
                    attrName = attr.value();
                }
                if (isParam || BeanUtils.isSimpleProperty((Class)param.getParameterType())) {
                    if ("".equals(paramName)) {
                        if (!paramNamesResolved) {
                            LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();
                            paramNames = discoverer.getParameterNames(handlerMethod);
                            paramNamesResolved = true;
                        }
                        if (paramNames == null) {
                            throw new IllegalStateException("No parameter specified for @RequestParam argument of type [" + param.getParameterType().getName() + "], and no parameter name " + "information found in class file either.");
                        }
                        paramName = paramNames[i];
                    }
                    String[] paramValue = null;
                    if (request instanceof MultipartActionRequest) {
                        paramValue = ((MultipartActionRequest)request).getFile(paramName);
                    }
                    if (paramValue == null) {
                        paramValue = request.getParameterValues(paramName);
                    }
                    if (paramValue == null && paramRequired) {
                        throw new MissingPortletRequestParameterException(paramName, param.getParameterType().getName());
                    }
                    args[i] = converter.convertIfNecessary((Object)paramValue, param.getParameterType());
                    continue;
                }
                if (sessionAttributeSet != null && (sessionAttributeSet.contains(attrName) || sessionAttributeSet.contains(param.getParameterType())) && !implicitModel.containsKey((Object)attrName)) {
                    Object sessionAttr = AnnotationMethodHandlerAdapter.this.sessionAttributeStore.retrieveAttribute(webRequest, attrName);
                    if (sessionAttr == null) {
                        throw new PortletSessionRequiredException("Required session attribute '" + attrName + "' not found");
                    }
                    sessionAttrNames.add(attrName);
                    implicitModel.addAttribute(attrName, sessionAttr);
                }
                if ((bindObject = implicitModel.get((Object)attrName)) == null) {
                    bindObject = BeanUtils.instantiateClass((Class)param.getParameterType());
                }
                PortletRequestDataBinder binder = new PortletRequestDataBinder(bindObject, attrName);
                if (AnnotationMethodHandlerAdapter.this.webBindingInitializer != null) {
                    AnnotationMethodHandlerAdapter.this.webBindingInitializer.initBinder((WebDataBinder)binder, webRequest);
                }
                for (Method initBinderMethod : this.initBinderMethods) {
                    String[] targetNames = initBinderMethod.getAnnotation(InitBinder.class).value();
                    if (targetNames.length != 0 && !Arrays.asList(targetNames).contains(attrName)) continue;
                    Class<?>[] initBinderParams = initBinderMethod.getParameterTypes();
                    Object[] initBinderArgs = new Object[initBinderParams.length];
                    for (int j = 0; j < initBinderArgs.length; ++j) {
                        initBinderArgs[j] = this.resolveStandardArgument(initBinderParams[j], request, response, webRequest);
                        if (initBinderArgs[j] != null || !initBinderParams[j].isInstance((Object)binder)) continue;
                        initBinderArgs[j] = binder;
                    }
                    ReflectionUtils.makeAccessible((Method)initBinderMethod);
                    Object attrValue = ReflectionUtils.invokeMethod((Method)initBinderMethod, (Object)handler, (Object[])initBinderArgs);
                    if (attrValue == null) continue;
                    throw new IllegalStateException("InitBinder methods must not have a return value: " + initBinderMethod);
                }
                binder.bind(request);
                args[i] = bindObject;
                implicitModel.putAll(binder.getBindingResult().getModel());
                if (args.length > i + 1 && Errors.class.isAssignableFrom(handlerMethod.getParameterTypes()[i + 1])) {
                    args[i + 1] = binder.getBindingResult();
                    ++i;
                    continue;
                }
                binder.closeNoCatch();
            }
            return args;
        }

        private Object resolveStandardArgument(Class<?> parameterType, PortletRequest request, PortletResponse response, WebRequest webRequest) throws IOException {
            if (parameterType.isInstance(request)) {
                return request;
            }
            if (parameterType.isInstance(response)) {
                return response;
            }
            if (PortletSession.class.isAssignableFrom(parameterType)) {
                return request.getPortletSession();
            }
            if (PortletPreferences.class.isAssignableFrom(parameterType)) {
                return request.getPreferences();
            }
            if (PortletMode.class.isAssignableFrom(parameterType)) {
                return request.getPortletMode();
            }
            if (WindowState.class.isAssignableFrom(parameterType)) {
                return request.getWindowState();
            }
            if (PortalContext.class.isAssignableFrom(parameterType)) {
                return request.getPortalContext();
            }
            if (WebRequest.class.isAssignableFrom(parameterType)) {
                return webRequest;
            }
            if (Locale.class.equals(parameterType)) {
                return request.getLocale();
            }
            if (InputStream.class.equals(parameterType)) {
                if (!(request instanceof ActionRequest)) {
                    throw new IllegalStateException("InputStream can only get obtained for ActionRequest");
                }
                return ((ActionRequest)request).getPortletInputStream();
            }
            if (Reader.class.equals(parameterType)) {
                if (!(request instanceof ActionRequest)) {
                    throw new IllegalStateException("Reader can only get obtained for ActionRequest");
                }
                return ((ActionRequest)request).getReader();
            }
            if (OutputStream.class.equals(parameterType)) {
                if (!(response instanceof RenderResponse)) {
                    throw new IllegalStateException("OutputStream can only get obtained for RenderResponse");
                }
                return ((RenderResponse)response).getPortletOutputStream();
            }
            if (Writer.class.equals(parameterType)) {
                if (!(response instanceof RenderResponse)) {
                    throw new IllegalStateException("Writer can only get obtained for RenderResponse");
                }
                return ((RenderResponse)response).getWriter();
            }
            return null;
        }

        public boolean isProcessingComplete() {
            return this.sessionStatus.isComplete();
        }

        public ModelAndView getModelAndView(Method handlerMethod, Object returnValue, ModelMap implicitModel) {
            if (returnValue instanceof ModelAndView) {
                ModelAndView mav = (ModelAndView)returnValue;
                mav.getModelMap().mergeAttributes((Map)implicitModel);
                return mav;
            }
            if (returnValue instanceof Map) {
                return new ModelAndView().addAllObjects((Map)implicitModel).addAllObjects((Map)returnValue);
            }
            if (returnValue instanceof String) {
                return new ModelAndView((String)returnValue).addAllObjects((Map)implicitModel);
            }
            if (returnValue == null) {
                return null;
            }
            if (!BeanUtils.isSimpleProperty(returnValue.getClass())) {
                String attrName = handlerMethod.getAnnotation(ModelAttribute.class).value();
                ModelAndView mav = new ModelAndView().addAllObjects((Map)implicitModel);
                if ("".equals(attrName)) {
                    return mav.addObject(returnValue);
                }
                return mav.addObject(attrName, returnValue);
            }
            throw new IllegalArgumentException("Invalid handler method return value: " + returnValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HandlerMethodResolver {
        private final Set<Method> handlerMethods = new LinkedHashSet<Method>();
        private final Set<Method> initBinderMethods = new LinkedHashSet<Method>();
        private final Set<Method> modelAttributeMethods = new LinkedHashSet<Method>();

        public HandlerMethodResolver(Class<?> handlerType) {
            ReflectionUtils.doWithMethods(handlerType, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) {
                    if (method.isAnnotationPresent(RequestMapping.class)) {
                        HandlerMethodResolver.this.handlerMethods.add(method);
                    } else if (method.isAnnotationPresent(InitBinder.class)) {
                        HandlerMethodResolver.this.initBinderMethods.add(method);
                    } else if (method.isAnnotationPresent(ModelAttribute.class)) {
                        HandlerMethodResolver.this.modelAttributeMethods.add(method);
                    }
                }
            });
        }

        public Method resolveHandlerMethod(PortletRequest request) {
            String lookupMode = request.getPortletMode().toString();
            LinkedHashMap<RequestMappingInfo, Method> targetHandlerMethods = new LinkedHashMap<RequestMappingInfo, Method>();
            for (Method handlerMethod : this.handlerMethods) {
                Method oldMappedMethod;
                Object mapping = handlerMethod.getAnnotation(RequestMapping.class);
                RequestMappingInfo mappingInfo = new RequestMappingInfo();
                mappingInfo.modes = mapping.value();
                mappingInfo.params = mapping.params();
                mappingInfo.action = this.isActionMethod(handlerMethod);
                mappingInfo.render = this.isRenderMethod(handlerMethod);
                boolean match = false;
                if (mappingInfo.modes.length > 0) {
                    for (String mappedMode : mappingInfo.modes) {
                        if (!mappedMode.equalsIgnoreCase(lookupMode)) continue;
                        if (this.checkParameters(request, mappingInfo)) {
                            match = true;
                            continue;
                        }
                        break;
                    }
                } else {
                    match = this.checkParameters(request, mappingInfo);
                }
                if (!match || (oldMappedMethod = targetHandlerMethods.put(mappingInfo, handlerMethod)) == null || oldMappedMethod == handlerMethod) continue;
                throw new IllegalStateException("Ambiguous handler methods mapped for portlet mode '" + lookupMode + "': {" + oldMappedMethod + ", " + handlerMethod + "}. If you intend to handle the same mode in multiple methods, then factor " + "them out into a dedicated handler class with that mode mapped at the type level!");
            }
            if (!targetHandlerMethods.isEmpty()) {
                if (targetHandlerMethods.size() == 1) {
                    return (Method)targetHandlerMethods.values().iterator().next();
                }
                Object bestMappingMatch = null;
                for (Object mapping : targetHandlerMethods.keySet()) {
                    if (bestMappingMatch == null) {
                        bestMappingMatch = mapping;
                        continue;
                    }
                    if ((bestMappingMatch.modes.length != 0 || mapping.modes.length <= 0) && bestMappingMatch.params.length >= mapping.params.length) continue;
                    bestMappingMatch = mapping;
                }
                return (Method)targetHandlerMethods.get(bestMappingMatch);
            }
            throw new IllegalStateException("No matching handler method found for portlet request: mode '" + request.getPortletMode() + "', type '" + (request instanceof ActionRequest ? "action" : "render") + "', parameters " + StylerUtils.style((Object)request.getParameterMap()));
        }

        private boolean checkParameters(PortletRequest request, RequestMappingInfo mapping) {
            if (request instanceof RenderRequest ? mapping.action : request instanceof ActionRequest && mapping.render) {
                return false;
            }
            String[] params = mapping.params;
            if (params.length > 0) {
                for (String param : params) {
                    int separator = param.indexOf(61);
                    if (separator == -1) {
                        if (PortletUtils.hasSubmitParameter(request, param)) continue;
                        return false;
                    }
                    String key = param.substring(0, separator);
                    String value = param.substring(separator + 1);
                    if (value.equals(request.getParameter(key))) continue;
                    return false;
                }
            }
            return true;
        }

        private boolean isActionMethod(Method handlerMethod) {
            if (!Void.TYPE.equals(handlerMethod.getReturnType())) {
                return false;
            }
            for (Class<?> argType : handlerMethod.getParameterTypes()) {
                if (!ActionRequest.class.isAssignableFrom(argType) && !ActionResponse.class.isAssignableFrom(argType) && !InputStream.class.isAssignableFrom(argType) && !Reader.class.isAssignableFrom(argType)) continue;
                return true;
            }
            return false;
        }

        private boolean isRenderMethod(Method handlerMethod) {
            if (!Void.TYPE.equals(handlerMethod.getReturnType())) {
                return true;
            }
            for (Class<?> argType : handlerMethod.getParameterTypes()) {
                if (!RenderRequest.class.isAssignableFrom(argType) && !RenderResponse.class.isAssignableFrom(argType) && !OutputStream.class.isAssignableFrom(argType) && !Writer.class.isAssignableFrom(argType)) continue;
                return true;
            }
            return false;
        }

        public boolean hasHandlerMethods() {
            return !this.handlerMethods.isEmpty();
        }

        public Set<Method> getInitBinderMethods() {
            return this.initBinderMethods;
        }

        public Set<Method> getModelAttributeMethods() {
            return this.modelAttributeMethods;
        }
    }
}

