/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.mvc.annotation;

import java.lang.reflect.Method;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Controller;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.handler.AbstractMapBasedHandlerMapping;

public class DefaultAnnotationHandlerMapping
extends AbstractMapBasedHandlerMapping {
    public void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        this.detectHandlers();
    }

    protected void detectHandlers() throws BeansException {
        String[] beanNames;
        for (final String beanName : beanNames = this.getApplicationContext().getBeanNamesForType(Object.class)) {
            AbstractBeanDefinition abd;
            ConfigurableApplicationContext cac;
            BeanDefinition bd;
            ApplicationContext context = this.getApplicationContext();
            Class handlerType = context.getType(beanName);
            RequestMapping mapping = (RequestMapping)AnnotationUtils.findAnnotation((Class)handlerType, RequestMapping.class);
            if (mapping == null && context instanceof ConfigurableApplicationContext && context.containsBeanDefinition(beanName) && (bd = (cac = (ConfigurableApplicationContext)context).getBeanFactory().getMergedBeanDefinition(beanName)) instanceof AbstractBeanDefinition && (abd = (AbstractBeanDefinition)bd).hasBeanClass()) {
                Class beanClass = abd.getBeanClass();
                mapping = (RequestMapping)AnnotationUtils.findAnnotation((Class)beanClass, RequestMapping.class);
            }
            if (mapping != null) {
                String[] modeKeys;
                if (mapping.method().length > 0 || mapping.params().length > 0) {
                    throw new IllegalStateException("Only portlet mode value supported for RequestMapping annotation at the type level - map or parameters at the method level! Offending type: " + handlerType);
                }
                for (String modeKey : modeKeys = mapping.value()) {
                    this.registerHandler(new PortletMode(modeKey), beanName);
                }
                continue;
            }
            if (AnnotationUtils.findAnnotation((Class)handlerType, Controller.class) == null) continue;
            ReflectionUtils.doWithMethods((Class)handlerType, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) {
                    RequestMapping mapping = method.getAnnotation(RequestMapping.class);
                    if (mapping != null) {
                        String[] modeKeys;
                        for (String modeKey : modeKeys = mapping.value()) {
                            DefaultAnnotationHandlerMapping.this.registerHandler(new PortletMode(modeKey), beanName);
                        }
                    }
                }
            });
        }
    }

    protected Object getLookupKey(PortletRequest request) throws Exception {
        return request.getPortletMode();
    }
}

