/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public final class StringListAttributeDefinition
extends PrimitiveListAttributeDefinition {
    private StringListAttributeDefinition(Builder builder) {
        super(builder, ModelType.STRING);
    }

    public List<String> unwrap(ExpressionResolver context, ModelNode model) throws OperationFailedException {
        if (!model.hasDefined(this.getName())) {
            return Collections.emptyList();
        }
        return StringListAttributeDefinition.unwrapValue(context, model.get(this.getName()));
    }

    public static List<String> unwrapValue(ExpressionResolver context, ModelNode model) throws OperationFailedException {
        if (!model.isDefined()) {
            return null;
        }
        LinkedList<String> result = new LinkedList<String>();
        for (ModelNode p : model.asList()) {
            result.add(context.resolveExpressions(p).asString());
        }
        return result;
    }

    public void parseAndSetParameter(String value, ModelNode operation, XMLStreamReader reader) throws XMLStreamException {
        if (value != null) {
            for (String element : value.split(",")) {
                this.parseAndAddParameterElement(element, operation, reader);
            }
        }
    }

    public static class Builder
    extends ListAttributeDefinition.Builder<Builder, StringListAttributeDefinition> {
        public Builder(String name) {
            super(name);
            this.parser = AttributeParser.STRING_LIST;
            this.setElementValidator(new ModelTypeValidator(ModelType.STRING));
        }

        public Builder(StringListAttributeDefinition basic) {
            super(basic);
            this.parser = AttributeParser.STRING_LIST;
        }

        @Override
        public StringListAttributeDefinition build() {
            return new StringListAttributeDefinition(this);
        }
    }
}

