/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.capability.registry;

import org.jboss.as.controller.capability.registry.CapabilityContext;
import org.jboss.as.controller.capability.registry.RequirementRegistration;
import org.jboss.as.controller.capability.registry.RuntimeCapabilityRegistration;
import org.jboss.as.controller.capability.registry.RuntimeCapabilityRegistry;
import org.jboss.as.controller.capability.registry.RuntimeRequirementRegistration;

public class DelegatingRuntimeCapabilityRegistry
implements RuntimeCapabilityRegistry {
    private final CapabilityRegistryDelegateProvider delegateProvider;

    public DelegatingRuntimeCapabilityRegistry(final RuntimeCapabilityRegistry delegate) {
        this(new CapabilityRegistryDelegateProvider(){

            @Override
            public RuntimeCapabilityRegistry getDelegateCapabilityRegistry() {
                return delegate;
            }
        });
    }

    public DelegatingRuntimeCapabilityRegistry(CapabilityRegistryDelegateProvider delegateProvider) {
        this.delegateProvider = delegateProvider;
    }

    @Override
    public void registerCapability(RuntimeCapabilityRegistration capability) {
        this.getDelegate().registerCapability(capability);
    }

    @Override
    public void registerAdditionalCapabilityRequirement(RuntimeRequirementRegistration requirementRegistration) {
        this.getDelegate().registerAdditionalCapabilityRequirement(requirementRegistration);
    }

    @Override
    public void removeCapabilityRequirement(RequirementRegistration requirementRegistration) {
        this.getDelegate().removeCapabilityRequirement(requirementRegistration);
    }

    @Override
    public RuntimeCapabilityRegistration removeCapability(String capability, CapabilityContext context) {
        return (RuntimeCapabilityRegistration)this.getDelegate().removeCapability(capability, context);
    }

    @Override
    public boolean hasCapability(String capabilityName, CapabilityContext context) {
        return this.getDelegate().hasCapability(capabilityName, context);
    }

    @Override
    public <T> T getCapabilityRuntimeAPI(String capabilityName, CapabilityContext context, Class<T> apiType) {
        return this.getDelegate().getCapabilityRuntimeAPI(capabilityName, context, apiType);
    }

    private RuntimeCapabilityRegistry getDelegate() {
        return this.delegateProvider.getDelegateCapabilityRegistry();
    }

    public static interface CapabilityRegistryDelegateProvider {
        public RuntimeCapabilityRegistry getDelegateCapabilityRegistry();
    }
}

