/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.parsing;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.dmr.ValueExpression;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public final class ParseUtils {
    private ParseUtils() {
    }

    public static Element nextElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.nextTag() == 2) {
            return null;
        }
        return Element.forName(reader.getLocalName());
    }

    public static Element nextElement(XMLExtendedStreamReader reader, Namespace expectedNamespace) throws XMLStreamException {
        Element element = ParseUtils.nextElement(reader);
        if (element == null) {
            return element;
        }
        if (element != Element.UNKNOWN && expectedNamespace.equals((Object)Namespace.forUri(reader.getNamespaceURI()))) {
            return element;
        }
        throw ParseUtils.unexpectedElement(reader);
    }

    public static XMLStreamException unexpectedElement(XMLExtendedStreamReader reader) {
        return ControllerLogger.ROOT_LOGGER.unexpectedElement(reader.getName(), reader.getLocation());
    }

    public static XMLStreamException unexpectedElement(XMLExtendedStreamReader reader, Set<String> possible) {
        return ControllerLogger.ROOT_LOGGER.unexpectedElement(reader.getName(), ParseUtils.asStringList(possible), reader.getLocation());
    }

    public static XMLStreamException unexpectedEndElement(XMLExtendedStreamReader reader) {
        return ControllerLogger.ROOT_LOGGER.unexpectedEndElement(reader.getName(), reader.getLocation());
    }

    public static XMLStreamException unexpectedAttribute(XMLExtendedStreamReader reader, int index) {
        return ControllerLogger.ROOT_LOGGER.unexpectedAttribute(reader.getAttributeName(index), reader.getLocation());
    }

    public static XMLStreamException unexpectedAttribute(XMLExtendedStreamReader reader, int index, Set<String> possibleAttributes) {
        return ControllerLogger.ROOT_LOGGER.unexpectedAttribute(reader.getAttributeName(index), ParseUtils.asStringList(possibleAttributes), reader.getLocation());
    }

    private static StringBuilder asStringList(Set<?> attributes) {
        StringBuilder b = new StringBuilder();
        Iterator<?> iterator = attributes.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            b.append(o.toString());
            if (!iterator.hasNext()) continue;
            b.append(", ");
        }
        return b;
    }

    public static XMLStreamException invalidAttributeValue(XMLExtendedStreamReader reader, int index) {
        return ControllerLogger.ROOT_LOGGER.invalidAttributeValue(reader.getAttributeValue(index), reader.getAttributeName(index), reader.getLocation());
    }

    public static XMLStreamException missingRequired(XMLExtendedStreamReader reader, Set<?> required) {
        return ControllerLogger.ROOT_LOGGER.missingRequiredAttributes(ParseUtils.asStringList(required), reader.getLocation());
    }

    public static XMLStreamException missingRequired(XMLExtendedStreamReader reader, String ... required) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < required.length; ++i) {
            String o = required[i];
            b.append(o);
            if (required.length <= i + 1) continue;
            b.append(", ");
        }
        return ControllerLogger.ROOT_LOGGER.missingRequiredAttributes(b, reader.getLocation());
    }

    public static XMLStreamException missingRequiredElement(XMLExtendedStreamReader reader, Set<?> required) {
        StringBuilder b = new StringBuilder();
        Iterator<?> iterator = required.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            b.append(o.toString());
            if (!iterator.hasNext()) continue;
            b.append(", ");
        }
        return ControllerLogger.ROOT_LOGGER.missingRequiredElements(b, reader.getLocation());
    }

    public static XMLStreamException missingOneOf(XMLExtendedStreamReader reader, Set<?> required) {
        StringBuilder b = new StringBuilder();
        Iterator<?> iterator = required.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            b.append(o.toString());
            if (!iterator.hasNext()) continue;
            b.append(", ");
        }
        return ControllerLogger.ROOT_LOGGER.missingOneOf(b, reader.getLocation());
    }

    public static void requireNoAttributes(XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute(reader, 0);
        }
    }

    public static void requireNoContent(XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.hasNext() && reader.nextTag() != 2) {
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    public static void requireNamespace(XMLExtendedStreamReader reader, Namespace requiredNs) throws XMLStreamException {
        Namespace actualNs = Namespace.forUri(reader.getNamespaceURI());
        if (actualNs != requiredNs) {
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    public static XMLStreamException duplicateAttribute(XMLExtendedStreamReader reader, String name) {
        return ControllerLogger.ROOT_LOGGER.duplicateAttribute(name, reader.getLocation());
    }

    public static XMLStreamException duplicateNamedElement(XMLExtendedStreamReader reader, String name) {
        return ControllerLogger.ROOT_LOGGER.duplicateNamedElement(name, reader.getLocation());
    }

    public static boolean readBooleanAttributeElement(XMLExtendedStreamReader reader, String attributeName) throws XMLStreamException {
        ParseUtils.requireSingleAttribute(reader, attributeName);
        boolean value = Boolean.parseBoolean(reader.getAttributeValue(0));
        ParseUtils.requireNoContent(reader);
        return value;
    }

    public static String readStringAttributeElement(XMLExtendedStreamReader reader, String attributeName) throws XMLStreamException {
        ParseUtils.requireSingleAttribute(reader, attributeName);
        String value = reader.getAttributeValue(0);
        ParseUtils.requireNoContent(reader);
        return value;
    }

    public static <T> List<T> readListAttributeElement(XMLExtendedStreamReader reader, String attributeName, Class<T> type) throws XMLStreamException {
        ParseUtils.requireSingleAttribute(reader, attributeName);
        List value = reader.getListAttributeValue(0, type);
        ParseUtils.requireNoContent(reader);
        return value;
    }

    public static Property readProperty(XMLExtendedStreamReader reader) throws XMLStreamException {
        return ParseUtils.readProperty(reader, false);
    }

    public static Property readProperty(XMLExtendedStreamReader reader, boolean supportsExpressions) throws XMLStreamException {
        int cnt = reader.getAttributeCount();
        String name = null;
        ModelNode value = null;
        for (int i = 0; i < cnt; ++i) {
            String uri = reader.getAttributeNamespace(i);
            if (uri != null && !"".equals("")) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            String localName = reader.getAttributeLocalName(i);
            if (localName.equals("name")) {
                name = reader.getAttributeValue(i);
                continue;
            }
            if (localName.equals("value")) {
                if (supportsExpressions) {
                    value = ParseUtils.parsePossibleExpression(reader.getAttributeValue(i));
                    continue;
                }
                value = new ModelNode(reader.getAttributeValue(i));
                continue;
            }
            throw ParseUtils.unexpectedAttribute(reader, i);
        }
        if (name == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton("name"));
        }
        if (reader.next() != 2) {
            throw ParseUtils.unexpectedElement(reader);
        }
        return new Property(name, new ModelNode().set(value == null ? new ModelNode() : value));
    }

    public static <T> T[] readArrayAttributeElement(XMLExtendedStreamReader reader, String attributeName, Class<T> type) throws XMLStreamException {
        List<Object> list = ParseUtils.readListAttributeElement(reader, attributeName, type);
        return list.toArray((Object[])Array.newInstance(type, list.size()));
    }

    public static void requireSingleAttribute(XMLExtendedStreamReader reader, String attributeName) throws XMLStreamException {
        int count = reader.getAttributeCount();
        if (count == 0) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(attributeName));
        }
        ParseUtils.requireNoNamespaceAttribute(reader, 0);
        if (!attributeName.equals(reader.getAttributeLocalName(0))) {
            throw ParseUtils.unexpectedAttribute(reader, 0);
        }
        if (count > 1) {
            throw ParseUtils.unexpectedAttribute(reader, 1);
        }
    }

    public static String[] requireAttributes(XMLExtendedStreamReader reader, String ... attributeNames) throws XMLStreamException {
        int length = attributeNames.length;
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            String name = attributeNames[i];
            String value = reader.getAttributeValue(null, name);
            if (value == null) {
                throw ParseUtils.missingRequired(reader, Collections.singleton(name));
            }
            result[i] = value;
        }
        return result;
    }

    public static boolean isNoNamespaceAttribute(XMLExtendedStreamReader reader, int index) {
        String namespace = reader.getAttributeNamespace(index);
        return namespace == null || "".equals(namespace);
    }

    public static void requireNoNamespaceAttribute(XMLExtendedStreamReader reader, int index) throws XMLStreamException {
        if (!ParseUtils.isNoNamespaceAttribute(reader, index)) {
            throw ParseUtils.unexpectedAttribute(reader, index);
        }
    }

    public static ModelNode parseBoundedIntegerAttribute(XMLExtendedStreamReader reader, int index, int minInclusive, int maxInclusive, boolean allowExpression) throws XMLStreamException {
        ModelNode expression;
        String stringValue = reader.getAttributeValue(index);
        if (allowExpression && (expression = ParseUtils.parsePossibleExpression(stringValue)).getType() == ModelType.EXPRESSION) {
            return expression;
        }
        try {
            int value = Integer.parseInt(stringValue);
            if (value < minInclusive || value > maxInclusive) {
                throw ControllerLogger.ROOT_LOGGER.invalidAttributeValue(value, reader.getAttributeName(index), minInclusive, maxInclusive, reader.getLocation());
            }
            return new ModelNode().set(value);
        }
        catch (NumberFormatException nfe) {
            throw ControllerLogger.ROOT_LOGGER.invalidAttributeValueInt(nfe, stringValue, reader.getAttributeName(index), reader.getLocation());
        }
    }

    public static boolean isExpression(String value) {
        int openIdx = value.indexOf("${");
        return openIdx > -1 && value.lastIndexOf(125) > openIdx;
    }

    public static ModelNode parsePossibleExpression(String value) {
        ModelNode result = new ModelNode();
        if (ParseUtils.isExpression(value)) {
            result.set(new ValueExpression(value));
        } else {
            result.set(value);
        }
        return result;
    }

    public static String getWarningMessage(String msg, Location location) {
        return ControllerLogger.ROOT_LOGGER.parsingProblem(location.getLineNumber(), location.getColumnNumber(), msg);
    }

    public static XMLStreamException unsupportedElement(XMLExtendedStreamReader reader, String supportedElement) {
        return ControllerLogger.ROOT_LOGGER.unsupportedElement(new QName(reader.getNamespaceURI(), reader.getLocalName(), reader.getPrefix()), reader.getLocation(), supportedElement);
    }
}

