/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLMapper;

public abstract class AbstractConfigurationPersister
implements ExtensibleConfigurationPersister {
    private final XMLElementWriter<ModelMarshallingContext> rootDeparser;
    private final Map<String, XMLElementWriter<SubsystemMarshallingContext>> subsystemWriters = new HashMap<String, XMLElementWriter<SubsystemMarshallingContext>>();
    private final Map<String, XMLElementWriter<SubsystemMarshallingContext>> subsystemDeploymentWriters = new HashMap<String, XMLElementWriter<SubsystemMarshallingContext>>();

    public AbstractConfigurationPersister(XMLElementWriter<ModelMarshallingContext> rootDeparser) {
        this.rootDeparser = rootDeparser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSubsystemWriter(String name, XMLElementWriter<SubsystemMarshallingContext> deparser) {
        Map<String, XMLElementWriter<SubsystemMarshallingContext>> map = this.subsystemWriters;
        synchronized (map) {
            this.subsystemWriters.put(name, deparser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterSubsystemWriter(String name) {
        Map<String, XMLElementWriter<SubsystemMarshallingContext>> map = this.subsystemWriters;
        synchronized (map) {
            this.subsystemWriters.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSubsystemDeploymentWriter(String name, XMLElementWriter<SubsystemMarshallingContext> deparser) {
        Map<String, XMLElementWriter<SubsystemMarshallingContext>> map = this.subsystemDeploymentWriters;
        synchronized (map) {
            this.subsystemDeploymentWriters.put(name, deparser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterSubsystemDeploymentWriter(String name) {
        Map<String, XMLElementWriter<SubsystemMarshallingContext>> map = this.subsystemDeploymentWriters;
        synchronized (map) {
            this.subsystemDeploymentWriters.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshallAsXml(final ModelNode model, OutputStream output) throws ConfigurationPersistenceException {
        XMLMapper mapper = XMLMapper.Factory.create();
        try {
            XMLStreamWriter streamWriter = null;
            try {
                streamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(output);
                ModelMarshallingContext extensibleModel = new ModelMarshallingContext(){

                    @Override
                    public ModelNode getModelNode() {
                        return model;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public XMLElementWriter<SubsystemMarshallingContext> getSubsystemWriter(String extensionName) {
                        Map map = AbstractConfigurationPersister.this.subsystemWriters;
                        synchronized (map) {
                            return (XMLElementWriter)AbstractConfigurationPersister.this.subsystemWriters.get(extensionName);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public XMLElementWriter<SubsystemMarshallingContext> getSubsystemDeploymentWriter(String extensionName) {
                        Map map = AbstractConfigurationPersister.this.subsystemDeploymentWriters;
                        synchronized (map) {
                            return (XMLElementWriter)AbstractConfigurationPersister.this.subsystemDeploymentWriters.get(extensionName);
                        }
                    }
                };
                mapper.deparseDocument(this.rootDeparser, (Object)extensibleModel, streamWriter);
                streamWriter.close();
            }
            finally {
                AbstractConfigurationPersister.safeClose(streamWriter);
            }
        }
        catch (Exception e) {
            throw ControllerLogger.ROOT_LOGGER.failedToWriteConfiguration(e);
        }
    }

    @Override
    public void successfulBoot() throws ConfigurationPersistenceException {
    }

    @Override
    public String snapshot() throws ConfigurationPersistenceException {
        return null;
    }

    @Override
    public ConfigurationPersister.SnapshotInfo listSnapshots() {
        return NULL_SNAPSHOT_INFO;
    }

    @Override
    public void deleteSnapshot(String name) {
    }

    private static void safeClose(XMLStreamWriter streamWriter) {
        if (streamWriter != null) {
            try {
                streamWriter.close();
            }
            catch (Throwable t) {
                ControllerLogger.ROOT_LOGGER.failedToCloseResource(t, streamWriter);
            }
        }
    }
}

