/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.StartException;

public final class ServiceVerificationHandler
extends AbstractServiceListener<Object>
implements ServiceListener<Object>,
OperationStepHandler {
    private final StabilityMonitor monitor = new StabilityMonitor();

    public synchronized void listenerAdded(ServiceController<?> controller) {
        this.monitor.addController(controller);
        controller.removeListener((ServiceListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void execute(OperationContext context, ModelNode operation) {
        HashSet failed = new HashSet();
        HashSet problems = new HashSet();
        try {
            this.monitor.awaitStability(failed, problems);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            context.getFailureDescription().set(ControllerLogger.ROOT_LOGGER.operationCancelled());
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            return;
        }
        finally {
            this.monitor.clear();
        }
        if (!failed.isEmpty() || !problems.isEmpty()) {
            SortedSet<ServiceName> allMissing;
            HashSet<ServiceController> missingTransitive = null;
            HashSet<ServiceName> trackedServices = new HashSet<ServiceName>();
            ModelNode failureDescription = context.getFailureDescription();
            ModelNode failedList = null;
            for (ServiceController controller : failed) {
                if (failedList == null) {
                    failedList = failureDescription.get(ControllerLogger.ROOT_LOGGER.failedServices());
                }
                ServiceName serviceName = controller.getName();
                trackedServices.add(serviceName);
                failedList.get(serviceName.getCanonicalName()).set(ServiceVerificationHandler.getServiceFailureDescription(controller.getStartException()));
            }
            ModelNode problemList = null;
            for (ServiceController controller : problems) {
                Set immediatelyUnavailable = controller.getImmediateUnavailableDependencies();
                if (!immediatelyUnavailable.isEmpty()) {
                    if (problemList == null) {
                        problemList = failureDescription.get(ControllerLogger.ROOT_LOGGER.servicesMissingDependencies());
                    }
                    StringBuilder missing = new StringBuilder();
                    Iterator i = immediatelyUnavailable.iterator();
                    while (i.hasNext()) {
                        ServiceName missingSvc = (ServiceName)i.next();
                        trackedServices.add(missingSvc);
                        missing.append(missingSvc.getCanonicalName());
                        if (!i.hasNext()) continue;
                        missing.append(", ");
                    }
                    StringBuilder problem = new StringBuilder();
                    problem.append(controller.getName().getCanonicalName());
                    problem.append(" ").append(ControllerLogger.ROOT_LOGGER.servicesMissing(missing));
                    problemList.add(problem.toString());
                    continue;
                }
                if (missingTransitive == null) {
                    missingTransitive = new HashSet<ServiceController>();
                }
                missingTransitive.add(controller);
            }
            if (missingTransitive != null && !(allMissing = ServiceVerificationHandler.findAllMissingServices(missingTransitive, trackedServices)).isEmpty()) {
                ModelNode missingTransitiveDesc = failureDescription.get(ControllerLogger.ROOT_LOGGER.missingTransitiveDependencyProblem());
                ModelNode missingTransitiveDeps = missingTransitiveDesc.get(ControllerLogger.ROOT_LOGGER.missingTransitiveDependents());
                TreeSet<ServiceName> sortedNames = new TreeSet<ServiceName>();
                for (ServiceController serviceController : missingTransitive) {
                    sortedNames.add(serviceController.getName());
                }
                for (ServiceName serviceName : sortedNames) {
                    missingTransitiveDeps.add(serviceName.getCanonicalName());
                }
                ModelNode allMissingList = missingTransitiveDesc.get(ControllerLogger.ROOT_LOGGER.missingTransitiveDependencies());
                for (ServiceName serviceName : allMissing) {
                    allMissingList.add(serviceName.getCanonicalName());
                }
            }
            if (context.isRollbackOnRuntimeFailure()) {
                context.setRollbackOnly();
            }
        }
        context.stepCompleted();
    }

    private static ModelNode getServiceFailureDescription(StartException exception) {
        ModelNode result = new ModelNode();
        if (exception != null) {
            StringBuilder sb = new StringBuilder(exception.toString());
            for (Throwable cause = exception.getCause(); cause != null; cause = cause.getCause()) {
                sb.append("\n    Caused by: ");
                sb.append(cause.toString());
            }
            result.set(sb.toString());
        }
        return result;
    }

    private static SortedSet<ServiceName> findAllMissingServices(Set<ServiceController<?>> missingTransitive, Set<ServiceName> alreadyTracked) {
        HashSet<ServiceContainer> examined = new HashSet<ServiceContainer>();
        TreeSet<ServiceName> result = new TreeSet<ServiceName>();
        for (ServiceController<?> controller : missingTransitive) {
            ServiceContainer container = controller.getServiceContainer();
            if (!examined.add(container)) continue;
            result.addAll(ServiceVerificationHandler.findAllMissingServices(container));
        }
        HashSet retain = new HashSet(result);
        retain.removeAll(alreadyTracked);
        if (retain.size() == 0) {
            result.clear();
        }
        return result;
    }

    private static Set<ServiceName> findAllMissingServices(ServiceContainer container) {
        HashSet<ServiceName> result = new HashSet<ServiceName>();
        for (ServiceName serviceName : container.getServiceNames()) {
            ServiceController controller = container.getService(serviceName);
            if (controller == null || controller.getMode() == ServiceController.Mode.NEVER || controller.getMode() == ServiceController.Mode.REMOVE || controller.getSubstate() != ServiceController.Substate.PROBLEM) continue;
            result.addAll(controller.getImmediateUnavailableDependencies());
        }
        return result;
    }

    static ModelNode extractFailedServicesDescription(ModelNode failureDescription) {
        return ServiceVerificationHandler.extractIfPresent(ControllerLogger.ROOT_LOGGER.failedServices(), failureDescription);
    }

    static ModelNode extractMissingServicesDescription(ModelNode failureDescription) {
        return ServiceVerificationHandler.extractIfPresent(ControllerLogger.ROOT_LOGGER.servicesMissingDependencies(), failureDescription);
    }

    static ModelNode extractTransitiveDependencyProblemDescription(ModelNode failureDescription) {
        return ServiceVerificationHandler.extractIfPresent(ControllerLogger.ROOT_LOGGER.missingTransitiveDependencyProblem(), failureDescription);
    }

    private static ModelNode extractIfPresent(String key, ModelNode modelNode) {
        ModelNode result = null;
        if (modelNode.hasDefined(key)) {
            result = modelNode.get(key);
        }
        return result;
    }
}

