/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform.description;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.PathAddressTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.description.AttributeTransformationDescription;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilderImpl;
import org.jboss.as.controller.transform.description.DiscardPolicy;
import org.jboss.as.controller.transform.description.OperationTransformationRules;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformingDescription;

abstract class AbstractTransformationDescriptionBuilder
implements TransformationDescriptionBuilder {
    protected final PathElement pathElement;
    protected PathAddressTransformer pathAddressTransformer;
    protected ResourceTransformer resourceTransformer;
    protected OperationTransformer operationTransformer;
    protected final Map<String, OperationTransformationEntry> operationTransformers = new HashMap<String, OperationTransformationEntry>();
    protected final List<TransformationDescriptionBuilder> children = new ArrayList<TransformationDescriptionBuilder>();

    protected AbstractTransformationDescriptionBuilder(PathElement pathElement, PathAddressTransformer pathAddressTransformer, ResourceTransformer resourceTransformer, OperationTransformer operationTransformer) {
        this.pathElement = pathElement;
        this.pathAddressTransformer = pathAddressTransformer;
        this.resourceTransformer = resourceTransformer;
        this.operationTransformer = operationTransformer;
    }

    public TransformationDescriptionBuilder setResourceTransformer(ResourceTransformer resourceTransformer) {
        this.resourceTransformer = resourceTransformer;
        return this;
    }

    void addOperationTransformerEntry(String operationName, OperationTransformationEntry transformer) {
        this.operationTransformers.put(operationName, transformer);
    }

    protected TransformationDescription buildDefault(DiscardPolicy discardPolicy, boolean inherited, AttributeTransformationDescriptionBuilderImpl.AttributeTransformationDescriptionBuilderRegistry registry) {
        return this.buildDefault(discardPolicy, inherited, registry, Collections.emptyList());
    }

    protected TransformationDescription buildDefault(DiscardPolicy discardPolicy, boolean inherited, AttributeTransformationDescriptionBuilderImpl.AttributeTransformationDescriptionBuilderRegistry registry, List<String> discardedOperations) {
        Map<String, AttributeTransformationDescription> attributes = registry.buildAttributes();
        Map<String, OperationTransformer> operations = this.buildOperationTransformers(registry);
        List<TransformationDescription> children = this.buildChildren();
        if (discardPolicy == DiscardPolicy.NEVER) {
            if (!operations.containsKey("write-attribute")) {
                operations.put("write-attribute", OperationTransformationRules.createWriteOperation(attributes));
            }
            if (!operations.containsKey("undefine-attribute")) {
                operations.put("undefine-attribute", OperationTransformationRules.createUndefinedOperation(attributes));
            }
        }
        HashSet<String> discarded = new HashSet<String>();
        discarded.addAll(discardedOperations);
        return new TransformingDescription(this.pathElement, this.pathAddressTransformer, discardPolicy, inherited, this.resourceTransformer, attributes, operations, children, discarded);
    }

    protected Map<String, OperationTransformer> buildOperationTransformers(AttributeTransformationDescriptionBuilderImpl.AttributeTransformationDescriptionBuilderRegistry registry) {
        HashMap<String, OperationTransformer> operations = new HashMap<String, OperationTransformer>();
        for (Map.Entry<String, OperationTransformationEntry> entry : this.operationTransformers.entrySet()) {
            OperationTransformer transformer = entry.getValue().getOperationTransformer(registry);
            operations.put(entry.getKey(), transformer);
        }
        return operations;
    }

    protected List<TransformationDescription> buildChildren() {
        if (this.children.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TransformationDescription> children = new ArrayList<TransformationDescription>();
        for (TransformationDescriptionBuilder builder : this.children) {
            children.add(builder.build());
        }
        return children;
    }

    static abstract class OperationTransformationEntry {
        OperationTransformationEntry() {
        }

        abstract OperationTransformer getOperationTransformer(AttributeTransformationDescriptionBuilderImpl.AttributeTransformationDescriptionBuilderRegistry var1);
    }
}

