/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Collection;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ReloadRequiredWriteAttributeHandler
extends AbstractWriteAttributeHandler<Void> {
    public ReloadRequiredWriteAttributeHandler(AttributeDefinition ... definitions) {
        super(definitions);
    }

    public ReloadRequiredWriteAttributeHandler(Collection<AttributeDefinition> definitions) {
        super(definitions);
    }

    @Override
    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> voidHandback) throws OperationFailedException {
        ModelNode resolvedTypedValue = this.convertToType(attributeName, resolvedValue);
        return !resolvedTypedValue.equals(currentValue);
    }

    private ModelNode convertToType(String attributeName, ModelNode resolvedValue) {
        AttributeDefinition attributeDefinition = this.getAttributeDefinition(attributeName);
        ModelType type = attributeDefinition != null ? attributeDefinition.getType() : ModelType.STRING;
        ModelNode converted = resolvedValue.clone();
        try {
            switch (type) {
                case BIG_DECIMAL: {
                    converted.set(resolvedValue.asBigDecimal());
                    break;
                }
                case BIG_INTEGER: {
                    converted.set(resolvedValue.asBigInteger());
                    break;
                }
                case BOOLEAN: {
                    converted.set(resolvedValue.asBoolean());
                    break;
                }
                case BYTES: {
                    converted.set(resolvedValue.asBytes());
                    break;
                }
                case DOUBLE: {
                    converted.set(resolvedValue.asDouble());
                    break;
                }
                case INT: {
                    converted.set(resolvedValue.asInt());
                    break;
                }
                case LIST: {
                    break;
                }
                case LONG: {
                    converted.set(resolvedValue.asLong());
                    break;
                }
                case OBJECT: {
                    break;
                }
                case PROPERTY: {
                    break;
                }
                case STRING: {
                    converted.set(resolvedValue.asString());
                    break;
                }
                case TYPE: {
                    converted.set(resolvedValue.asType());
                    break;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return converted;
    }

    @Override
    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode resolvedValue, Void handback) throws OperationFailedException {
    }
}

