/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform.description;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public interface DiscardAttributeChecker {
    public static final DiscardAttributeChecker ALWAYS = new DefaultDiscardAttributeChecker(true, true){

        @Override
        public boolean isValueDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            return true;
        }
    };
    public static final DiscardAttributeChecker UNDEFINED = new DefaultDiscardAttributeChecker(false, true){

        @Override
        public boolean isValueDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            return false;
        }
    };
    public static final DiscardAttributeChecker DEFAULT_VALUE = new DiscardAttributeChecker(){

        @Override
        public boolean isDiscardExpressions() {
            return false;
        }

        @Override
        public boolean isDiscardUndefined() {
            return true;
        }

        @Override
        public boolean isOperationParameterDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, ModelNode operation, TransformationContext context) {
            String operationName = operation.get("operation").asString();
            if (operationName.equals("write-attribute")) {
                return this.isResourceAttributeDiscardable(address, attributeName, attributeValue, context);
            }
            ImmutableManagementResourceRegistration registration = context.getResourceRegistrationFromRoot(address);
            OperationDefinition definition = registration.getOperationEntry(PathAddress.EMPTY_ADDRESS, operationName).getOperationDefinition();
            for (AttributeDefinition parameter : definition.getParameters()) {
                if (!parameter.getName().equals(attributeName)) continue;
                return attributeValue.equals(parameter.getDefaultValue());
            }
            return false;
        }

        @Override
        public boolean isResourceAttributeDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            ImmutableManagementResourceRegistration registration = context.getResourceRegistrationFromRoot(address);
            AttributeDefinition definition = registration.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName).getAttributeDefinition();
            return attributeValue.equals(definition.getDefaultValue());
        }
    };

    public boolean isDiscardExpressions();

    public boolean isDiscardUndefined();

    public boolean isOperationParameterDiscardable(PathAddress var1, String var2, ModelNode var3, ModelNode var4, TransformationContext var5);

    public boolean isResourceAttributeDiscardable(PathAddress var1, String var2, ModelNode var3, TransformationContext var4);

    public static class DiscardAttributeValueChecker
    extends DefaultDiscardAttributeChecker {
        final ModelNode[] values;

        public DiscardAttributeValueChecker(ModelNode ... values) {
            super(false, true);
            this.values = values;
        }

        public DiscardAttributeValueChecker(boolean discardExpressions, boolean discardUndefined, ModelNode ... values) {
            super(discardExpressions, discardUndefined);
            this.values = values;
        }

        @Override
        protected boolean isValueDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (attributeValue.getType() != ModelType.EXPRESSION) {
                for (ModelNode value : this.values) {
                    if (!attributeValue.equals(value)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static abstract class DefaultDiscardAttributeChecker
    implements DiscardAttributeChecker {
        protected final boolean discardExpressions;
        protected final boolean discardUndefined;

        protected DefaultDiscardAttributeChecker(boolean discardExpressions, boolean discardUndefined) {
            this.discardExpressions = discardExpressions;
            this.discardUndefined = discardUndefined;
        }

        public DefaultDiscardAttributeChecker() {
            this(false, true);
        }

        @Override
        public boolean isDiscardExpressions() {
            return this.discardExpressions;
        }

        @Override
        public boolean isDiscardUndefined() {
            return this.discardUndefined;
        }

        @Override
        public boolean isOperationParameterDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, ModelNode operation, TransformationContext context) {
            return this.isValueDiscardable(address, attributeName, attributeValue, context);
        }

        @Override
        public boolean isResourceAttributeDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            return this.isValueDiscardable(address, attributeName, attributeValue, context);
        }

        protected abstract boolean isValueDiscardable(PathAddress var1, String var2, ModelNode var3, TransformationContext var4);
    }
}

