/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.persistence.AbstractConfigurationPersister;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.FilePersistenceResource;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.BasicLogger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLMapper;
import org.projectodd.vdx.core.XMLStreamValidationException;
import org.projectodd.vdx.wildfly.WildFlyErrorReporter;

public class XmlConfigurationPersister
extends AbstractConfigurationPersister {
    private final File fileName;
    private final QName rootElement;
    private final XMLElementReader<List<ModelNode>> rootParser;
    private final Map<QName, XMLElementReader<List<ModelNode>>> additionalParsers;
    private final boolean suppressLoad;

    public XmlConfigurationPersister(File fileName, QName rootElement, XMLElementReader<List<ModelNode>> rootParser, XMLElementWriter<ModelMarshallingContext> rootDeparser) {
        this(fileName, rootElement, rootParser, rootDeparser, false);
    }

    public XmlConfigurationPersister(File fileName, QName rootElement, XMLElementReader<List<ModelNode>> rootParser, XMLElementWriter<ModelMarshallingContext> rootDeparser, boolean suppressLoad) {
        super(rootDeparser);
        this.fileName = fileName;
        this.rootElement = rootElement;
        this.rootParser = rootParser;
        this.additionalParsers = new HashMap<QName, XMLElementReader<List<ModelNode>>>();
        this.suppressLoad = suppressLoad;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAdditionalRootElement(QName anotherRoot, XMLElementReader<List<ModelNode>> parser) {
        Map<QName, XMLElementReader<List<ModelNode>>> map = this.additionalParsers;
        synchronized (map) {
            this.additionalParsers.put(anotherRoot, parser);
        }
    }

    @Override
    public ConfigurationPersister.PersistenceResource store(ModelNode model, Set<PathAddress> affectedAddresses) throws ConfigurationPersistenceException {
        return new FilePersistenceResource(model, this.fileName, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ModelNode> load() throws ConfigurationPersistenceException {
        if (this.suppressLoad) {
            return new ArrayList<ModelNode>();
        }
        XMLMapper mapper = XMLMapper.Factory.create();
        mapper.registerRootElement(this.rootElement, this.rootParser);
        Map<QName, XMLElementReader<List<ModelNode>>> map = this.additionalParsers;
        synchronized (map) {
            for (Map.Entry<QName, XMLElementReader<List<ModelNode>>> entry : this.additionalParsers.entrySet()) {
                mapper.registerRootElement(entry.getKey(), entry.getValue());
            }
        }
        ArrayList<ModelNode> updates = new ArrayList<ModelNode>();
        try {
            FileInputStream fis = new FileInputStream(this.fileName);
            try {
                BufferedInputStream input = new BufferedInputStream(fis);
                XMLStreamReader streamReader = XMLInputFactory.newInstance().createXMLStreamReader(input);
                mapper.parseDocument(updates, streamReader);
                streamReader.close();
                input.close();
                fis.close();
            }
            finally {
                XmlConfigurationPersister.safeClose(fis);
            }
        }
        catch (XMLStreamException e) {
            boolean reported = this.reportValidationError(e);
            Throwable cause = null;
            if (!reported) {
                cause = e instanceof XMLStreamValidationException ? e.getNestedException() : e;
            }
            throw ControllerLogger.ROOT_LOGGER.failedToParseConfiguration(cause);
        }
        catch (Exception e) {
            throw ControllerLogger.ROOT_LOGGER.failedToParseConfiguration(e);
        }
        return updates;
    }

    private boolean reportValidationError(XMLStreamException exception) {
        return new WildFlyErrorReporter(this.fileName, (BasicLogger)ControllerLogger.ROOT_LOGGER).report(exception);
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                ControllerLogger.ROOT_LOGGER.failedToCloseResource(t, closeable);
            }
        }
    }

    protected void successfulBoot(File file) throws ConfigurationPersistenceException {
    }
}

