/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import org.wildfly.common.Assert;

public final class RuntimePackageDependency {
    private final String name;
    private final TYPE type;

    private RuntimePackageDependency(String name, TYPE type) {
        this.name = (String)Assert.checkNotNullParamWithNullPointerException((String)"name", (Object)name);
        this.type = (TYPE)((Object)Assert.checkNotNullParamWithNullPointerException((String)"type", (Object)((Object)type)));
    }

    public String getName() {
        return this.name;
    }

    public boolean isOptional() {
        return this.type == TYPE.OPTIONAL || this.type == TYPE.PASSIVE;
    }

    public boolean isRequired() {
        return this.type == TYPE.REQUIRED;
    }

    public boolean isPassive() {
        return this.type == TYPE.PASSIVE;
    }

    public static RuntimePackageDependency passive(String name) {
        return new RuntimePackageDependency(name, TYPE.PASSIVE);
    }

    public static RuntimePackageDependency required(String name) {
        return new RuntimePackageDependency(name, TYPE.REQUIRED);
    }

    public static RuntimePackageDependency optional(String name) {
        return new RuntimePackageDependency(name, TYPE.OPTIONAL);
    }

    private static enum TYPE {
        REQUIRED,
        OPTIONAL,
        PASSIVE;

    }
}

