/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.MapAttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ObjectTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ObjectTypeAttributeDefinition
extends SimpleAttributeDefinition {
    private final AttributeDefinition[] valueTypes;
    private final String suffix;

    protected ObjectTypeAttributeDefinition(Builder builder) {
        this(builder, builder.suffix, builder.valueTypes);
    }

    protected ObjectTypeAttributeDefinition(AbstractAttributeDefinitionBuilder<?, ? extends ObjectTypeAttributeDefinition> builder, String suffix, AttributeDefinition[] valueTypes) {
        super((AbstractAttributeDefinitionBuilder<?, ? extends SimpleAttributeDefinition>)ObjectTypeAttributeDefinition.addValueTypeConstraints(builder, valueTypes));
        this.valueTypes = valueTypes;
        this.suffix = suffix == null ? "" : suffix;
    }

    private static AbstractAttributeDefinitionBuilder<?, ? extends ObjectTypeAttributeDefinition> addValueTypeConstraints(AbstractAttributeDefinitionBuilder<?, ? extends ObjectTypeAttributeDefinition> builder, AttributeDefinition[] valueTypes) {
        if (valueTypes != null && valueTypes.length > 0) {
            LinkedHashSet<AccessConstraintDefinition> fromValues = null;
            for (AttributeDefinition valueType : valueTypes) {
                List<AccessConstraintDefinition> valueTypeConstraints = valueType.getAccessConstraints();
                if (valueTypeConstraints == null || valueTypeConstraints.isEmpty()) continue;
                if (fromValues == null) {
                    fromValues = new LinkedHashSet<AccessConstraintDefinition>();
                }
                fromValues.addAll(valueTypeConstraints);
            }
            if (fromValues != null) {
                AccessConstraintDefinition[] existing = builder.getAccessConstraints();
                LinkedHashSet newValues = new LinkedHashSet();
                if (existing != null && existing.length > 0) {
                    Collections.addAll(newValues, existing);
                }
                newValues.addAll(fromValues);
                builder.setAccessConstraints(newValues.toArray(new AccessConstraintDefinition[newValues.size()]));
            }
        }
        return builder;
    }

    @Override
    protected ModelNode convertParameterExpressions(ModelNode parameter) {
        ModelNode result = parameter;
        if (parameter.isDefined()) {
            boolean changeMade = false;
            ModelNode updated = new ModelNode().setEmptyObject();
            for (AttributeDefinition ad : this.valueTypes) {
                String fieldName = ad.getName();
                if (!parameter.has(fieldName)) continue;
                ModelNode orig = parameter.get(fieldName);
                if (!orig.isDefined()) {
                    updated.get(fieldName);
                    continue;
                }
                ModelNode converted = ad.convertParameterExpressions(orig);
                changeMade |= !orig.equals(converted);
                updated.get(fieldName).set(converted);
            }
            if (changeMade) {
                result = updated;
            }
        }
        return result;
    }

    public final AttributeDefinition[] getValueTypes() {
        return this.valueTypes;
    }

    @Override
    public ModelNode parse(String value, XMLStreamReader reader) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addCapabilityRequirements(OperationContext context, Resource resource, ModelNode attributeValue) {
        if (attributeValue.isDefined()) {
            for (AttributeDefinition fieldType : this.valueTypes) {
                if (!attributeValue.hasDefined(fieldType.getName())) continue;
                fieldType.addCapabilityRequirements(context, resource, attributeValue.get(fieldType.getName()));
            }
        }
    }

    @Override
    public void removeCapabilityRequirements(OperationContext context, Resource resource, ModelNode attributeValue) {
        if (attributeValue.isDefined()) {
            for (AttributeDefinition fieldType : this.valueTypes) {
                if (!attributeValue.hasDefined(fieldType.getName())) continue;
                fieldType.removeCapabilityRequirements(context, resource, attributeValue.get(fieldType.getName()));
            }
        }
    }

    @Override
    public ModelNode addResourceAttributeDescription(ResourceBundle bundle, String prefix, ModelNode resourceDescription) {
        ModelNode result = super.addResourceAttributeDescription(bundle, prefix, resourceDescription);
        this.addValueTypeDescription(result, prefix, bundle, false, null, null);
        return result;
    }

    @Override
    public ModelNode addOperationParameterDescription(ModelNode resourceDescription, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        ModelNode result = super.addOperationParameterDescription(resourceDescription, operationName, resolver, locale, bundle);
        this.addValueTypeDescription(result, this.getName(), bundle, true, resolver, locale);
        return result;
    }

    @Override
    public ModelNode addOperationReplyDescription(ModelNode resourceDescription, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        ModelNode result = super.addOperationReplyDescription(resourceDescription, operationName, resolver, locale, bundle);
        this.addValueTypeDescription(result, this.getName(), bundle, true, resolver, locale);
        return result;
    }

    @Override
    public ModelNode addResourceAttributeDescription(ModelNode resourceDescription, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        ModelNode result = super.addResourceAttributeDescription(resourceDescription, resolver, locale, bundle);
        this.addValueTypeDescription(result, this.getName(), bundle, false, resolver, locale);
        return result;
    }

    @Override
    public ModelNode addOperationParameterDescription(ResourceBundle bundle, String prefix, ModelNode operationDescription) {
        ModelNode result = super.addOperationParameterDescription(bundle, prefix, operationDescription);
        this.addValueTypeDescription(result, prefix, bundle, true, null, null);
        return result;
    }

    @Override
    public ModelNode resolveValue(ExpressionResolver resolver, ModelNode value) throws OperationFailedException {
        ModelNode superResult;
        ModelNode modelNode = superResult = value.getType() == ModelType.OBJECT ? value : super.resolveValue(resolver, value);
        if (superResult.getType() != ModelType.OBJECT) {
            return superResult;
        }
        ModelNode clone = superResult == value ? value.clone() : superResult;
        ModelNode result = new ModelNode();
        for (AttributeDefinition field : this.valueTypes) {
            String fieldName = field.getName();
            if (clone.has(fieldName)) {
                result.get(fieldName).set(field.resolveValue(resolver, clone.get(fieldName)));
                continue;
            }
            ModelNode val = field.resolveValue(resolver, new ModelNode());
            if (!val.isDefined()) continue;
            result.get(fieldName).set(val);
        }
        this.getValidator().validateParameter(this.getName(), result);
        return result;
    }

    @Deprecated
    protected void addValueTypeDescription(ModelNode node, String prefix, ResourceBundle bundle, ResourceDescriptionResolver resolver, Locale locale) {
        this.addValueTypeDescription(node, prefix, bundle, false, resolver, locale);
    }

    protected void addValueTypeDescription(ModelNode node, String prefix, ResourceBundle bundle, boolean forOperation, ResourceDescriptionResolver resolver, Locale locale) {
        for (AttributeDefinition valueType : this.valueTypes) {
            boolean suffixUnusable;
            if (forOperation && valueType.isResourceOnly()) continue;
            ModelNode valueTypeDesc = valueType.getNoTextDescription(false);
            if (valueTypeDesc.has("attribute-group")) {
                valueTypeDesc.remove("attribute-group");
            }
            boolean prefixUnusable = prefix == null || prefix.isEmpty();
            boolean bl = suffixUnusable = this.suffix == null || this.suffix.isEmpty();
            String p = prefixUnusable && !suffixUnusable ? this.suffix : (!prefixUnusable && suffixUnusable ? prefix : String.format("%s.%s", prefix, this.suffix));
            if (resolver != null) {
                String key = String.format("%s.%s", p, valueType.getName());
                valueTypeDesc.get("description").set(resolver.getResourceAttributeDescription(key, locale, bundle));
            } else {
                valueTypeDesc.get("description").set(valueType.getAttributeTextDescription(bundle, p));
            }
            ModelNode childType = node.get(new String[]{"value-type", valueType.getName()}).set(valueTypeDesc);
            if (valueType instanceof ObjectTypeAttributeDefinition) {
                ((ObjectTypeAttributeDefinition)ObjectTypeAttributeDefinition.class.cast(valueType)).addValueTypeDescription(childType, p, bundle, forOperation, resolver, locale);
            }
            if (valueType instanceof SimpleListAttributeDefinition) {
                ((SimpleListAttributeDefinition)SimpleListAttributeDefinition.class.cast(valueType)).addValueTypeDescription(childType, p, bundle);
                continue;
            }
            if (valueType instanceof MapAttributeDefinition) {
                ((MapAttributeDefinition)MapAttributeDefinition.class.cast(valueType)).addValueTypeDescription(childType, bundle);
                continue;
            }
            if (valueType instanceof PrimitiveListAttributeDefinition) {
                ((PrimitiveListAttributeDefinition)PrimitiveListAttributeDefinition.class.cast(valueType)).addValueTypeDescription(childType, bundle);
                continue;
            }
            if (!(valueType instanceof ObjectListAttributeDefinition)) continue;
            ((ObjectListAttributeDefinition)ObjectListAttributeDefinition.class.cast(valueType)).addValueTypeDescription(childType, p, bundle, false, resolver, locale);
        }
    }

    public static Builder create(String name, AttributeDefinition ... valueTypes) {
        return new Builder(name, valueTypes);
    }

    @Override
    protected void addAllowedValuesToDescription(ModelNode result, ParameterValidator validator) {
    }

    private static class ObjectParameterCorrector
    implements ParameterCorrector {
        private final ParameterCorrector topCorrector;
        private final AttributeDefinition[] valueTypes;

        private ObjectParameterCorrector(ParameterCorrector topCorrector, AttributeDefinition[] valueTypes) {
            this.topCorrector = topCorrector;
            this.valueTypes = valueTypes;
        }

        @Override
        public ModelNode correct(ModelNode newValue, ModelNode currentValue) {
            ModelNode result = newValue;
            if (newValue.isDefined()) {
                for (AttributeDefinition ad : this.valueTypes) {
                    ModelNode curField;
                    String name;
                    boolean has;
                    ModelNode toCorrect;
                    ModelNode corrected;
                    ParameterCorrector fieldCorrector = ad.getCorrector();
                    if (fieldCorrector == null || (corrected = fieldCorrector.correct(toCorrect = (has = newValue.has(name = ad.getName())) ? newValue.get(name) : new ModelNode(), curField = currentValue.has(name) ? currentValue.get(name) : new ModelNode())).equals(toCorrect) && (has || !corrected.isDefined())) continue;
                    if (has) {
                        toCorrect.set(corrected);
                        continue;
                    }
                    newValue.get(name).set(corrected);
                }
            }
            if (this.topCorrector != null) {
                result = this.topCorrector.correct(result, currentValue);
            }
            return result;
        }
    }

    public static final class Builder
    extends AbstractAttributeDefinitionBuilder<Builder, ObjectTypeAttributeDefinition> {
        private String suffix;
        private final AttributeDefinition[] valueTypes;

        public Builder(String name, AttributeDefinition ... valueTypes) {
            super(name, ModelType.OBJECT, true);
            this.valueTypes = valueTypes;
            this.setAttributeParser(AttributeParser.OBJECT_PARSER);
            this.setAttributeMarshaller(AttributeMarshaller.ATTRIBUTE_OBJECT);
        }

        public static Builder of(String name, AttributeDefinition ... valueTypes) {
            return new Builder(name, valueTypes);
        }

        public static Builder of(String name, AttributeDefinition[] valueTypes, AttributeDefinition[] moreValueTypes) {
            ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>(Arrays.asList(valueTypes));
            list.addAll(Arrays.asList(moreValueTypes));
            AttributeDefinition[] allValueTypes = new AttributeDefinition[list.size()];
            list.toArray(allValueTypes);
            return new Builder(name, allValueTypes);
        }

        @Override
        public ObjectTypeAttributeDefinition build() {
            ParameterValidator validator = this.getValidator();
            if (validator == null) {
                this.setValidator(new ObjectTypeValidator(this.isAllowNull(), this.valueTypes));
            }
            for (AttributeDefinition valueType : this.valueTypes) {
                if (valueType.getCorrector() == null) continue;
                this.setCorrector(new ObjectParameterCorrector(this.getCorrector(), this.valueTypes));
                break;
            }
            return new ObjectTypeAttributeDefinition(this);
        }

        public Builder setSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }
    }
}

