/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.constraint;

import java.util.regex.Pattern;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.JmxAction;
import org.jboss.as.controller.access.JmxTarget;
import org.jboss.as.controller.access.TargetAttribute;
import org.jboss.as.controller.access.TargetResource;
import org.jboss.as.controller.access.constraint.AbstractConstraintFactory;
import org.jboss.as.controller.access.constraint.AllowAllowNotConstraint;
import org.jboss.as.controller.access.constraint.Constraint;
import org.jboss.as.controller.access.constraint.ConstraintFactory;
import org.jboss.as.controller.access.constraint.VaultExpressionSensitivityConfig;
import org.jboss.as.controller.access.rbac.StandardRole;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class SensitiveVaultExpressionConstraint
extends AllowAllowNotConstraint {
    public static final ConstraintFactory FACTORY = new Factory();
    private static final Pattern VAULT_EXPRESSION_PATTERN = Pattern.compile(".*\\$\\{VAULT::.*::.*::.*}.*");
    private static final SensitiveVaultExpressionConstraint SENSITIVE = new SensitiveVaultExpressionConstraint(true);
    private static final SensitiveVaultExpressionConstraint NOT_SENSITIVE = new SensitiveVaultExpressionConstraint(false);
    private static final SensitiveVaultExpressionConstraint ALLOWS = new SensitiveVaultExpressionConstraint(true, true);
    private static final SensitiveVaultExpressionConstraint DISALLOWS = new SensitiveVaultExpressionConstraint(false, true);

    private SensitiveVaultExpressionConstraint(boolean sensitive) {
        super(sensitive);
    }

    private SensitiveVaultExpressionConstraint(boolean allowsSensitive, boolean allowsNonSensitive) {
        super(allowsSensitive, allowsNonSensitive);
    }

    private static class Factory
    extends AbstractConstraintFactory {
        private Factory() {
        }

        @Override
        public Constraint getStandardUserConstraint(StandardRole role, Action.ActionEffect actionEffect) {
            if (role == StandardRole.ADMINISTRATOR || role == StandardRole.SUPERUSER || role == StandardRole.AUDITOR) {
                return ALLOWS;
            }
            return DISALLOWS;
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetAttribute target) {
            return this.isSensitiveAction(action, actionEffect, target) ? SENSITIVE : NOT_SENSITIVE;
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetResource target) {
            return this.isSensitiveAction(action, actionEffect) ? SENSITIVE : NOT_SENSITIVE;
        }

        private boolean isSensitiveAction(Action action, Action.ActionEffect actionEffect) {
            if (VaultExpressionSensitivityConfig.INSTANCE.isSensitive(actionEffect) && (actionEffect == Action.ActionEffect.WRITE_RUNTIME || actionEffect == Action.ActionEffect.WRITE_CONFIG)) {
                ModelNode operation = action.getOperation();
                for (Property property : operation.asPropertyList()) {
                    if (!this.isSensitiveValue(property.getValue())) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isSensitiveAction(Action action, Action.ActionEffect actionEffect, TargetAttribute targetAttribute) {
            if (VaultExpressionSensitivityConfig.INSTANCE.isSensitive(actionEffect)) {
                if (actionEffect == Action.ActionEffect.WRITE_RUNTIME || actionEffect == Action.ActionEffect.WRITE_CONFIG) {
                    ModelNode operation = action.getOperation();
                    if (operation.hasDefined(targetAttribute.getAttributeName()) && this.isSensitiveValue(operation.get(targetAttribute.getAttributeName()))) {
                        return true;
                    }
                    if ("write-attribute".equals(operation.get("operation").asString()) && operation.hasDefined("value") && this.isSensitiveValue(operation.get("value"))) {
                        return true;
                    }
                }
                if (actionEffect != Action.ActionEffect.ADDRESS && this.isSensitiveValue(targetAttribute.getCurrentValue())) {
                    return true;
                }
            }
            return false;
        }

        private boolean isSensitiveValue(ModelNode value) {
            if (value.getType() == ModelType.EXPRESSION || value.getType() == ModelType.STRING) {
                String valueString = value.asString();
                return VAULT_EXPRESSION_PATTERN.matcher(valueString).matches();
            }
            return false;
        }

        @Override
        protected int internalCompare(AbstractConstraintFactory other) {
            return 0;
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, JmxAction action, JmxTarget target) {
            return NOT_SENSITIVE;
        }
    }
}

