/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.protocol.mgmt.ProtocolUtils;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.authz.RoleDecoder;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;

class IdentityAddressProtocolUtil {
    private static final SecurityDomain INFLOW_SECURITY_DOMAIN = IdentityAddressProtocolUtil.createSecurityDomain();
    private static final byte USER = 1;
    private static final byte GROUP = 2;
    private static final byte ROLE = 3;
    private static final byte INET_ADDRESS = 4;
    private static final byte ITEMS_PARAM = 5;
    private static final byte REALM_PARAM = 6;
    private static final byte NAME_PARAM = 7;
    private static final byte HOST_PARAM = 8;
    private static final byte ADDR_PARAM = 9;

    IdentityAddressProtocolUtil() {
    }

    static void write(DataOutput output, SecurityIdentity securityIdentity, InetAddress sourceAddress) throws IOException {
        Set<String> roles;
        Principal principal;
        if (securityIdentity != null) {
            principal = securityIdentity.getPrincipal();
            roles = StreamSupport.stream(securityIdentity.getRoles().spliterator(), false).collect(Collectors.toSet());
        } else {
            principal = null;
            roles = Collections.emptySet();
        }
        int itemsToSend = (principal != null ? 1 : 0) + roles.size() + (sourceAddress != null ? 1 : 0);
        output.writeByte(80);
        if (itemsToSend == 0) {
            output.writeInt(0);
            return;
        }
        output.writeInt(1);
        output.write(5);
        output.writeInt(itemsToSend);
        if (principal != null) {
            output.write(1);
            output.write(7);
            output.writeUTF(principal.getName());
        }
        for (String roleName : roles) {
            output.write(2);
            output.write(7);
            output.writeUTF(roleName);
        }
        if (sourceAddress != null) {
            output.write(4);
            String host = sourceAddress.getHostName();
            byte[] addr = sourceAddress.getAddress();
            output.write(8);
            output.writeUTF(host);
            output.write(9);
            output.writeInt(addr.length);
            output.write(addr);
        }
    }

    static PropagatedIdentity read(DataInput input) throws IOException {
        ProtocolUtils.expectHeader((DataInput)input, (int)80);
        int size = input.readInt();
        if (size == 0) {
            return null;
        }
        ProtocolUtils.expectHeader((DataInput)input, (int)5);
        int itemCount = input.readInt();
        NamePrincipal principal = null;
        HashSet<String> roles = new HashSet<String>(Math.max(itemCount - 2, 0));
        InetAddress sourceAddress = null;
        block5: for (int i = 0; i < itemCount; ++i) {
            byte type = input.readByte();
            switch (type) {
                case 1: {
                    byte paramType = input.readByte();
                    String name = null;
                    if (paramType == 6) {
                        input.readUTF();
                        paramType = input.readByte();
                    }
                    if (paramType != 7) {
                        throw ControllerLogger.ROOT_LOGGER.unsupportedIdentityParameter(paramType, (byte)1);
                    }
                    name = input.readUTF();
                    principal = new NamePrincipal(name);
                    continue block5;
                }
                case 2: 
                case 3: {
                    byte paramType = input.readByte();
                    String name = null;
                    if (paramType == 6) {
                        input.readUTF();
                        paramType = input.readByte();
                    }
                    if (paramType != 7) {
                        throw ControllerLogger.ROOT_LOGGER.unsupportedIdentityParameter(paramType, (byte)2);
                    }
                    name = input.readUTF();
                    roles.add(name);
                    continue block5;
                }
                case 4: {
                    byte paramType = input.readByte();
                    if (paramType != 8) {
                        throw ControllerLogger.ROOT_LOGGER.unsupportedIdentityParameter(paramType, (byte)4);
                    }
                    String host = input.readUTF();
                    paramType = input.readByte();
                    if (paramType != 9) {
                        throw ControllerLogger.ROOT_LOGGER.unsupportedIdentityParameter(paramType, (byte)4);
                    }
                    int length = input.readInt();
                    byte[] addr = new byte[length];
                    input.readFully(addr);
                    sourceAddress = InetAddress.getByAddress(host, addr);
                    continue block5;
                }
                default: {
                    throw ControllerLogger.ROOT_LOGGER.unsupportedIdentityType(type);
                }
            }
        }
        return principal != null || sourceAddress != null ? new PropagatedIdentity(principal != null ? IdentityAddressProtocolUtil.createSecurityIdentity(principal, roles) : null, sourceAddress) : null;
    }

    private static SecurityIdentity createSecurityIdentity(Principal principal, Set<String> roles) {
        ServerAuthenticationContext serverAuthenticationContext = INFLOW_SECURITY_DOMAIN.createNewAuthenticationContext();
        try {
            serverAuthenticationContext.verifyEvidence((Evidence)new EvidenceWithRoles(principal, roles));
            serverAuthenticationContext.authorize();
        }
        catch (RealmUnavailableException e) {
            throw new IllegalStateException(e);
        }
        return serverAuthenticationContext.getAuthorizedIdentity();
    }

    private static SecurityDomain createSecurityDomain() {
        return SecurityDomain.builder().setDefaultRealmName("Empty").addRealm("Empty", new SecurityRealm(){

            public RealmIdentity getRealmIdentity(final Principal principal) throws RealmUnavailableException {
                return new RealmIdentity(){
                    private volatile Set<String> roles = null;

                    public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
                        this.roles = ((EvidenceWithRoles)evidence).roles;
                        return true;
                    }

                    public Principal getRealmIdentityPrincipal() {
                        return principal;
                    }

                    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                        return SupportLevel.UNSUPPORTED;
                    }

                    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
                        return SupportLevel.UNSUPPORTED;
                    }

                    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
                        return SupportLevel.UNSUPPORTED;
                    }

                    public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
                        return null;
                    }

                    public boolean exists() throws RealmUnavailableException {
                        return true;
                    }

                    public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
                        MapAttributes mapAttributes = new MapAttributes();
                        mapAttributes.addAll("GROUPS", this.roles);
                        return AuthorizationIdentity.basicIdentity((Attributes)mapAttributes);
                    }
                };
            }

            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                return SupportLevel.UNSUPPORTED;
            }

            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
                return SupportLevel.UNSUPPORTED;
            }

            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
                return SupportLevel.UNSUPPORTED;
            }
        }).setRoleDecoder(RoleDecoder.simple((String)"GROUPS")).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).build();
    }

    static final class EvidenceWithRoles
    implements Evidence {
        final Principal principal;
        final Set<String> roles;

        EvidenceWithRoles(Principal principal, Set<String> roles) {
            this.principal = principal;
            this.roles = roles;
        }

        public Principal getPrincipal() {
            return this.principal;
        }
    }

    static final class PropagatedIdentity {
        final SecurityIdentity securityIdentity;
        final InetAddress inetAddress;

        public PropagatedIdentity(SecurityIdentity securityIdentity, InetAddress inetAddress) {
            this.securityIdentity = securityIdentity;
            this.inetAddress = inetAddress;
        }
    }
}

