/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import org.jboss.as.controller.PathAddress;

class TransformRule {
    private PathAddress sourceAddress;
    private PathAddress targetAddress;
    private String sourceName;
    private String targetName;

    public TransformRule() {
    }

    public TransformRule(String sourceName, String targetName) {
        this.sourceName = sourceName;
        this.targetName = targetName;
    }

    public TransformRule(PathAddress sourceAddress, PathAddress targetAddress) {
        this.sourceAddress = sourceAddress;
        this.targetAddress = targetAddress;
    }

    public TransformRule(PathAddress sourceAddress, PathAddress targetAddress, String sourceName, String targetName) {
        this.sourceAddress = sourceAddress;
        this.targetAddress = targetAddress;
        this.sourceName = sourceName;
        this.targetName = targetName;
    }

    public PathAddress getSourceAddress() {
        return this.sourceAddress;
    }

    public void setSourceAddress(PathAddress sourceAddress) {
        this.sourceAddress = sourceAddress;
    }

    public PathAddress getTargetAddress() {
        return this.targetAddress;
    }

    public void setTargetAddress(PathAddress targetAddress) {
        this.targetAddress = targetAddress;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public boolean isMappingSame() {
        return this.sourceAddress.equals(this.targetAddress) && this.sourceName.equals(this.targetName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformRule that = (TransformRule)o;
        if (this.sourceAddress != null ? !this.sourceAddress.equals(that.sourceAddress) : that.sourceAddress != null) {
            return false;
        }
        if (this.sourceName != null ? !this.sourceName.equals(that.sourceName) : that.sourceName != null) {
            return false;
        }
        if (this.targetAddress != null ? !this.targetAddress.equals(that.targetAddress) : that.targetAddress != null) {
            return false;
        }
        return !(this.targetName != null ? !this.targetName.equals(that.targetName) : that.targetName != null);
    }

    public int hashCode() {
        int result = this.sourceAddress != null ? this.sourceAddress.hashCode() : 0;
        result = 31 * result + (this.targetAddress != null ? this.targetAddress.hashCode() : 0);
        result = 31 * result + (this.sourceName != null ? this.sourceName.hashCode() : 0);
        result = 31 * result + (this.targetName != null ? this.targetName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "path: " + this.sourceAddress + " => " + this.targetAddress + ", name: " + this.sourceName + " => " + this.targetName;
    }
}

