/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.permission;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.access.Authorizer;
import org.jboss.as.controller.access.Caller;
import org.jboss.as.controller.access.Environment;
import org.jboss.as.controller.access.JmxAction;
import org.jboss.as.controller.access.TargetAttribute;
import org.jboss.as.controller.access.TargetResource;
import org.jboss.as.controller.access.permission.AllPermissionsCollection;
import org.jboss.as.controller.access.permission.JmxPermissionFactory;
import org.jboss.as.controller.access.permission.PermissionFactory;
import org.jboss.as.controller.access.rbac.StandardRole;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;

public class ManagementPermissionAuthorizer
implements Authorizer {
    private static final Action FAKE_JMX_ACTION = new Action(Util.createOperation("test", PathAddress.EMPTY_ADDRESS), null);
    private final PermissionFactory permissionFactory;
    private final JmxPermissionFactory jmxPermissionFactory;

    public ManagementPermissionAuthorizer(PermissionFactory permissionFactory, JmxPermissionFactory jmxPermissionFactory) {
        this.permissionFactory = permissionFactory;
        this.jmxPermissionFactory = jmxPermissionFactory;
    }

    @Override
    public Authorizer.AuthorizerDescription getDescription() {
        return new Authorizer.AuthorizerDescription(){

            @Override
            public boolean isRoleBased() {
                return true;
            }

            @Override
            public Set<String> getStandardRoles() {
                return Collections.emptySet();
            }
        };
    }

    @Override
    public AuthorizationResult authorize(Caller caller, Environment callEnvironment, Action action, TargetAttribute target) {
        assert (ManagementPermissionAuthorizer.assertSameAddress(action, target.getTargetResource()));
        if (callEnvironment.getProcessState() == ControlledProcessState.State.STARTING) {
            return AuthorizationResult.PERMITTED;
        }
        PermissionCollection userPerms = this.permissionFactory.getUserPermissions(caller, callEnvironment, action, target);
        PermissionCollection requiredPerms = this.permissionFactory.getRequiredPermissions(action, target);
        return this.authorize(userPerms, requiredPerms);
    }

    @Override
    public AuthorizationResult authorize(Caller caller, Environment callEnvironment, Action action, TargetResource target) {
        assert (ManagementPermissionAuthorizer.assertSameAddress(action, target));
        if (callEnvironment.getProcessState() == ControlledProcessState.State.STARTING) {
            return AuthorizationResult.PERMITTED;
        }
        PermissionCollection userPerms = this.permissionFactory.getUserPermissions(caller, callEnvironment, action, target);
        if (userPerms == AllPermissionsCollection.INSTANCE) {
            return AuthorizationResult.PERMITTED;
        }
        PermissionCollection requiredPerms = this.permissionFactory.getRequiredPermissions(action, target);
        return this.authorize(userPerms, requiredPerms);
    }

    private static boolean assertSameAddress(Action action, TargetResource target) {
        ModelNode operation = action.getOperation();
        return operation == null || target.getResourceAddress().equals(PathAddress.pathAddress(operation.get("address")));
    }

    private AuthorizationResult authorize(PermissionCollection userPermissions, PermissionCollection requiredPermissions) {
        Enumeration<Permission> enumeration = requiredPermissions.elements();
        while (enumeration.hasMoreElements()) {
            Permission requiredPermission = enumeration.nextElement();
            if (userPermissions.implies(requiredPermission)) continue;
            return new AuthorizationResult(AuthorizationResult.Decision.DENY, new ModelNode(ControllerLogger.ROOT_LOGGER.permissionDenied()));
        }
        return AuthorizationResult.PERMITTED;
    }

    @Override
    public AuthorizationResult authorizeJmxOperation(Caller caller, Environment callEnvironment, JmxAction action) {
        Set<String> roles = this.jmxPermissionFactory.getUserRoles(caller, null, FAKE_JMX_ACTION, null);
        if (action.getImpact() == JmxAction.Impact.EXTRA_SENSITIVE) {
            return this.authorize(roles, StandardRole.SUPERUSER, StandardRole.ADMINISTRATOR);
        }
        if (this.jmxPermissionFactory.isNonFacadeMBeansSensitive()) {
            if (action.getImpact() == JmxAction.Impact.READ_ONLY) {
                return this.authorize(roles, StandardRole.SUPERUSER, StandardRole.ADMINISTRATOR, StandardRole.AUDITOR);
            }
            return this.authorize(roles, StandardRole.SUPERUSER, StandardRole.ADMINISTRATOR);
        }
        if (action.getImpact() == JmxAction.Impact.READ_ONLY) {
            return AuthorizationResult.PERMITTED;
        }
        return this.authorize(roles, StandardRole.SUPERUSER, StandardRole.ADMINISTRATOR, StandardRole.OPERATOR, StandardRole.MAINTAINER);
    }

    @Override
    public Set<String> getCallerRoles(Caller caller, Environment callEnvironment, Set<String> runAsRoles) {
        return null;
    }

    private AuthorizationResult authorize(Set<String> callerRoles, StandardRole ... roles) {
        for (StandardRole role : roles) {
            if (!callerRoles.contains(role.getOfficialForm())) continue;
            return AuthorizationResult.PERMITTED;
        }
        return new AuthorizationResult(AuthorizationResult.Decision.DENY);
    }
}

