/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.capability;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.capability.AbstractCapability;
import org.jboss.as.controller.capability.ServiceNameProvider;
import org.jboss.msc.service.ServiceName;

public class RuntimeCapability<T>
extends AbstractCapability {
    private final ServiceNameProvider serviceNameProvider;
    private final T runtimeAPI;
    private final String dynamicNameElement;

    public static String buildDynamicCapabilityName(String baseName, String dynamicNameElement) {
        assert (baseName != null);
        assert (dynamicNameElement != null);
        return baseName + "." + dynamicNameElement;
    }

    public static <T> RuntimeCapability<T> fromBaseCapability(RuntimeCapability<T> base, String dynamicElement) {
        assert (base != null);
        assert (base.isDynamicallyNamed());
        assert (dynamicElement != null);
        assert (dynamicElement.length() > 0);
        return new RuntimeCapability<T>(base.getName(), dynamicElement, base.serviceNameProvider, base.runtimeAPI, base.getRequirements(), base.getOptionalRequirements(), base.getRuntimeOnlyRequirements(), base.getDynamicRequirements(), base.getDynamicOptionalRequirements());
    }

    @Deprecated
    public RuntimeCapability(String name, T runtimeAPI, Set<String> requirements, Set<String> optionalRequirements) {
        super(name, false, requirements, optionalRequirements, null, null, null);
        this.runtimeAPI = runtimeAPI;
        this.serviceNameProvider = new ServiceNameProvider.DefaultProvider(name);
        this.dynamicNameElement = null;
    }

    @Deprecated
    public RuntimeCapability(String name, T runtimeAPI, Set<String> requirements) {
        this(name, runtimeAPI, requirements, null);
    }

    @Deprecated
    public RuntimeCapability(String name, T runtimeAPI, String ... requirements) {
        super(name, false, new HashSet<String>(Arrays.asList(requirements)), null, null, null, null);
        this.runtimeAPI = runtimeAPI;
        this.serviceNameProvider = new ServiceNameProvider.DefaultProvider(name);
        this.dynamicNameElement = null;
    }

    private RuntimeCapability(Builder<T> builder) {
        super(((Builder)builder).baseName, ((Builder)builder).dynamic, ((Builder)builder).requirements, ((Builder)builder).optionalRequirements, ((Builder)builder).runtimeOnlyRequirements, ((Builder)builder).dynamicRequirements, ((Builder)builder).dynamicOptionalRequirements);
        this.runtimeAPI = ((Builder)builder).runtimeAPI;
        this.serviceNameProvider = ((Builder)builder).getServiceNameProvider();
        this.dynamicNameElement = null;
    }

    private RuntimeCapability(String baseName, String dynamicElement, ServiceNameProvider provider, T runtimeAPI, Set<String> requirements, Set<String> optionalRequirements, Set<String> runtimeOnlyRequirements, Set<String> dynamicRequirements, Set<String> dynamicOptionalRequirements) {
        super(RuntimeCapability.buildDynamicCapabilityName(baseName, dynamicElement), false, requirements, optionalRequirements, runtimeOnlyRequirements, dynamicRequirements, dynamicOptionalRequirements);
        this.runtimeAPI = runtimeAPI;
        this.serviceNameProvider = provider;
        this.dynamicNameElement = dynamicElement;
    }

    public ServiceName getCapabilityServiceName(Class serviceType) {
        return this.dynamicNameElement == null ? this.serviceNameProvider.getCapabilityServiceName(serviceType) : this.serviceNameProvider.getCapabilityServiceName(serviceType, this.dynamicNameElement);
    }

    public T getRuntimeAPI() {
        return this.runtimeAPI;
    }

    public static class Builder<T> {
        private final String baseName;
        private final T runtimeAPI;
        private final boolean dynamic;
        private ServiceNameProvider serviceNameProvider;
        private Set<String> requirements;
        private Set<String> optionalRequirements;
        private Set<String> runtimeOnlyRequirements;
        private Set<String> dynamicRequirements;
        private Set<String> dynamicOptionalRequirements;

        public static Builder<Void> of(String name) {
            return new Builder<Object>(name, false, null);
        }

        public static Builder<Void> of(String name, boolean dynamic) {
            return new Builder<Object>(name, dynamic, null);
        }

        public static Builder<Void> of(String name, Class<?> serviceType) {
            return new Builder<Object>(name, false, null).setServiceType(serviceType);
        }

        public static Builder<Void> of(String name, boolean dynamic, Class<?> serviceType) {
            return new Builder<Object>(name, dynamic, null).setServiceType(serviceType);
        }

        public static <T> Builder<T> of(String name, T runtimeAPI) {
            return new Builder<T>(name, false, runtimeAPI);
        }

        public static <T> Builder<T> of(String name, boolean dynamic, T runtimeAPI) {
            return new Builder<T>(name, dynamic, runtimeAPI);
        }

        private Builder(String baseName, boolean dynamic, T runtimeAPI) {
            assert (baseName != null);
            assert (baseName.length() > 0);
            this.baseName = baseName;
            this.runtimeAPI = runtimeAPI;
            this.dynamic = dynamic;
        }

        public Builder<T> setServiceType(Class<?> type) {
            return this.setServiceNameProvider(new ServiceNameProvider.DefaultProvider(this.baseName, type));
        }

        public Builder<T> setServiceNameProvider(ServiceNameProvider provider) {
            if (this.serviceNameProvider != null) {
                throw new IllegalStateException();
            }
            this.serviceNameProvider = provider;
            return this;
        }

        public Builder<T> addRequirements(String ... requirements) {
            assert (requirements != null);
            if (this.requirements == null) {
                this.requirements = new HashSet<String>(requirements.length);
            }
            Collections.addAll(this.requirements, requirements);
            return this;
        }

        public Builder<T> addOptionalRequirements(String ... requirements) {
            assert (requirements != null);
            if (this.optionalRequirements == null) {
                this.optionalRequirements = new HashSet<String>(requirements.length);
            }
            Collections.addAll(this.optionalRequirements, requirements);
            return this;
        }

        public Builder<T> addRuntimeOnlyRequirements(String ... requirements) {
            assert (requirements != null);
            if (this.runtimeOnlyRequirements == null) {
                this.runtimeOnlyRequirements = new HashSet<String>(requirements.length);
            }
            Collections.addAll(this.runtimeOnlyRequirements, requirements);
            return this;
        }

        public Builder<T> addDynamicRequirements(String ... requirements) {
            assert (requirements != null);
            if (this.dynamicRequirements == null) {
                this.dynamicRequirements = new HashSet<String>(requirements.length);
            }
            Collections.addAll(this.dynamicRequirements, requirements);
            return this;
        }

        public Builder<T> addDynamicOptionalRequirements(String ... requirements) {
            assert (requirements != null);
            if (this.dynamicOptionalRequirements == null) {
                this.dynamicOptionalRequirements = new HashSet<String>(requirements.length);
            }
            Collections.addAll(this.dynamicOptionalRequirements, requirements);
            return this;
        }

        public RuntimeCapability<T> build() {
            return new RuntimeCapability(this);
        }

        private ServiceNameProvider getServiceNameProvider() {
            return this.serviceNameProvider == null ? new ServiceNameProvider.DefaultProvider(this.baseName) : this.serviceNameProvider;
        }
    }
}

