/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.capability.registry;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.Capability;
import org.jboss.as.controller.capability.registry.CapabilityContext;
import org.jboss.as.controller.capability.registry.CapabilityId;
import org.jboss.as.controller.capability.registry.RegistrationPoint;

public class CapabilityRegistration<C extends Capability> {
    private final Map<PathAddress, RegistrationPoint> registrationPoints = new LinkedHashMap<PathAddress, RegistrationPoint>();
    private final C capability;
    private final CapabilityId id;

    public CapabilityRegistration(C capability, CapabilityContext context) {
        this.capability = capability;
        this.id = new CapabilityId(capability.getName(), context);
    }

    public CapabilityRegistration(C capability, CapabilityContext context, RegistrationPoint registrationPoint) {
        this(capability, context);
        this.registrationPoints.put(registrationPoint.getAddress(), registrationPoint);
    }

    public CapabilityRegistration(CapabilityRegistration<C> toCopy) {
        this(toCopy.getCapability(), toCopy.getCapabilityContext());
        this.registrationPoints.putAll(toCopy.registrationPoints);
    }

    public C getCapability() {
        return this.capability;
    }

    public CapabilityContext getCapabilityContext() {
        return this.id.getContext();
    }

    public String getCapabilityName() {
        return this.id.getName();
    }

    public CapabilityId getCapabilityId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CapabilityRegistration that = (CapabilityRegistration)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public synchronized RegistrationPoint getOldestRegistrationPoint() {
        return this.registrationPoints.size() == 0 ? null : this.registrationPoints.values().iterator().next();
    }

    public synchronized Set<RegistrationPoint> getRegistrationPoints() {
        return Collections.unmodifiableSet(new HashSet<RegistrationPoint>(this.registrationPoints.values()));
    }

    public synchronized boolean addRegistrationPoint(RegistrationPoint toAdd) {
        PathAddress addedAddress = toAdd.getAddress();
        if (this.registrationPoints.containsKey(addedAddress)) {
            return false;
        }
        this.registrationPoints.put(addedAddress, toAdd);
        return true;
    }

    public synchronized boolean removeRegistrationPoint(RegistrationPoint toAdd) {
        PathAddress addedAddress = toAdd.getAddress();
        if (!this.registrationPoints.containsKey(addedAddress)) {
            return false;
        }
        this.registrationPoints.remove(addedAddress);
        return true;
    }

    public synchronized int getRegistrationPointCount() {
        return this.registrationPoints.size();
    }
}

