/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelType;

public abstract class OperationDefinition {
    protected final String name;
    protected final OperationEntry.EntryType entryType;
    protected final Set<OperationEntry.Flag> flags;
    protected final AttributeDefinition[] parameters;
    protected final ModelType replyType;
    protected final ModelType replyValueType;
    protected final boolean replyAllowNull;
    protected final DeprecationData deprecationData;
    protected final AttributeDefinition[] replyParameters;
    protected final List<AccessConstraintDefinition> accessConstraints;
    protected final DescriptionProvider descriptionProvider;

    protected OperationDefinition(SimpleOperationDefinitionBuilder builder) {
        this.name = builder.name;
        this.entryType = builder.entryType;
        this.flags = OperationEntry.Flag.immutableSetOf(builder.flags);
        this.parameters = builder.parameters;
        this.replyType = builder.replyType;
        this.replyValueType = builder.replyValueType;
        this.replyAllowNull = builder.replyAllowNull;
        this.deprecationData = builder.deprecationData;
        this.replyParameters = builder.replyParameters;
        this.accessConstraints = builder.accessConstraints == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(builder.accessConstraints));
        this.descriptionProvider = builder.descriptionProvider;
    }

    public String getName() {
        return this.name;
    }

    public OperationEntry.EntryType getEntryType() {
        return this.entryType;
    }

    public Set<OperationEntry.Flag> getFlags() {
        return this.flags;
    }

    public AttributeDefinition[] getParameters() {
        return this.parameters;
    }

    public ModelType getReplyType() {
        return this.replyType;
    }

    public ModelType getReplyValueType() {
        return this.replyValueType;
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }

    public abstract DescriptionProvider getDescriptionProvider();

    public DeprecationData getDeprecationData() {
        return this.deprecationData;
    }

    public boolean isDeprecated() {
        return this.deprecationData != null;
    }

    public boolean isReplyAllowNull() {
        return this.replyAllowNull;
    }

    public AttributeDefinition[] getReplyParameters() {
        return this.replyParameters;
    }
}

