/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class EnumValidator<E extends Enum<E>>
extends ModelTypeValidator
implements AllowedValuesValidator {
    private final Set<E> allowedValues;
    private final Class<E> enumType;
    private final Map<String, E> toStringMap = new HashMap<String, E>();

    @SafeVarargs
    public EnumValidator(Class<E> enumType, E ... allowed) {
        this(enumType, EnumValidator.setOf(enumType, allowed), true);
    }

    public EnumValidator(Class<E> enumType, Set<E> allowed) {
        this(enumType, allowed, false);
    }

    private EnumValidator(Class<E> enumType, Set<E> allowed, boolean safe) {
        super(ModelType.STRING);
        if (safe) {
            this.enumType = enumType;
            this.allowedValues = allowed;
        } else {
            assert (enumType != null);
            assert (allowed != null);
            this.enumType = enumType;
            this.allowedValues = EnumSet.copyOf(allowed);
        }
        for (Enum value : this.allowedValues) {
            this.toStringMap.put(value.toString(), value);
        }
    }

    @SafeVarargs
    private static <T extends Enum<T>> EnumSet<T> setOf(Class<T> enumType, T ... allowed) {
        assert (enumType != null);
        assert (allowed != null);
        EnumSet<T> set = EnumSet.noneOf(enumType);
        Collections.addAll(set, allowed);
        return set;
    }

    public static <E extends Enum<E>> EnumValidator<E> create(Class<E> enumType) {
        return new EnumValidator<E>(enumType, EnumSet.allOf(enumType), true);
    }

    @SafeVarargs
    public static <E extends Enum<E>> EnumValidator<E> create(Class<E> enumType, E ... allowed) {
        return new EnumValidator(enumType, allowed);
    }

    public static <E extends Enum<E>> EnumValidator<E> create(Class<E> enumType, EnumSet<E> allowed) {
        return new EnumValidator<E>(enumType, allowed);
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        ModelType type = value.getType();
        if (type == ModelType.STRING) {
            String tuString = ExpressionResolver.SIMPLE.resolveExpressions(value).asString();
            Enum enumValue = (Enum)this.toStringMap.get(tuString);
            if (enumValue == null) {
                try {
                    enumValue = Enum.valueOf(this.enumType, tuString.toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException e) {
                    throw ControllerLogger.ROOT_LOGGER.invalidEnumValue(tuString, parameterName, this.toStringMap.keySet());
                }
            }
            if (!this.allowedValues.contains(enumValue)) {
                throw ControllerLogger.ROOT_LOGGER.invalidEnumValue(tuString, parameterName, this.toStringMap.keySet());
            }
            if (!value.isProtected()) {
                value.set(enumValue.toString());
            }
        }
    }

    @Override
    public List<ModelNode> getAllowedValues() {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        for (Enum value : this.allowedValues) {
            if (value.toString() != null) {
                result.add(new ModelNode().set(value.toString()));
                continue;
            }
            result.add(new ModelNode().set(value.name()));
        }
        return result;
    }
}

