/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.capability;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jboss.as.controller.Feature;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.controller.capability.BinaryCapabilityNameResolver;
import org.jboss.as.controller.capability.Capability;
import org.jboss.as.controller.capability.QuaternaryCapabilityNameResolver;
import org.jboss.as.controller.capability.TernaryCapabilityNameResolver;
import org.jboss.as.controller.capability.UnaryCapabilityNameResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.version.Stability;
import org.jboss.msc.service.ServiceName;
import org.wildfly.common.Assert;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.service.descriptor.QuaternaryServiceDescriptor;
import org.wildfly.service.descriptor.TernaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;

public class RuntimeCapability<T>
implements Capability,
Feature {
    private static final boolean ALLOW_MULTIPLE = false;
    private final String name;
    private final boolean dynamic;
    private final Set<String> requirements;
    private final Function<PathAddress, String[]> dynamicNameMapper;
    private final Class<?> serviceValueType;
    private volatile ServiceName serviceName;
    private final T runtimeAPI;
    private final boolean allowMultipleRegistrations;
    private final Stability stability;

    public static String buildDynamicCapabilityName(String baseName, String dynamicNameElement) {
        return RuntimeCapability.buildDynamicCapabilityName(baseName, new String[]{dynamicNameElement});
    }

    public RuntimeCapability<T> fromBaseCapability(String dynamicElement) {
        return this.fromBaseCapability(new String[]{dynamicElement});
    }

    public static String buildDynamicCapabilityName(String baseName, String ... dynamicNameElement) {
        assert (baseName != null);
        assert (dynamicNameElement != null);
        assert (dynamicNameElement.length > 0);
        StringBuilder sb = new StringBuilder(baseName);
        for (String part : dynamicNameElement) {
            sb.append(".").append(part);
        }
        return sb.toString();
    }

    public static <T> String resolveCapabilityName(UnaryServiceDescriptor<T> descriptor, String name) {
        Map.Entry resolved = descriptor.resolve(name);
        return RuntimeCapability.buildDynamicCapabilityName((String)resolved.getKey(), (String[])resolved.getValue());
    }

    public static <T> String resolveCapabilityName(BinaryServiceDescriptor<T> descriptor, String parent, String child) {
        Map.Entry resolved = descriptor.resolve(parent, child);
        return RuntimeCapability.buildDynamicCapabilityName((String)resolved.getKey(), (String[])resolved.getValue());
    }

    public static <T> String resolveCapabilityName(TernaryServiceDescriptor<T> descriptor, String grandparent, String parent, String child) {
        Map.Entry resolved = descriptor.resolve(grandparent, parent, child);
        return RuntimeCapability.buildDynamicCapabilityName((String)resolved.getKey(), (String[])resolved.getValue());
    }

    public static <T> String resolveCapabilityName(QuaternaryServiceDescriptor<T> descriptor, String greatGrandparent, String grandparent, String parent, String child) {
        Map.Entry resolved = descriptor.resolve(greatGrandparent, grandparent, parent, child);
        return RuntimeCapability.buildDynamicCapabilityName((String)resolved.getKey(), (String[])resolved.getValue());
    }

    private RuntimeCapability(Builder<T> builder) {
        assert (builder.baseName != null);
        this.name = builder.baseName;
        this.dynamic = builder.dynamic;
        this.requirements = RuntimeCapability.establishRequirements(builder.requirements);
        this.dynamicNameMapper = Objects.requireNonNullElse(builder.dynamicNameMapper, UnaryCapabilityNameResolver.DEFAULT);
        this.runtimeAPI = builder.runtimeAPI;
        this.serviceValueType = builder.serviceValueType;
        this.allowMultipleRegistrations = builder.allowMultipleRegistrations;
        this.stability = builder.stability;
    }

    private static Set<String> establishRequirements(Set<String> input) {
        if (input != null && !input.isEmpty()) {
            return Set.copyOf(input);
        }
        return Collections.emptySet();
    }

    private RuntimeCapability(String baseName, Class<?> serviceValueType, ServiceName baseServiceName, T runtimeAPI, Set<String> requirements, boolean allowMultipleRegistrations, Function<PathAddress, String[]> dynamicNameMapper, Stability stability, String ... dynamicElement) {
        this.name = RuntimeCapability.buildDynamicCapabilityName(baseName, dynamicElement);
        this.dynamic = false;
        this.requirements = RuntimeCapability.establishRequirements(requirements);
        this.dynamicNameMapper = Objects.requireNonNullElse(dynamicNameMapper, UnaryCapabilityNameResolver.DEFAULT);
        this.runtimeAPI = runtimeAPI;
        this.serviceValueType = serviceValueType;
        if (serviceValueType != null) {
            Assert.assertNotNull((Object)baseServiceName);
            this.serviceName = baseServiceName.append(dynamicElement);
        } else assert (baseServiceName == null);
        this.allowMultipleRegistrations = allowMultipleRegistrations;
        this.stability = stability;
    }

    public ServiceName getCapabilityServiceName() {
        return this.getCapabilityServiceName((Class)null);
    }

    public ServiceName getCapabilityServiceName(Class<?> serviceValueType) {
        if (this.serviceValueType == null || serviceValueType != null && !serviceValueType.isAssignableFrom(this.serviceValueType)) {
            throw ControllerLogger.MGMT_OP_LOGGER.invalidCapabilityServiceType(this.getName(), serviceValueType);
        }
        return this.getServiceName();
    }

    public ServiceName getCapabilityServiceName(String ... dynamicNameElements) {
        return this.getCapabilityServiceName((Class<?>)null, dynamicNameElements);
    }

    public ServiceName getCapabilityServiceName(PathAddress address) {
        return this.getCapabilityServiceName(address, null);
    }

    public ServiceName getCapabilityServiceName(String dynamicNameElement, Class<?> serviceValueType) {
        return this.getCapabilityServiceName(serviceValueType, dynamicNameElement);
    }

    public ServiceName getCapabilityServiceName(Class<?> serviceValueType, String ... dynamicNameElements) {
        return this.fromBaseCapability(dynamicNameElements).getCapabilityServiceName(serviceValueType);
    }

    public ServiceName getCapabilityServiceName(PathAddress address, Class<?> serviceValueType) {
        return this.fromBaseCapability(address).getCapabilityServiceName(serviceValueType);
    }

    public Class<?> getCapabilityServiceValueType() {
        return this.serviceValueType;
    }

    public T getRuntimeAPI() {
        return this.runtimeAPI;
    }

    public boolean isAllowMultipleRegistrations() {
        return this.allowMultipleRegistrations;
    }

    public RuntimeCapability<T> fromBaseCapability(String ... dynamicElement) {
        assert (this.isDynamicallyNamed());
        assert (dynamicElement != null);
        assert (dynamicElement.length > 0);
        return new RuntimeCapability<T>(this.getName(), this.serviceValueType, this.getServiceName(), this.runtimeAPI, this.getRequirements(), this.allowMultipleRegistrations, this.dynamicNameMapper, this.stability, dynamicElement);
    }

    private ServiceName getServiceName() {
        ServiceName result = this.serviceName;
        if (result == null && this.serviceValueType != null) {
            result = this.serviceName = ServiceNameFactory.parseServiceName(this.getName());
        }
        return result;
    }

    public RuntimeCapability<T> fromBaseCapability(PathAddress path) {
        assert (this.isDynamicallyNamed());
        assert (path != null);
        String[] dynamicElement = this.dynamicNameMapper.apply(path);
        assert (dynamicElement.length > 0);
        return new RuntimeCapability<T>(this.getName(), this.serviceValueType, this.getServiceName(), this.runtimeAPI, this.getRequirements(), this.allowMultipleRegistrations, this.dynamicNameMapper, this.stability, dynamicElement);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<String> getRequirements() {
        return this.requirements;
    }

    @Override
    public boolean isDynamicallyNamed() {
        return this.dynamic;
    }

    @Override
    public String getDynamicName(String dynamicNameElement) {
        if (!this.dynamic) {
            throw new IllegalStateException();
        }
        return this.name + "." + dynamicNameElement;
    }

    @Override
    public String getDynamicName(PathAddress address) {
        if (!this.dynamic) {
            throw new IllegalStateException();
        }
        String[] dynamicElements = this.dynamicNameMapper.apply(address);
        return RuntimeCapability.buildDynamicCapabilityName(this.name, dynamicElements);
    }

    @Override
    public Stability getStability() {
        return this.stability;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuntimeCapability that = (RuntimeCapability)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public static class Builder<T> {
        private final String baseName;
        private final T runtimeAPI;
        private final boolean dynamic;
        private Class<?> serviceValueType;
        private Set<String> requirements;
        private boolean allowMultipleRegistrations = false;
        private Function<PathAddress, String[]> dynamicNameMapper = UnaryCapabilityNameResolver.DEFAULT;
        private Stability stability = Stability.DEFAULT;

        public static Builder<Void> of(String name) {
            return new Builder<Object>(name, false, null);
        }

        public static Builder<Void> of(String name, boolean dynamic) {
            return new Builder<Object>(name, dynamic, null);
        }

        public static Builder<Void> of(String name, Class<?> serviceValueType) {
            return new Builder<Object>(name, false, null).setServiceType(serviceValueType);
        }

        public static Builder<Void> of(String name, boolean dynamic, Class<?> serviceValueType) {
            return new Builder<Object>(name, dynamic, null).setServiceType(serviceValueType);
        }

        public static <T> Builder<T> of(String name, T runtimeAPI) {
            return new Builder<T>(name, false, runtimeAPI);
        }

        public static <T> Builder<T> of(String name, boolean dynamic, T runtimeAPI) {
            return new Builder<T>(name, dynamic, runtimeAPI);
        }

        public static Builder<Void> of(NullaryServiceDescriptor<?> descriptor) {
            return new Builder<Object>(descriptor.getName(), false, null).setServiceType(descriptor.getType());
        }

        public static Builder<Void> of(UnaryServiceDescriptor<?> descriptor) {
            return new Builder<Object>(descriptor.getName(), true, null).setServiceType(descriptor.getType()).setDynamicNameMapper(UnaryCapabilityNameResolver.DEFAULT);
        }

        public static Builder<Void> of(BinaryServiceDescriptor<?> descriptor) {
            return new Builder<Object>(descriptor.getName(), true, null).setServiceType(descriptor.getType()).setDynamicNameMapper(BinaryCapabilityNameResolver.PARENT_CHILD);
        }

        public static Builder<Void> of(TernaryServiceDescriptor<?> descriptor) {
            return new Builder<Object>(descriptor.getName(), true, null).setServiceType(descriptor.getType()).setDynamicNameMapper(TernaryCapabilityNameResolver.GRANDPARENT_PARENT_CHILD);
        }

        public static Builder<Void> of(QuaternaryServiceDescriptor<?> descriptor) {
            return new Builder<Object>(descriptor.getName(), true, null).setServiceType(descriptor.getType()).setDynamicNameMapper(QuaternaryCapabilityNameResolver.GREATGRANDPARENT_GRANDPARENT_PARENT_CHILD);
        }

        private Builder(String baseName, boolean dynamic, T runtimeAPI) {
            assert (baseName != null);
            assert (baseName.length() > 0);
            this.baseName = baseName;
            this.runtimeAPI = runtimeAPI;
            this.dynamic = dynamic;
        }

        public Builder<T> setServiceType(Class<?> type) {
            this.serviceValueType = type;
            return this;
        }

        public Builder<T> addRequirements(String ... requirements) {
            assert (requirements != null);
            if (this.requirements == null) {
                this.requirements = new HashSet<String>(requirements.length);
            }
            Collections.addAll(this.requirements, requirements);
            return this;
        }

        public Builder<T> setAllowMultipleRegistrations(boolean allowMultipleRegistrations) {
            this.allowMultipleRegistrations = allowMultipleRegistrations;
            return this;
        }

        public Builder<T> setDynamicNameMapper(Function<PathAddress, String[]> mapper) {
            assert (mapper != null);
            this.dynamicNameMapper = mapper;
            return this;
        }

        public Builder<T> setStability(Stability stability) {
            this.stability = stability;
            return this;
        }

        public RuntimeCapability<T> build() {
            return new RuntimeCapability(this);
        }
    }
}

