/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.InputStream;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractOperationContext;
import org.jboss.as.controller.CapabilityServiceTarget;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ManagementModel;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelControllerImpl;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.access.ResourceAuthorization;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.notification.Notification;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.version.Stability;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityIdentity;

class ReadOnlyContext
extends AbstractOperationContext {
    private final int operationId;
    private final ModelControllerImpl controller;
    private final AbstractOperationContext primaryContext;
    private final ModelControllerImpl.ManagementModelImpl managementModel;
    private final ConcurrentMap<OperationContext.AttachmentKey<?>, Object> valueAttachments = new ConcurrentHashMap();

    ReadOnlyContext(ProcessType processType, Stability stability, RunningMode runningMode, ModelController.OperationTransactionControl transactionControl, ControlledProcessState processState, boolean booting, ModelControllerImpl.ManagementModelImpl managementModel, AbstractOperationContext primaryContext, ModelControllerImpl controller, int operationId, Supplier<SecurityIdentity> securityIdentitySupplier) {
        super(processType, stability, runningMode, transactionControl, processState, booting, controller.getAuditLogger(), controller.getNotificationSupport(), controller, true, null, null, securityIdentitySupplier);
        this.primaryContext = primaryContext;
        this.controller = controller;
        this.operationId = operationId;
        this.managementModel = managementModel;
    }

    @Override
    OperationContext.ResultAction executeOperation() {
        AbstractOperationContext.controllingThread.set(this.primaryContext.initiatingThread);
        try {
            OperationContext.ResultAction resultAction = super.executeOperation();
            return resultAction;
        }
        finally {
            AbstractOperationContext.controllingThread.remove();
        }
    }

    @Override
    ModelControllerImpl.ManagementModelImpl getManagementModel() {
        return this.managementModel;
    }

    @Override
    void awaitServiceContainerStability() throws InterruptedException {
    }

    @Override
    ConfigurationPersister.PersistenceResource createPersistenceResource() throws ConfigurationPersistenceException {
        return null;
    }

    @Override
    void operationRollingBack() {
    }

    @Override
    void waitForRemovals() throws InterruptedException {
    }

    @Override
    boolean isReadOnly() {
        return true;
    }

    @Override
    ManagementResourceRegistration getRootResourceRegistrationForUpdate() {
        throw this.readOnlyContext();
    }

    @Override
    boolean isBootOperation() {
        return this.isBooting();
    }

    @Override
    public InputStream getAttachmentStream(int index) {
        throw this.readOnlyContext();
    }

    @Override
    public int getAttachmentStreamCount() {
        return 0;
    }

    @Override
    public boolean isRollbackOnRuntimeFailure() {
        return false;
    }

    @Override
    public boolean isResourceServiceRestartAllowed() {
        return false;
    }

    @Override
    public ImmutableManagementResourceRegistration getResourceRegistration() {
        return this.managementModel.getRootResourceRegistration().getSubModel(this.activeStep.address);
    }

    @Override
    public ManagementResourceRegistration getResourceRegistrationForUpdate() {
        throw this.readOnlyContext();
    }

    @Override
    public ImmutableManagementResourceRegistration getRootResourceRegistration() {
        return this.managementModel.getRootResourceRegistration();
    }

    @Override
    public ServiceRegistry getServiceRegistry(boolean modify) throws UnsupportedOperationException {
        if (modify) {
            throw this.readOnlyContext();
        }
        return this.primaryContext.getServiceRegistry(false);
    }

    @Override
    public ServiceController<?> removeService(ServiceName name) throws UnsupportedOperationException {
        throw this.readOnlyContext();
    }

    @Override
    public void removeService(ServiceController<?> controller) throws UnsupportedOperationException {
        throw this.readOnlyContext();
    }

    @Override
    public CapabilityServiceTarget getCapabilityServiceTarget() throws UnsupportedOperationException {
        return this.primaryContext.getCapabilityServiceTarget();
    }

    @Override
    public void acquireControllerLock() {
        if (this.lockStep == null) {
            try {
                this.controller.acquireWriteLock(this.operationId, true);
                this.recordWriteLock();
            }
            catch (InterruptedException e) {
                this.cancelled = true;
                Thread.currentThread().interrupt();
                throw ControllerLogger.ROOT_LOGGER.operationCancelledAsynchronously();
            }
        }
    }

    @Override
    void releaseStepLocks(AbstractOperationContext.AbstractStep step) {
        if (step.matches(this.lockStep)) {
            this.lockStep = null;
            this.controller.releaseWriteLock(this.operationId);
        }
    }

    @Override
    public Resource createResource(PathAddress address) throws UnsupportedOperationException {
        throw this.readOnlyContext();
    }

    @Override
    public void addResource(PathAddress address, Resource toAdd) {
        throw this.readOnlyContext();
    }

    @Override
    public void addResource(PathAddress address, int index, Resource toAdd) {
        throw this.readOnlyContext();
    }

    @Override
    public Resource readResource(PathAddress requestAddress) {
        return this.readResource(requestAddress, true);
    }

    @Override
    public Resource readResource(PathAddress requestAddress, boolean recursive) {
        PathAddress address = this.activeStep.address.append(requestAddress);
        return this.readResourceFromRoot(address, recursive);
    }

    @Override
    public Resource readResourceFromRoot(PathAddress address) {
        return this.readResourceFromRoot(address, true);
    }

    @Override
    public Resource readResourceFromRoot(PathAddress address, boolean recursive) {
        return this.readResourceFromRoot(this.managementModel, address, recursive);
    }

    @Override
    Resource readResourceFromRoot(ManagementModel model, PathAddress address, boolean recursive) {
        return this.primaryContext.readResourceFromRoot(model, address, recursive);
    }

    @Override
    public Resource readResourceForUpdate(PathAddress relativeAddress) {
        throw this.readOnlyContext();
    }

    @Override
    public Resource removeResource(PathAddress relativeAddress) throws UnsupportedOperationException {
        throw this.readOnlyContext();
    }

    @Override
    public Resource getOriginalRootResource() {
        return this.primaryContext.getOriginalRootResource();
    }

    @Override
    public boolean isModelAffected() {
        return false;
    }

    @Override
    public boolean isResourceRegistryAffected() {
        return this.primaryContext.isResourceRegistryAffected();
    }

    @Override
    public boolean isRuntimeAffected() {
        return this.primaryContext.isRuntimeAffected();
    }

    @Override
    public OperationContext.Stage getCurrentStage() {
        return this.currentStage;
    }

    @Override
    public void report(MessageSeverity severity, String message) {
    }

    @Override
    public boolean markResourceRestarted(PathAddress resource, Object owner) {
        return false;
    }

    @Override
    public boolean revertResourceRestarted(PathAddress resource, Object owner) {
        return false;
    }

    @Override
    public ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
        return this.primaryContext.resolveExpressions(node);
    }

    @Override
    public <T> T getAttachment(OperationContext.AttachmentKey<T> key) {
        if (this.valueAttachments.containsKey(key)) {
            return key.cast(this.valueAttachments.get(key));
        }
        return this.primaryContext.getAttachment(key);
    }

    public <V> V attach(OperationContext.AttachmentKey<V> key, V value) {
        Assert.checkNotNullParam((String)"key", key);
        return key.cast(this.valueAttachments.put(key, value));
    }

    public <V> V attachIfAbsent(OperationContext.AttachmentKey<V> key, V value) {
        Assert.checkNotNullParam((String)"key", key);
        return key.cast(this.valueAttachments.putIfAbsent(key, value));
    }

    public <V> V detach(OperationContext.AttachmentKey<V> key) {
        Assert.checkNotNullParam((String)"key", key);
        return key.cast(this.valueAttachments.remove(key));
    }

    @Override
    public AuthorizationResult authorize(ModelNode operation) {
        return this.primaryContext.authorize(operation);
    }

    @Override
    public AuthorizationResult authorize(ModelNode operation, Set<Action.ActionEffect> effects) {
        return this.primaryContext.authorize(operation, effects);
    }

    @Override
    public AuthorizationResult authorize(ModelNode operation, String attribute, ModelNode currentValue) {
        return this.primaryContext.authorize(operation, attribute, currentValue);
    }

    @Override
    public AuthorizationResult authorize(ModelNode operation, String attribute, ModelNode currentValue, Set<Action.ActionEffect> effects) {
        return this.primaryContext.authorize(operation, attribute, currentValue, effects);
    }

    IllegalStateException readOnlyContext() {
        return ControllerLogger.ROOT_LOGGER.readOnlyContext();
    }

    @Override
    public AuthorizationResult authorizeOperation(ModelNode operation) {
        return this.primaryContext.authorizeOperation(operation);
    }

    @Override
    public ResourceAuthorization authorizeResource(boolean attributes, boolean isDefaultResource) {
        return this.primaryContext.authorizeResource(attributes, isDefaultResource);
    }

    @Override
    public void emit(Notification notification) {
        throw this.readOnlyContext();
    }

    @Override
    Resource getModel() {
        return this.primaryContext.getModel();
    }

    public void registerCapability(RuntimeCapability capability) {
        throw this.readOnlyContext();
    }

    @Override
    public void registerAdditionalCapabilityRequirement(String required, String dependent, String attribute) {
        throw this.readOnlyContext();
    }

    @Override
    public boolean hasOptionalCapability(String required, String dependent, String attribute) {
        throw this.readOnlyContext();
    }

    @Override
    public void requireOptionalCapability(String required, String dependent, String attribute) {
        throw this.readOnlyContext();
    }

    @Override
    public void deregisterCapabilityRequirement(String required, String dependent) {
        this.deregisterCapabilityRequirement(required, dependent, null);
    }

    @Override
    public void deregisterCapabilityRequirement(String required, String dependent, String attribute) {
        throw this.readOnlyContext();
    }

    @Override
    public void deregisterCapability(String capability) {
        throw this.readOnlyContext();
    }

    @Override
    public <T> T getCapabilityRuntimeAPI(String capabilityName, Class<T> apiType) {
        throw this.readOnlyContext();
    }

    @Override
    public <T> T getCapabilityRuntimeAPI(String capabilityBaseName, String dynamicPart, Class<T> apiType) {
        throw this.readOnlyContext();
    }

    @Override
    public ServiceName getCapabilityServiceName(String capabilityName, Class<?> type) {
        throw this.readOnlyContext();
    }

    @Override
    public ServiceName getCapabilityServiceName(String capabilityBaseName, String dynamicPart, Class<?> serviceType) {
        throw this.readOnlyContext();
    }

    @Override
    public ServiceName getCapabilityServiceName(String capabilityBaseName, Class<?> serviceType, String ... dynamicParts) {
        throw this.readOnlyContext();
    }

    @Override
    public CapabilityServiceSupport getCapabilityServiceSupport() {
        throw this.readOnlyContext();
    }
}

