/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access;

import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.dmr.ModelNode;

public class AuthorizationResult {
    public static final AuthorizationResult PERMITTED = new AuthorizationResult(Decision.PERMIT);
    private static final ModelNode NO_EXPLANATION = new ModelNode();
    private final Decision decision;
    private final ModelNode explanation;

    public AuthorizationResult(Decision decision) {
        this(decision, NO_EXPLANATION);
    }

    public AuthorizationResult(Decision decision, ModelNode explanation) {
        this.decision = decision;
        this.explanation = explanation == null ? NO_EXPLANATION : explanation;
    }

    public Decision getDecision() {
        return this.decision;
    }

    public ModelNode getExplanation() {
        return this.explanation;
    }

    public void failIfDenied(ModelNode operation) throws OperationFailedException {
        this.failIfDenied(operation, PathAddress.pathAddress(operation.get("address")));
    }

    public void failIfDenied(ModelNode operation, PathAddress targetAddress) throws OperationFailedException {
        if (this.decision == Decision.DENY) {
            throw ControllerLogger.ACCESS_LOGGER.unauthorized(operation.get("operation").asString(), targetAddress, this.explanation);
        }
    }

    static {
        NO_EXPLANATION.protect();
    }

    public static enum Decision {
        PERMIT,
        DENY;

    }
}

