/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.parsing;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.Feature;
import org.jboss.as.controller.parsing.ManagementSchema;
import org.jboss.as.controller.parsing.ManagementXmlReaderWriter;
import org.jboss.as.controller.parsing.ManagementXmlSchema;
import org.jboss.as.controller.parsing.UnstableManagementReaderWriter;
import org.jboss.as.version.Stability;
import org.jboss.staxmapper.IntVersion;

public abstract class ManagementSchemas {
    public static final String CURRENT = "urn:jboss:domain:20.0";
    private final Set<ManagementXmlSchema> additionalSchemas;
    private final ManagementXmlSchema currentSchema;

    /*
     * WARNING - void declaration
     */
    protected ManagementSchemas(Stability stability, ManagementXmlReaderWriter readerWriterDelegate, String localName) {
        void var8_10;
        HashSet<ManagementSchema> allSchemas = new HashSet<ManagementSchema>();
        int maxVersion = 0;
        Version[] versionArray = Version.values();
        int n = versionArray.length;
        boolean bl = false;
        while (var8_10 < n) {
            Version version = versionArray[var8_10];
            if (version.getMajorVersion() > maxVersion) {
                maxVersion = version.getMajorVersion();
            }
            allSchemas.add(ManagementSchema.create(stability.enables(version.getStability()) ? readerWriterDelegate : UnstableManagementReaderWriter.INSTANCE, version.getStability(), version.getMajorVersion(), version.getMinorVersion(), localName));
            ++var8_10;
        }
        HashSet<ManagementXmlSchema> current = new HashSet<ManagementXmlSchema>();
        for (ManagementXmlSchema managementXmlSchema : allSchemas) {
            if (((IntVersion)managementXmlSchema.getNamespace().getVersion()).major() != maxVersion) continue;
            current.add(managementXmlSchema);
        }
        this.currentSchema = (ManagementXmlSchema)Feature.map(current).get(stability);
        allSchemas.remove(this.currentSchema);
        this.additionalSchemas = Collections.unmodifiableSet(allSchemas);
    }

    public ManagementXmlSchema getCurrent() {
        return this.currentSchema;
    }

    public Set<ManagementXmlSchema> getAdditional() {
        return this.additionalSchemas;
    }

    private static enum Version implements Feature
    {
        VERSION_1_0(1, 0),
        VERSION_1_1(1, 1),
        VERSION_1_2(1, 2),
        VERSION_1_3(1, 3),
        VERSION_1_4(1, 4),
        VERSION_1_5(1, 5),
        VERSION_1_6(1, 6),
        VERSION_1_7(1, 7),
        VERSION_1_8(1, 8),
        VERSION_2_0(2, 0),
        VERSION_2_1(2, 1),
        VERSION_2_2(2, 2),
        VERSION_3_0(3, 0),
        VERSION_4_0(4, 0),
        VERSION_4_1(4, 1),
        VERSION_4_2(4, 2),
        VERSION_5(5),
        VERSION_6(6),
        VERSION_7(7),
        VERSION_8(8),
        VERSION_9(9),
        VERSION_10(10),
        VERSION_11(11),
        VERSION_12(12),
        VERSION_13(13),
        VERSION_14(14),
        VERSION_15(15),
        VERSION_16(16),
        VERSION_17(17),
        VERSION_18(18),
        VERSION_19(19),
        VERSION_20(20),
        VERSION_20_COMMUNITY(20, Stability.COMMUNITY);

        private final int majorVersion;
        private final int minorVersion;
        private final Stability stability;

        private Version(int majorVersion) {
            this(majorVersion, 0);
        }

        private Version(int majorVersion, Stability stability) {
            this(majorVersion, 0, stability);
        }

        private Version(int majorVersion, int minorVersion) {
            this(majorVersion, minorVersion, Stability.DEFAULT);
        }

        private Version(int majorVersion, int minorVersion, Stability stability) {
            this.majorVersion = majorVersion;
            this.minorVersion = minorVersion;
            this.stability = stability;
        }

        public int getMajorVersion() {
            return this.majorVersion;
        }

        public int getMinorVersion() {
            return this.minorVersion;
        }

        @Override
        public Stability getStability() {
            return this.stability;
        }
    }
}

