/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.LinkedHashMap;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.MultistepUtil;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class CompositeOperationHandler
implements OperationStepHandler {
    @Deprecated
    public static final OperationContext.AttachmentKey<Boolean> DOMAIN_EXECUTION_KEY = OperationContext.AttachmentKey.create(Boolean.class);
    public static final CompositeOperationHandler INSTANCE = new CompositeOperationHandler();
    public static final String NAME = "composite";
    private static final AttributeDefinition STEPS = new PrimitiveListAttributeDefinition.Builder("steps", ModelType.OBJECT).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("composite", ControllerResolver.getResolver("root")).addParameter(STEPS).setReplyType(ModelType.OBJECT).setReplyValueType(ModelType.OBJECT).build();
    public static final OperationDefinition INTERNAL_DEFINITION = new SimpleOperationDefinitionBuilder("composite", ControllerResolver.getResolver("root")).addParameter(STEPS).setReplyType(ModelType.OBJECT).setPrivateEntry().build();

    public static String getUnexplainedFailureMessage() {
        return ControllerLogger.ROOT_LOGGER.compositeOperationRolledBack();
    }

    protected CompositeOperationHandler() {
    }

    @Override
    public final void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        STEPS.validateOperation(operation);
        final ModelNode responseMap = context.getResult().setEmptyObject();
        List list = operation.get("steps").asList();
        LinkedHashMap operationMap = new LinkedHashMap();
        LinkedHashMap<String, ModelNode> addedResponses = new LinkedHashMap<String, ModelNode>();
        final int size = list.size();
        for (int i = 0; i < size; ++i) {
            String stepName = "step-" + (i + 1);
            operationMap.put(stepName, list.get(i));
            ModelNode stepResp = responseMap.get(stepName);
            addedResponses.put(stepName, stepResp);
        }
        boolean adjustStepAddresses = context.getCurrentAddress().size() > 0;
        MultistepUtil.recordOperationSteps(context, operationMap, addedResponses, this.getOperationHandlerResolver(), adjustStepAddresses);
        context.completeStep(new OperationContext.RollbackHandler(){

            @Override
            public void handleRollback(OperationContext context, ModelNode operation) {
                if (context.getAttachment(DOMAIN_EXECUTION_KEY) != null || context.hasFailureDescription()) {
                    return;
                }
                ModelNode failureMsg = new ModelNode();
                for (int i = 0; i < size; ++i) {
                    String stepName = "step-" + (i + 1);
                    ModelNode stepResponse = responseMap.get(stepName);
                    if (!stepResponse.hasDefined("failure-description")) continue;
                    failureMsg.get(new String[]{ControllerLogger.ROOT_LOGGER.compositeOperationFailed(), ControllerLogger.ROOT_LOGGER.operation(stepName)}).set(stepResponse.get("failure-description"));
                }
                if (!failureMsg.isDefined()) {
                    failureMsg.set(CompositeOperationHandler.getUnexplainedFailureMessage());
                }
                context.getFailureDescription().set(failureMsg);
            }
        });
    }

    protected MultistepUtil.OperationHandlerResolver getOperationHandlerResolver() {
        return MultistepUtil.OperationHandlerResolver.DEFAULT;
    }
}

