/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.management;

import java.util.List;
import java.util.function.Supplier;
import org.jboss.as.controller.AccessAuditContext;
import org.jboss.as.controller.access.management.SecurityActions;
import org.wildfly.security.auth.principal.AnonymousPrincipal;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.ServerAuthenticationContext;

public class ManagementSecurityIdentitySupplier
implements Supplier<SecurityIdentity> {
    private final SecurityDomain anonymousSecurityDomain = SecurityDomain.builder().setDefaultRealmName("Empty").addRealm("Empty", SecurityRealm.EMPTY_REALM).build().build();
    private volatile Supplier<SecurityDomain> configuredSecurityDomainSupplier;
    private volatile List<Supplier<SecurityDomain>> inflowSecurityDomainSuppliers;

    @Override
    public SecurityIdentity get() {
        SecurityDomain configuredSecurityDomain;
        SecurityIdentity securityIdentity;
        block12: {
            securityIdentity = null;
            AccessAuditContext accessAuditContext = SecurityActions.currentAccessAuditContext();
            if (accessAuditContext != null && accessAuditContext.isInflowed()) {
                return accessAuditContext.getSecurityIdentity();
            }
            SecurityDomain securityDomain = configuredSecurityDomain = this.configuredSecurityDomainSupplier != null ? this.configuredSecurityDomainSupplier.get() : null;
            if (configuredSecurityDomain != null) {
                securityIdentity = configuredSecurityDomain.getCurrentSecurityIdentity();
                if (!AnonymousPrincipal.getInstance().equals((Object)securityIdentity.getPrincipal())) {
                    return securityIdentity;
                }
            }
            if (accessAuditContext != null && (securityIdentity = accessAuditContext.getSecurityIdentity()) != null) {
                if (configuredSecurityDomain != null) {
                    ServerAuthenticationContext serverAuthenticationContext = SecurityActions.createServerAuthenticationContext(configuredSecurityDomain);
                    try {
                        if (serverAuthenticationContext.importIdentity(securityIdentity)) {
                            return serverAuthenticationContext.getAuthorizedIdentity();
                        }
                        break block12;
                    }
                    catch (IllegalStateException | RealmUnavailableException e) {
                        return this.anonymousSecurityDomain.getAnonymousSecurityIdentity();
                    }
                }
                return securityIdentity;
            }
        }
        if (this.inflowSecurityDomainSuppliers != null && configuredSecurityDomain != null) {
            for (Supplier<SecurityDomain> inflowSupplier : this.inflowSecurityDomainSuppliers) {
                SecurityDomain current = inflowSupplier.get();
                if (current == null) continue;
                securityIdentity = current.getCurrentSecurityIdentity();
                if (AnonymousPrincipal.getInstance().equals((Object)securityIdentity.getPrincipal())) continue;
                ServerAuthenticationContext serverAuthenticationContext = SecurityActions.createServerAuthenticationContext(configuredSecurityDomain);
                try {
                    if (!serverAuthenticationContext.importIdentity(securityIdentity)) continue;
                    return serverAuthenticationContext.getAuthorizedIdentity();
                }
                catch (IllegalStateException | RealmUnavailableException throwable) {
                }
            }
        }
        return this.anonymousSecurityDomain.getAnonymousSecurityIdentity();
    }

    public void setConfiguredSecurityDomainSupplier(Supplier<SecurityDomain> configuredSecurityDomainSupplier) {
        this.configuredSecurityDomainSupplier = configuredSecurityDomainSupplier;
    }

    public void setInflowSecurityDomainSuppliers(List<Supplier<SecurityDomain>> inflowSecurityDomainSuppliers) {
        this.inflowSecurityDomainSuppliers = inflowSecurityDomainSuppliers;
    }
}

