/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import java.util.ArrayList;
import java.util.Collections;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

class SimilarityIndex {
    private static final double SIMILARITY_THRESHOLD = 0.9;

    SimilarityIndex() {
    }

    private static String[] letterPairs(String str) {
        int numPairs = str.length() - 1;
        String[] pairs = new String[numPairs];
        for (int i = 0; i < numPairs; ++i) {
            pairs[i] = str.substring(i, i + 2);
        }
        return pairs;
    }

    private static ArrayList<String> wordLetterPairs(String str) {
        String[] words;
        ArrayList<String> allPairs = new ArrayList<String>();
        for (String word : words = str.split("\\s")) {
            String[] pairsInWord = SimilarityIndex.letterPairs(word);
            Collections.addAll(allPairs, pairsInWord);
        }
        return allPairs;
    }

    public static double compareStrings(String str1, String str2) {
        ArrayList<String> pairs1 = SimilarityIndex.wordLetterPairs(str1.toUpperCase());
        ArrayList<String> pairs2 = SimilarityIndex.wordLetterPairs(str2.toUpperCase());
        int intersection = 0;
        int union = pairs1.size() + pairs2.size();
        block0: for (String pair1 : pairs1) {
            for (int j = 0; j < pairs2.size(); ++j) {
                String pair2 = pairs2.get(j);
                if (!pair1.equals(pair2)) continue;
                ++intersection;
                pairs2.remove(j);
                continue block0;
            }
        }
        return 2.0 * (double)intersection / (double)union;
    }

    public static boolean isSimilar(String str1, String str2) {
        return SimilarityIndex.compareStrings(str1, str2) > 0.9;
    }

    public static double compareAttributes(AttributeDefinition attr1, AttributeDefinition attr2) {
        double res = 1.0;
        res *= SimilarityIndex.compareStrings(attr1.getName(), attr2.getName());
        res *= SimilarityIndex.compareStrings(attr1.getType().name(), attr2.getType().name());
        res *= SimilarityIndex.compareStrings(String.valueOf(attr1.isAllowExpression()), String.valueOf(attr2.isAllowExpression()));
        res *= SimilarityIndex.compareStrings(String.valueOf(attr1.isRequired()), String.valueOf(attr2.isRequired()));
        res *= attr1.isAllowExpression() == attr2.isAllowExpression() ? 1.0 : 0.9;
        return res *= attr1.isRequired() == attr2.isRequired() ? 1.0 : 0.9;
    }

    public static double compareAttributes(Property attr1, Property attr2) {
        double res = 1.0;
        res *= SimilarityIndex.compareStrings(attr1.getName(), attr2.getName());
        ModelNode node1 = attr1.getValue();
        ModelNode node2 = attr2.getValue();
        boolean expressions1 = node1.get("expressions-allowed").asBoolean(false);
        boolean expressions2 = node2.get("expressions-allowed").asBoolean(false);
        boolean nullable1 = node1.get("nillable").asBoolean(true);
        boolean nullable2 = node2.get("nillable").asBoolean(true);
        res *= SimilarityIndex.compareStrings(node1.getType().name(), node2.getType().name());
        res *= SimilarityIndex.compareStrings(node1.get("description").asString(), node2.get("description").asString());
        res *= expressions1 == expressions2 ? 1.0 : 0.9;
        return res *= nullable1 == nullable2 ? 1.0 : 0.9;
    }
}

