/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.management;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.management.BaseNativeInterfaceResourceDefinition;
import org.jboss.as.controller.management.NativeInterfaceCommonPolicy;
import org.jboss.dmr.ModelNode;
import org.jboss.remoting3.RemotingOptions;
import org.xnio.OptionMap;

public abstract class BaseNativeInterfaceAddStepHandler
extends AbstractAddStepHandler {
    protected BaseNativeInterfaceAddStepHandler(AttributeDefinition[] attributeDefinitions) {
        super(BaseNativeInterfaceResourceDefinition.NATIVE_MANAGEMENT_CAPABILITY, attributeDefinitions);
    }

    @Override
    public void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        final String securityRealm = this.asStringIfDefined(context, BaseNativeInterfaceResourceDefinition.SECURITY_REALM, model);
        String serverName = this.asStringIfDefined(context, BaseNativeInterfaceResourceDefinition.SERVER_NAME, model);
        OptionMap.Builder builder = OptionMap.builder();
        builder.set(RemotingOptions.SASL_PROTOCOL, (Object)BaseNativeInterfaceResourceDefinition.SASL_PROTOCOL.resolveModelAttribute(context, model).asString());
        if (serverName != null) {
            builder.set(RemotingOptions.SERVER_NAME, (Object)serverName);
        }
        final OptionMap options = builder.getMap();
        this.installServices(context, new NativeInterfaceCommonPolicy(){

            @Override
            public String getSecurityRealm() {
                return securityRealm;
            }

            @Override
            public OptionMap getConnectorOptions() {
                return options;
            }
        }, model);
    }

    private String asStringIfDefined(OperationContext context, AttributeDefinition attribute, ModelNode model) throws OperationFailedException {
        ModelNode attributeValue = attribute.resolveModelAttribute(context, model);
        return attributeValue.isDefined() ? attributeValue.asString() : null;
    }

    protected abstract void installServices(OperationContext var1, NativeInterfaceCommonPolicy var2, ModelNode var3) throws OperationFailedException;
}

