/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.Capability;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.registry.CapabilityId;
import org.jboss.as.controller.capability.registry.CapabilityRegistration;
import org.jboss.as.controller.capability.registry.CapabilityResolutionContext;
import org.jboss.as.controller.capability.registry.CapabilityScope;
import org.jboss.as.controller.capability.registry.ImmutableCapabilityRegistry;
import org.jboss.as.controller.capability.registry.PossibleCapabilityRegistry;
import org.jboss.as.controller.capability.registry.RegistrationPoint;
import org.jboss.as.controller.capability.registry.RuntimeCapabilityRegistration;
import org.jboss.as.controller.capability.registry.RuntimeCapabilityRegistry;
import org.jboss.as.controller.capability.registry.RuntimeRequirementRegistration;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.msc.service.ServiceName;

public final class CapabilityRegistry
implements ImmutableCapabilityRegistry,
PossibleCapabilityRegistry,
RuntimeCapabilityRegistry {
    private final Map<CapabilityId, RuntimeCapabilityRegistration> capabilities = new HashMap<CapabilityId, RuntimeCapabilityRegistration>();
    private final Map<CapabilityId, Map<String, RuntimeRequirementRegistration>> requirements = new HashMap<CapabilityId, Map<String, RuntimeRequirementRegistration>>();
    private final Map<CapabilityId, Map<String, RuntimeRequirementRegistration>> runtimeOnlyRequirements = new HashMap<CapabilityId, Map<String, RuntimeRequirementRegistration>>();
    private final boolean forServer;
    private final Set<CapabilityScope> knownContexts;
    private final ResolutionContextImpl resolutionContext = new ResolutionContextImpl();
    private final Map<CapabilityId, CapabilityRegistration> possibleCapabilities = new ConcurrentHashMap<CapabilityId, CapabilityRegistration>();
    private final Set<CapabilityId> reloadCapabilities = new HashSet<CapabilityId>();
    private final Set<CapabilityId> restartCapabilities = new HashSet<CapabilityId>();
    private final ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.reentrantReadWriteLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.reentrantReadWriteLock.writeLock();
    private final CapabilityRegistry publishedFullRegistry;
    private boolean modified = false;

    public CapabilityRegistry(boolean forServer) {
        this(forServer, null);
    }

    private CapabilityRegistry(boolean forServer, CapabilityRegistry parent) {
        this.forServer = forServer;
        this.knownContexts = forServer ? null : new HashSet();
        this.publishedFullRegistry = parent;
    }

    CapabilityRegistry createShadowCopy() {
        CapabilityRegistry result = new CapabilityRegistry(this.forServer, this);
        this.readLock.lock();
        try {
            try {
                result.writeLock.lock();
                this.copy(this, result);
            }
            finally {
                result.writeLock.unlock();
            }
        }
        finally {
            this.readLock.unlock();
        }
        return result;
    }

    private static void copyCapabilities(Map<CapabilityId, RuntimeCapabilityRegistration> source, Map<CapabilityId, RuntimeCapabilityRegistration> dest) {
        for (Map.Entry<CapabilityId, RuntimeCapabilityRegistration> entry : source.entrySet()) {
            dest.put(entry.getKey(), new RuntimeCapabilityRegistration(entry.getValue()));
        }
    }

    private static void copyRequirements(Map<CapabilityId, Map<String, RuntimeRequirementRegistration>> source, Map<CapabilityId, Map<String, RuntimeRequirementRegistration>> dest) {
        for (Map.Entry<CapabilityId, Map<String, RuntimeRequirementRegistration>> entry : source.entrySet()) {
            HashMap<String, RuntimeRequirementRegistration> mapCopy = new HashMap<String, RuntimeRequirementRegistration>();
            for (Map.Entry<String, RuntimeRequirementRegistration> innerEntry : entry.getValue().entrySet()) {
                mapCopy.put(innerEntry.getKey(), new RuntimeRequirementRegistration(innerEntry.getValue()));
            }
            dest.put(entry.getKey(), mapCopy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerCapability(RuntimeCapabilityRegistration capabilityRegistration) {
        this.writeLock.lock();
        try {
            CapabilityId capabilityId = capabilityRegistration.getCapabilityId();
            RegistrationPoint rp = capabilityRegistration.getOldestRegistrationPoint();
            RuntimeCapabilityRegistration currentRegistration = this.capabilities.get(capabilityId);
            if (currentRegistration != null) {
                if (!Objects.equals(capabilityRegistration.getCapability(), currentRegistration.getCapability()) || !currentRegistration.addRegistrationPoint(rp)) {
                    throw ControllerLogger.MGMT_OP_LOGGER.capabilityAlreadyRegisteredInContext(capabilityId.getName(), capabilityId.getScope().getName());
                }
            } else {
                this.capabilities.put(capabilityId, capabilityRegistration);
            }
            for (String req : ((RuntimeCapability)capabilityRegistration.getCapability()).getRequirements()) {
                this.registerRequirement(new RuntimeRequirementRegistration(req, capabilityId.getName(), capabilityId.getScope(), rp));
            }
            if (!this.forServer) {
                CapabilityScope capContext = capabilityId.getScope();
                this.knownContexts.add(capContext);
            }
            this.modified = true;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void registerAdditionalCapabilityRequirement(RuntimeRequirementRegistration requirement) {
        this.writeLock.lock();
        try {
            this.registerRequirement(requirement);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void registerRequirement(RuntimeRequirementRegistration requirement) {
        RuntimeRequirementRegistration existing;
        assert (this.writeLock.isHeldByCurrentThread());
        CapabilityId dependentId = requirement.getDependentId();
        if (!this.capabilities.containsKey(dependentId)) {
            throw ControllerLogger.MGMT_OP_LOGGER.unknownCapabilityInContext(dependentId.getName(), dependentId.getScope().getName());
        }
        Map<CapabilityId, Map<String, RuntimeRequirementRegistration>> requirementMap = requirement.isRuntimeOnly() ? this.runtimeOnlyRequirements : this.requirements;
        Map<String, RuntimeRequirementRegistration> dependents = requirementMap.get(dependentId);
        if (dependents == null) {
            dependents = new HashMap<String, RuntimeRequirementRegistration>();
            requirementMap.put(dependentId, dependents);
        }
        if ((existing = dependents.get(requirement.getRequiredName())) == null) {
            dependents.put(requirement.getRequiredName(), requirement);
        } else {
            existing.addRegistrationPoint(requirement.getOldestRegistrationPoint());
        }
        this.modified = true;
    }

    @Override
    public void removeCapabilityRequirement(RuntimeRequirementRegistration requirementRegistration) {
        this.writeLock.lock();
        try {
            this.removeRequirement(requirementRegistration, false);
            this.removeRequirement(requirementRegistration, true);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuntimeCapabilityRegistration removeCapability(String capabilityName, CapabilityScope scope, PathAddress registrationPoint) {
        this.writeLock.lock();
        try {
            RegistrationPoint rp;
            CapabilityId capabilityId = new CapabilityId(capabilityName, scope);
            RuntimeCapabilityRegistration removed = null;
            RuntimeCapabilityRegistration candidate = this.capabilities.get(capabilityId);
            if (candidate != null && candidate.removeRegistrationPoint(rp = new RegistrationPoint(registrationPoint, null))) {
                if (candidate.getRegistrationPointCount() == 0) {
                    removed = this.capabilities.remove(capabilityId);
                    this.requirements.remove(capabilityId);
                    this.runtimeOnlyRequirements.remove(capabilityId);
                } else {
                    Map<String, RuntimeRequirementRegistration> candidateRequirements = this.requirements.get(capabilityId);
                    if (candidateRequirements != null) {
                        for (String req : candidateRequirements.keySet().toArray(new String[candidateRequirements.size()])) {
                            this.removeRequirement(new RuntimeRequirementRegistration(req, capabilityName, scope, rp), false);
                        }
                    }
                    if ((candidateRequirements = this.runtimeOnlyRequirements.get(capabilityId)) != null) {
                        for (String req : candidateRequirements.keySet().toArray(new String[candidateRequirements.size()])) {
                            this.removeRequirement(new RuntimeRequirementRegistration(req, capabilityName, scope, rp), true);
                        }
                    }
                }
            }
            if (removed != null) {
                this.modified = true;
            }
            RuntimeCapabilityRegistration runtimeCapabilityRegistration = removed;
            return runtimeCapabilityRegistration;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void removeRequirement(RuntimeRequirementRegistration requirementRegistration, boolean optional) {
        RuntimeRequirementRegistration rrr;
        assert (this.writeLock.isHeldByCurrentThread());
        Map<CapabilityId, Map<String, RuntimeRequirementRegistration>> requirementMap = optional ? this.runtimeOnlyRequirements : this.requirements;
        Map<String, RuntimeRequirementRegistration> dependents = requirementMap.get(requirementRegistration.getDependentId());
        if (dependents != null && (rrr = dependents.get(requirementRegistration.getRequiredName())) != null) {
            rrr.removeRegistrationPoint(requirementRegistration.getOldestRegistrationPoint());
            if (rrr.getRegistrationPointCount() == 0) {
                dependents.remove(requirementRegistration.getRequiredName());
            }
            if (dependents.size() == 0) {
                requirementMap.remove(requirementRegistration.getDependentId());
            }
            this.modified = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<CapabilityId, RuntimeCapabilityRegistry.RuntimeStatus> getRuntimeStatus(PathAddress address, ImmutableManagementResourceRegistration resourceRegistration) {
        this.readLock.lock();
        try {
            Map<CapabilityId, RuntimeCapabilityRegistry.RuntimeStatus> result;
            Set<CapabilityId> ids = this.getCapabilitiesForAddress(address, resourceRegistration);
            int size = ids.size();
            if (size == 0) {
                result = Collections.emptyMap();
            } else {
                HashSet<CapabilityId> examined = new HashSet<CapabilityId>();
                if (size == 1) {
                    CapabilityId id = ids.iterator().next();
                    result = Collections.singletonMap(id, this.getCapabilityStatus(id, examined));
                } else {
                    result = new HashMap<CapabilityId, RuntimeCapabilityRegistry.RuntimeStatus>(size);
                    for (CapabilityId id : ids) {
                        result.put(id, this.getCapabilityStatus(id, examined));
                    }
                }
            }
            Map<CapabilityId, RuntimeCapabilityRegistry.RuntimeStatus> map = result;
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private RuntimeCapabilityRegistry.RuntimeStatus getCapabilityStatus(CapabilityId id, Set<CapabilityId> examined) {
        assert (id.getScope().equals(CapabilityScope.GLOBAL) || id.getScope().getName().equals("host"));
        if (this.restartCapabilities.contains(id)) {
            return RuntimeCapabilityRegistry.RuntimeStatus.RESTART_REQUIRED;
        }
        if (this.reloadCapabilities.contains(id)) {
            return RuntimeCapabilityRegistry.RuntimeStatus.RELOAD_REQUIRED;
        }
        examined.add(id);
        Map<String, RuntimeRequirementRegistration> dependents = this.requirements.get(id);
        return this.getDependentCapabilityStatus(dependents, id, examined);
    }

    private RuntimeCapabilityRegistry.RuntimeStatus getDependentCapabilityStatus(Map<String, RuntimeRequirementRegistration> dependents, CapabilityId requiror, Set<CapabilityId> examined) {
        RuntimeCapabilityRegistry.RuntimeStatus result = RuntimeCapabilityRegistry.RuntimeStatus.NORMAL;
        if (dependents != null) {
            for (String dependent : dependents.keySet()) {
                CapabilityScope requirorScope = requiror.getScope();
                List<CapabilityScope> toCheck = requirorScope == CapabilityScope.GLOBAL ? Collections.singletonList(requirorScope) : Arrays.asList(requirorScope, CapabilityScope.GLOBAL);
                for (CapabilityScope scope : toCheck) {
                    CapabilityId dependentId = new CapabilityId(dependent, scope);
                    if (examined.contains(dependentId)) continue;
                    RuntimeCapabilityRegistry.RuntimeStatus status = this.getCapabilityStatus(dependentId, examined);
                    if (status == RuntimeCapabilityRegistry.RuntimeStatus.RESTART_REQUIRED) {
                        return status;
                    }
                    if (status != RuntimeCapabilityRegistry.RuntimeStatus.RELOAD_REQUIRED) continue;
                    result = status;
                }
            }
        }
        return result;
    }

    @Override
    public void capabilityReloadRequired(PathAddress address, ImmutableManagementResourceRegistration resourceRegistration) {
        this.writeLock.lock();
        try {
            this.reloadCapabilities.addAll(this.getCapabilitiesForAddress(address, resourceRegistration));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void capabilityRestartRequired(PathAddress address, ImmutableManagementResourceRegistration resourceRegistration) {
        this.writeLock.lock();
        try {
            this.restartCapabilities.addAll(this.getCapabilitiesForAddress(address, resourceRegistration));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Set<CapabilityId> getCapabilitiesForAddress(PathAddress address, ImmutableManagementResourceRegistration resourceRegistration) {
        Set result = null;
        PathAddress curAddress = address;
        ImmutableManagementResourceRegistration curReg = resourceRegistration;
        while (result == null) {
            Set<RuntimeCapability> incorporating = curReg.getIncorporatingCapabilities();
            HashSet<String> incorporatingDynamic = null;
            HashSet<String> incorporatingFull = null;
            if (incorporating != null && !incorporating.isEmpty()) {
                for (RuntimeCapability runtimeCapability : incorporating) {
                    if (runtimeCapability.isDynamicallyNamed()) {
                        if (incorporatingDynamic == null) {
                            incorporatingDynamic = new HashSet<String>();
                        }
                        incorporatingDynamic.add(runtimeCapability.getName());
                        continue;
                    }
                    if (incorporatingFull == null) {
                        incorporatingFull = new HashSet<String>();
                    }
                    incorporatingFull.add(runtimeCapability.getName());
                }
            }
            block2: for (Map.Entry entry : this.capabilities.entrySet()) {
                String name;
                int lastDot;
                boolean checkIncorporating = false;
                if (incorporatingFull != null) {
                    checkIncorporating = incorporatingFull.contains(((CapabilityId)entry.getKey()).getName());
                }
                if (!checkIncorporating && incorporatingDynamic != null && (lastDot = (name = ((CapabilityId)entry.getKey()).getName()).lastIndexOf(46)) > 0) {
                    String baseName = name.substring(0, lastDot);
                    checkIncorporating = incorporatingDynamic.contains(baseName);
                }
                for (RegistrationPoint point : ((RuntimeCapabilityRegistration)entry.getValue()).getRegistrationPoints()) {
                    PathAddress pointAddress = point.getAddress();
                    if (!curAddress.equals(pointAddress) && (!checkIncorporating || curAddress.size() <= pointAddress.size() || !pointAddress.equals(curAddress.subAddress(0, pointAddress.size())))) continue;
                    if (result == null) {
                        result = new HashSet();
                    }
                    result.add(entry.getKey());
                    continue block2;
                }
            }
            if (result == null && incorporating != null) {
                result = Collections.emptySet();
            }
            if (result != null) continue;
            int addrSize = curAddress.size();
            if (!(addrSize <= 1 || "subsystem".equals(curAddress.getLastElement().getKey()) || addrSize == 2 && "host".equals(curAddress.getElement(0).getKey()))) {
                curAddress = curAddress.getParent();
                curReg = curReg.getParent();
                continue;
            }
            result = Collections.emptySet();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerPossibleCapability(Capability capability, PathAddress registrationPoint) {
        CapabilityId capabilityId = new CapabilityId(capability.getName(), CapabilityScope.GLOBAL);
        RegistrationPoint point = new RegistrationPoint(registrationPoint, null);
        CapabilityRegistration<Capability> capabilityRegistration = new CapabilityRegistration<Capability>(capability, CapabilityScope.GLOBAL, point);
        this.writeLock.lock();
        try {
            this.possibleCapabilities.computeIfPresent(capabilityId, (capabilityId1, currentRegistration) -> {
                RegistrationPoint rp = capabilityRegistration.getOldestRegistrationPoint();
                if (!Objects.equals(capabilityRegistration.getCapability(), currentRegistration.getCapability()) || !currentRegistration.addRegistrationPoint(rp)) {
                    throw ControllerLogger.MGMT_OP_LOGGER.capabilityAlreadyRegisteredInContext(capabilityId.getName(), capabilityId.getScope().getName());
                }
                return capabilityRegistration;
            });
            this.possibleCapabilities.putIfAbsent(capabilityId, capabilityRegistration);
            this.modified = true;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CapabilityRegistration removePossibleCapability(Capability capability, PathAddress registrationPoint) {
        CapabilityId capabilityId = new CapabilityId(capability.getName(), CapabilityScope.GLOBAL);
        CapabilityRegistration removed = null;
        this.writeLock.lock();
        try {
            RegistrationPoint rp;
            CapabilityRegistration candidate = this.possibleCapabilities.get(capabilityId);
            if (candidate != null && candidate.removeRegistrationPoint(rp = new RegistrationPoint(registrationPoint, null))) {
                removed = candidate.getRegistrationPointCount() == 0 ? this.possibleCapabilities.remove(capabilityId) : candidate;
            }
            if (removed != null) {
                this.modified = true;
            }
            CapabilityRegistration capabilityRegistration = removed;
            return capabilityRegistration;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasCapability(String capabilityName, CapabilityScope scope) {
        this.readLock.lock();
        try {
            boolean bl = this.findSatisfactoryCapability(capabilityName, scope, !this.forServer) != null;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getCapabilityRuntimeAPI(String capabilityName, CapabilityScope scope, Class<T> apiType) {
        assert (this.resolutionContext.resolutionComplete);
        this.readLock.lock();
        try {
            RuntimeCapabilityRegistration reg = this.getCapabilityRegistration(capabilityName, scope);
            Object api = ((RuntimeCapability)reg.getCapability()).getRuntimeAPI();
            if (api == null) {
                throw ControllerLogger.MGMT_OP_LOGGER.capabilityDoesNotExposeRuntimeAPI(capabilityName);
            }
            T t = apiType.cast(api);
            return t;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Set<CapabilityRegistration> getCapabilities() {
        this.readLock.lock();
        try {
            Set<CapabilityRegistration> set = Collections.unmodifiableSet(new TreeSet<RuntimeCapabilityRegistration>(this.capabilities.values()));
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Set<CapabilityRegistration> getPossibleCapabilities() {
        this.readLock.lock();
        try {
            Set<CapabilityRegistration> set = Collections.unmodifiableSet(new TreeSet<CapabilityRegistration>(this.possibleCapabilities.values()));
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceName getCapabilityServiceName(String capabilityName, CapabilityScope scope, Class<?> serviceType) {
        assert (this.resolutionContext.resolutionComplete);
        this.readLock.lock();
        try {
            RuntimeCapabilityRegistration reg = this.getCapabilityRegistration(capabilityName, scope);
            RuntimeCapability cap = (RuntimeCapability)reg.getCapability();
            ServiceName serviceName = cap.getCapabilityServiceName(serviceType);
            return serviceName;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<PathAddress> getPossibleProviderPoints(CapabilityId capabilityId) {
        LinkedHashSet<PathAddress> result = new LinkedHashSet<PathAddress>();
        this.readLock.lock();
        try {
            capabilityId = capabilityId.getScope() == CapabilityScope.GLOBAL ? capabilityId : new CapabilityId(capabilityId.getName(), CapabilityScope.GLOBAL);
            CapabilityRegistration reg = this.possibleCapabilities.get(capabilityId);
            if (reg != null) {
                result.addAll(reg.getRegistrationPoints().stream().map(RegistrationPoint::getAddress).collect(Collectors.toList()));
            }
        }
        finally {
            this.readLock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CapabilityRegistration getCapability(CapabilityId capabilityId) {
        this.readLock.lock();
        try {
            CapabilityRegistration reg = this.capabilities.get(capabilityId);
            CapabilityRegistration capabilityRegistration = reg != null ? new CapabilityRegistration(reg) : null;
            return capabilityRegistration;
        }
        finally {
            this.readLock.unlock();
        }
    }

    void publish() {
        assert (this.publishedFullRegistry != null) : "Cannot write directly to main registry";
        this.writeLock.lock();
        try {
            if (!this.modified) {
                return;
            }
            this.publishedFullRegistry.writeLock.lock();
            try {
                this.publishedFullRegistry.clear(true);
                this.copy(this, this.publishedFullRegistry);
                this.modified = false;
            }
            finally {
                this.publishedFullRegistry.writeLock.unlock();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void rollback() {
        if (this.publishedFullRegistry == null) {
            return;
        }
        this.writeLock.lock();
        try {
            this.publishedFullRegistry.readLock.lock();
            try {
                this.clear(true);
                this.copy(this.publishedFullRegistry, this);
                this.modified = false;
            }
            finally {
                this.publishedFullRegistry.readLock.unlock();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    boolean isModified() {
        this.readLock.lock();
        try {
            boolean bl = this.modified;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void copy(CapabilityRegistry source, CapabilityRegistry target) {
        assert (target.writeLock.isHeldByCurrentThread());
        CapabilityRegistry.copyCapabilities(source.capabilities, target.capabilities);
        source.possibleCapabilities.entrySet().stream().forEach(entry -> target.possibleCapabilities.put((CapabilityId)entry.getKey(), new CapabilityRegistration((CapabilityRegistration)entry.getValue())));
        CapabilityRegistry.copyRequirements(source.requirements, target.requirements);
        CapabilityRegistry.copyRequirements(source.runtimeOnlyRequirements, target.runtimeOnlyRequirements);
        target.reloadCapabilities.addAll(source.reloadCapabilities);
        target.restartCapabilities.addAll(source.restartCapabilities);
        if (!this.forServer) {
            target.knownContexts.addAll(source.knownContexts);
        }
    }

    void clear() {
        this.clear(false);
    }

    private void clear(boolean restartRequired) {
        this.writeLock.lock();
        try {
            this.capabilities.clear();
            this.possibleCapabilities.clear();
            this.requirements.clear();
            this.runtimeOnlyRequirements.clear();
            this.reloadCapabilities.clear();
            if (restartRequired) {
                this.restartCapabilities.clear();
            }
            this.modified = true;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CapabilityValidation resolveCapabilities(Resource rootResource, boolean hostXmlOnly) {
        this.readLock.lock();
        try {
            Object object;
            this.resolutionContext.setRootResource(rootResource);
            assert (this.resolutionContext.rootResource != null);
            HashMap<CapabilityId, HashSet<RuntimeRequirementRegistration>> missing = new HashMap<CapabilityId, HashSet<RuntimeRequirementRegistration>>();
            boolean isInconsistent = false;
            HashMap<CapabilityScope, Set<RuntimeRequirementRegistration>> requiresConsistency = null;
            HashMap<CapabilityScope, Set<CapabilityScope>> consistentSets = null;
            for (Map.Entry<CapabilityId, Map<String, RuntimeRequirementRegistration>> entry : this.requirements.entrySet()) {
                CapabilityId dependentId = entry.getKey();
                String dependentName = dependentId.getName();
                CapabilityScope dependentContext = dependentId.getScope();
                Set consistentSet = consistentSets == null ? null : (Set)consistentSets.get(dependentContext);
                for (RuntimeRequirementRegistration req : entry.getValue().values()) {
                    SatisfactoryCapability satisfactory = this.findSatisfactoryCapability(req.getRequiredName(), dependentContext, !this.forServer);
                    if (satisfactory == null) {
                        if (hostXmlOnly && dependentName.startsWith("org.wildfly.domain.server-config.") && (req.getRequiredName().startsWith("org.wildfly.domain.server-group.") || req.getRequiredName().startsWith("org.wildfly.domain.socket-binding-group."))) {
                            ControllerLogger.MGMT_OP_LOGGER.tracef("Ignoring that dependent %s cannot resolve required capability %s as the 'hostXmlOnly' param is set", dependentId, req.getRequiredName());
                            continue;
                        }
                        CapabilityId basicId = new CapabilityId(req.getRequiredName(), dependentContext);
                        HashSet<RuntimeRequirementRegistration> set = (HashSet<RuntimeRequirementRegistration>)missing.get(basicId);
                        if (set == null) {
                            set = new HashSet<RuntimeRequirementRegistration>();
                            missing.put(basicId, set);
                        }
                        set.add(req);
                        continue;
                    }
                    if (satisfactory.multipleCapabilities == null) continue;
                    if (requiresConsistency == null) {
                        requiresConsistency = new HashMap<CapabilityScope, Set<RuntimeRequirementRegistration>>();
                        consistentSets = new HashMap<CapabilityScope, Set<CapabilityScope>>();
                    }
                    CapabilityScope reqDependent = req.getDependentContext();
                    this.recordConsistentSets(requiresConsistency, consistentSets, reqDependent, consistentSet, req, satisfactory, reqDependent);
                    isInconsistent = isInconsistent || consistentSet != null && consistentSet.size() == 0;
                    for (CapabilityScope including : dependentContext.getIncludingScopes(this.resolutionContext)) {
                        consistentSet = (Set)consistentSets.get(including);
                        this.recordConsistentSets(requiresConsistency, consistentSets, including, consistentSet, req, satisfactory, reqDependent);
                        isInconsistent = isInconsistent || consistentSet != null && consistentSet.size() == 0;
                    }
                }
            }
            this.resolutionContext.resolutionComplete = true;
            if (isInconsistent) {
                object = new CapabilityValidation(missing, CapabilityRegistry.findInconsistent(requiresConsistency, consistentSets), this.resolutionContext);
                return object;
            }
            if (!missing.isEmpty()) {
                object = new CapabilityValidation(missing, null, this.resolutionContext);
                return object;
            }
            object = CapabilityValidation.OK;
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void recordConsistentSets(Map<CapabilityScope, Set<RuntimeRequirementRegistration>> requiresConsistency, Map<CapabilityScope, Set<CapabilityScope>> consistentSets, CapabilityScope dependentContext, Set<CapabilityScope> consistentSet, RuntimeRequirementRegistration req, SatisfactoryCapability satisfactory, CapabilityScope reqDependent) {
        Set<RuntimeRequirementRegistration> requiresForDependent = requiresConsistency.get(reqDependent);
        if (requiresForDependent == null) {
            requiresForDependent = new HashSet<RuntimeRequirementRegistration>();
            requiresConsistency.put(reqDependent, requiresForDependent);
        }
        requiresForDependent.add(req);
        if (consistentSet == null) {
            consistentSet = new HashSet<CapabilityScope>(satisfactory.multipleCapabilities);
            consistentSets.put(dependentContext, consistentSet);
        } else {
            consistentSet.retainAll(satisfactory.multipleCapabilities);
        }
    }

    private static Set<RuntimeRequirementRegistration> findInconsistent(Map<CapabilityScope, Set<RuntimeRequirementRegistration>> requiresConsistency, Map<CapabilityScope, Set<CapabilityScope>> consistentSets) {
        HashSet<RuntimeRequirementRegistration> result = new HashSet<RuntimeRequirementRegistration>();
        for (Map.Entry<CapabilityScope, Set<CapabilityScope>> entry : consistentSets.entrySet()) {
            Set<RuntimeRequirementRegistration> contextDependents;
            if (!entry.getValue().isEmpty() || (contextDependents = requiresConsistency.get(entry.getKey())) == null) continue;
            result.addAll(contextDependents);
        }
        return result;
    }

    private RuntimeCapabilityRegistration getCapabilityRegistration(String capabilityName, CapabilityScope capabilityScope) {
        SatisfactoryCapability satisfactoryCapability = this.findSatisfactoryCapability(capabilityName, capabilityScope, false);
        if (satisfactoryCapability == null) {
            if (this.forServer) {
                throw ControllerLogger.MGMT_OP_LOGGER.unknownCapability(capabilityName);
            }
            throw ControllerLogger.MGMT_OP_LOGGER.unknownCapabilityInContext(capabilityName, capabilityScope.getName());
        }
        return this.capabilities.get(satisfactoryCapability.singleCapability);
    }

    private SatisfactoryCapability findSatisfactoryCapability(String capabilityName, CapabilityScope dependentContext, boolean requireConsistency) {
        CapabilityId requestedId = new CapabilityId(capabilityName, dependentContext);
        if (this.capabilities.containsKey(requestedId)) {
            return new SatisfactoryCapability(requestedId);
        }
        if (!this.forServer) {
            HashSet<CapabilityScope> multiple = null;
            for (CapabilityScope satisfies : this.knownContexts) {
                CapabilityId satisfiesId;
                if (satisfies.equals(dependentContext) || !this.capabilities.containsKey(satisfiesId = new CapabilityId(capabilityName, satisfies)) || !satisfies.canSatisfyRequirement(capabilityName, dependentContext, this.resolutionContext)) continue;
                if (!requireConsistency || !satisfies.requiresConsistencyCheck()) {
                    return new SatisfactoryCapability(satisfiesId);
                }
                if (multiple == null) {
                    multiple = new HashSet<CapabilityScope>();
                }
                multiple.add(satisfies);
                multiple.addAll(satisfies.getIncludingScopes(this.resolutionContext));
            }
            if (multiple != null) {
                return new SatisfactoryCapability(multiple);
            }
        }
        return null;
    }

    static class CapabilityValidation {
        public static final CapabilityValidation OK = new CapabilityValidation(null, null, null);
        private final Map<CapabilityId, Set<RuntimeRequirementRegistration>> missingRequirements;
        private final Set<RuntimeRequirementRegistration> inconsistentRequirements;
        private final CapabilityResolutionContext resolutionContext;

        private CapabilityValidation(Map<CapabilityId, Set<RuntimeRequirementRegistration>> missingRequirements, Set<RuntimeRequirementRegistration> inconsistentRequirements, CapabilityResolutionContext resolutionContext) {
            this.resolutionContext = resolutionContext;
            this.missingRequirements = missingRequirements == null ? Collections.emptyMap() : missingRequirements;
            this.inconsistentRequirements = inconsistentRequirements == null ? Collections.emptySet() : inconsistentRequirements;
        }

        public Map<CapabilityId, Set<RuntimeRequirementRegistration>> getMissingRequirements() {
            return this.missingRequirements;
        }

        public Set<RuntimeRequirementRegistration> getInconsistentRequirements() {
            return this.inconsistentRequirements;
        }

        public CapabilityResolutionContext getCapabilityResolutionContext() {
            return this.resolutionContext;
        }

        public boolean isValid() {
            return this.missingRequirements.isEmpty() && this.inconsistentRequirements.isEmpty();
        }
    }

    private static class SatisfactoryCapability {
        final CapabilityId singleCapability;
        final Set<CapabilityScope> multipleCapabilities;

        SatisfactoryCapability(CapabilityId singleCapability) {
            this.singleCapability = singleCapability;
            this.multipleCapabilities = null;
        }

        SatisfactoryCapability(Set<CapabilityScope> multipleCapabilities) {
            this.singleCapability = null;
            this.multipleCapabilities = multipleCapabilities;
        }
    }

    private static class ResolutionContextImpl
    extends CapabilityResolutionContext {
        private boolean resolutionComplete;
        private Resource rootResource;

        private ResolutionContextImpl() {
        }

        @Override
        public Resource getResourceRoot() {
            assert (this.rootResource != null);
            return this.rootResource;
        }

        void setRootResource(Resource rootResource) {
            this.rootResource = rootResource;
            this.reset();
            this.resolutionComplete = false;
        }
    }
}

