/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.DefaultAttributeMarshaller;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDescriptionProviderUtil;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.BytesValidator;
import org.jboss.as.controller.operations.validation.MinMaxValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.NillableOrExpressionParameterValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public abstract class AttributeDefinition {
    protected static final Set<ModelType> COMPLEX_TYPES = Collections.unmodifiableSet(EnumSet.of(ModelType.LIST, ModelType.OBJECT, ModelType.PROPERTY));
    private final String name;
    private final String xmlName;
    private final ModelType type;
    private final boolean allowNull;
    private final boolean allowExpression;
    private final ModelNode defaultValue;
    private final MeasurementUnit measurementUnit;
    private final String[] alternatives;
    private final String[] requires;
    private final ModelNode[] allowedValues;
    private final ParameterCorrector valueCorrector;
    private final ParameterValidator validator;
    private final boolean validateNull;
    private final EnumSet<AttributeAccess.Flag> flags;
    protected final AttributeMarshaller attributeMarshaller;
    private final boolean resourceOnly;
    private final DeprecationData deprecationData;
    private final List<AccessConstraintDefinition> accessConstraints;
    private final Boolean nilSignificant;
    private final AttributeParser parser;
    private final String attributeGroup;
    private final ModelNode undefinedMetricValue;
    protected final CapabilityReferenceRecorder referenceRecorder;
    private final Map<String, ModelNode> arbitraryDescriptors = new HashMap<String, ModelNode>();

    protected AttributeDefinition(AbstractAttributeDefinitionBuilder<?, ?> toCopy) {
        this(toCopy.getName(), toCopy.getXmlName(), toCopy.getDefaultValue(), toCopy.getType(), toCopy.isAllowNull(), toCopy.isAllowExpression(), toCopy.getMeasurementUnit(), toCopy.getCorrector(), AttributeDefinition.wrapValidator(toCopy.getValidator(), toCopy.isAllowNull(), toCopy.isValidateNull(), toCopy.isAllowExpression(), toCopy.getType(), toCopy.getConfiguredMinSize(), toCopy.getConfiguredMaxSize()), toCopy.isValidateNull(), toCopy.getAlternatives(), toCopy.getRequires(), toCopy.getAttributeMarshaller(), toCopy.isResourceOnly(), toCopy.getDeprecated(), AttributeDefinition.wrapConstraints(toCopy.getAccessConstraints()), toCopy.getNullSignificant(), toCopy.getParser(), toCopy.getAttributeGroup(), toCopy.referenceRecorder, toCopy.getAllowedValues(), toCopy.getArbitraryDescriptors(), toCopy.getUndefinedMetricValue(), AttributeDefinition.wrapFlags(toCopy.getFlags()));
    }

    protected AttributeDefinition(String name, String xmlName, ModelNode defaultValue, ModelType type, boolean allowNull, boolean allowExpression, MeasurementUnit measurementUnit, ParameterCorrector valueCorrector, ParameterValidator validator, boolean validateNull, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecationData, AccessConstraintDefinition[] accessConstraints, Boolean nilSignificant, AttributeParser parser, AttributeAccess.Flag ... flags) {
        this(name, xmlName, defaultValue, type, allowNull, allowExpression, measurementUnit, valueCorrector, AttributeDefinition.wrapValidator(validator, allowNull, validateNull, allowExpression, type, null, null), validateNull, alternatives, requires, attributeMarshaller, resourceOnly, deprecationData, AttributeDefinition.wrapConstraints(accessConstraints), nilSignificant, parser, null, null, null, null, null, AttributeDefinition.wrapFlags(flags));
    }

    private AttributeDefinition(String name, String xmlName, ModelNode defaultValue, ModelType type, boolean allowNull, boolean allowExpression, MeasurementUnit measurementUnit, ParameterCorrector valueCorrector, ParameterValidator validator, boolean validateNull, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecationData, List<AccessConstraintDefinition> accessConstraints, Boolean nilSignificant, AttributeParser parser, String attributeGroup, CapabilityReferenceRecorder referenceRecorder, ModelNode[] allowedValues, Map<String, ModelNode> arbitraryDescriptors, ModelNode undefinedMetricValue, EnumSet<AttributeAccess.Flag> flags) {
        this.name = name;
        this.xmlName = xmlName == null ? name : xmlName;
        this.type = type;
        this.allowNull = allowNull;
        this.allowExpression = allowExpression;
        AttributeParser attributeParser = this.parser = parser != null ? parser : AttributeParser.SIMPLE;
        if (defaultValue != null && defaultValue.isDefined()) {
            this.defaultValue = defaultValue;
            this.defaultValue.protect();
        } else {
            this.defaultValue = null;
        }
        this.measurementUnit = measurementUnit;
        this.alternatives = alternatives;
        this.requires = requires;
        this.valueCorrector = valueCorrector;
        this.validator = validator;
        this.validateNull = validateNull;
        this.flags = flags;
        this.attributeMarshaller = attributeMarshaller != null ? attributeMarshaller : new DefaultAttributeMarshaller();
        this.resourceOnly = resourceOnly;
        this.accessConstraints = accessConstraints;
        this.deprecationData = deprecationData;
        this.nilSignificant = nilSignificant;
        this.attributeGroup = attributeGroup;
        this.allowedValues = allowedValues;
        if (undefinedMetricValue != null && undefinedMetricValue.isDefined()) {
            this.undefinedMetricValue = undefinedMetricValue;
            this.undefinedMetricValue.protect();
        } else {
            this.undefinedMetricValue = null;
        }
        this.referenceRecorder = referenceRecorder;
        if (arbitraryDescriptors != null && !arbitraryDescriptors.isEmpty()) {
            this.arbitraryDescriptors.putAll(arbitraryDescriptors);
        }
    }

    private static ParameterValidator wrapValidator(ParameterValidator toWrap, boolean allowNull, boolean validateNull, boolean allowExpression, ModelType type, Integer minSize, Integer maxSize) {
        NillableOrExpressionParameterValidator result = null;
        if (toWrap == null) {
            if (type == ModelType.STRING) {
                int min = minSize == null ? 1 : minSize;
                int max = maxSize == null ? Integer.MAX_VALUE : maxSize;
                toWrap = new StringLengthValidator(min, max, allowNull, allowExpression);
            } else if (type == ModelType.BYTES) {
                int min = minSize == null ? 0 : minSize;
                int max = maxSize == null ? Integer.MAX_VALUE : maxSize;
                toWrap = new BytesValidator(min, max, false);
            } else {
                toWrap = new ModelTypeValidator(type);
            }
        } else if (toWrap instanceof NillableOrExpressionParameterValidator) {
            NillableOrExpressionParameterValidator current = (NillableOrExpressionParameterValidator)toWrap;
            if (allowExpression == current.isAllowExpression() && (!validateNull && current.getAllowNull() == null || allowNull == current.getAllowNull())) {
                result = current;
            } else {
                toWrap = current.getDelegate();
            }
        }
        if (result == null) {
            Boolean nullCheck = validateNull ? Boolean.valueOf(allowNull) : null;
            result = new NillableOrExpressionParameterValidator(toWrap, nullCheck, allowExpression);
        }
        return result;
    }

    private static List<AccessConstraintDefinition> wrapConstraints(AccessConstraintDefinition[] accessConstraints) {
        if (accessConstraints == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(accessConstraints));
    }

    private static EnumSet<AttributeAccess.Flag> wrapFlags(AttributeAccess.Flag[] flags) {
        if (flags == null || flags.length == 0) {
            return EnumSet.noneOf(AttributeAccess.Flag.class);
        }
        if (flags.length == 1) {
            return EnumSet.of(flags[0]);
        }
        return EnumSet.of(flags[0], flags);
    }

    public String getName() {
        return this.name;
    }

    public String getXmlName() {
        return this.xmlName;
    }

    public ModelType getType() {
        return this.type;
    }

    public boolean isAllowNull() {
        return this.allowNull;
    }

    public boolean isNullSignificant() {
        if (this.nilSignificant != null) {
            return this.nilSignificant;
        }
        return this.allowNull && this.defaultValue != null && this.defaultValue.isDefined();
    }

    Boolean getNilSignificant() {
        return this.nilSignificant;
    }

    public boolean isAllowExpression() {
        return this.allowExpression;
    }

    public ModelNode getDefaultValue() {
        return this.defaultValue;
    }

    public String getAttributeGroup() {
        return this.attributeGroup;
    }

    public MeasurementUnit getMeasurementUnit() {
        return this.measurementUnit;
    }

    public ParameterCorrector getCorrector() {
        return this.valueCorrector;
    }

    public ParameterValidator getValidator() {
        return this.validator;
    }

    public boolean isValidatingNull() {
        return this.validateNull;
    }

    public String[] getAlternatives() {
        return this.alternatives;
    }

    public String[] getRequires() {
        return this.requires;
    }

    public EnumSet<AttributeAccess.Flag> getFlags() {
        return EnumSet.copyOf(this.flags);
    }

    public List<ModelNode> getAllowedValues() {
        if (this.allowedValues == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.allowedValues);
    }

    public Map<String, ModelNode> getArbitraryDescriptors() {
        return Collections.unmodifiableMap(this.arbitraryDescriptors);
    }

    public boolean isMarshallable(ModelNode resourceModel) {
        return this.attributeMarshaller.isMarshallable(this, resourceModel, true);
    }

    public boolean isMarshallable(ModelNode resourceModel, boolean marshallDefault) {
        return this.attributeMarshaller.isMarshallable(this, resourceModel, marshallDefault);
    }

    public ModelNode validateOperation(ModelNode operationObject) throws OperationFailedException {
        return this.validateOperation(operationObject, false);
    }

    public final void validateAndSet(ModelNode operationObject, ModelNode model) throws OperationFailedException {
        ModelNode newValue;
        ModelNode correctedValue;
        if (operationObject.hasDefined(this.name) && this.deprecationData != null && this.deprecationData.isNotificationUseful()) {
            ControllerLogger.DEPRECATED_LOGGER.attributeDeprecated(this.getName(), PathAddress.pathAddress(operationObject.get("address")).toCLIStyleString());
        }
        if (!(correctedValue = this.correctValue(newValue = this.convertParameterExpressions(operationObject.get(this.name)), model.get(this.name))).equals(operationObject.get(this.name))) {
            operationObject.get(this.name).set(correctedValue);
        }
        ModelNode node = this.validateOperation(operationObject, true);
        model.get(this.name).set(node);
    }

    private ModelNode convertToExpectedType(ModelNode node) {
        ModelType nodeType = node.getType();
        if (nodeType == this.type || nodeType == ModelType.UNDEFINED || nodeType == ModelType.EXPRESSION || Util.isExpression(node.asString())) {
            return node;
        }
        switch (this.type) {
            case BIG_DECIMAL: {
                return new ModelNode(node.asBigDecimal());
            }
            case BIG_INTEGER: {
                return new ModelNode(node.asBigInteger());
            }
            case BOOLEAN: {
                return new ModelNode(node.asBoolean());
            }
            case BYTES: {
                return new ModelNode(node.asBytes());
            }
            case DOUBLE: {
                return new ModelNode(node.asDouble());
            }
            case INT: {
                return new ModelNode(node.asInt());
            }
            case LIST: {
                return new ModelNode().set((Collection)node.asList());
            }
            case LONG: {
                return new ModelNode(node.asLong());
            }
            case PROPERTY: {
                return new ModelNode().set(node.asProperty());
            }
            case TYPE: {
                return new ModelNode(node.asType());
            }
            case STRING: {
                return new ModelNode(node.asString());
            }
            case OBJECT: {
                if (nodeType == ModelType.LIST) {
                    List propertyList;
                    if (node.asInt() == 0) {
                        return new ModelNode().setEmptyObject();
                    }
                    ModelNode first = node.get(0);
                    if (first.getType() != ModelType.PROPERTY) {
                        return node;
                    }
                    try {
                        propertyList = node.asPropertyList();
                    }
                    catch (IllegalArgumentException iae) {
                        return node;
                    }
                    ModelNode result = new ModelNode().setEmptyObject();
                    for (Property prop : propertyList) {
                        result.get(prop.getName()).set(prop.getValue());
                    }
                    return result;
                }
                return node;
            }
        }
        return node;
    }

    public ModelNode resolveModelAttribute(final OperationContext context, ModelNode model) throws OperationFailedException {
        return this.resolveModelAttribute(new ExpressionResolver(){

            @Override
            public ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
                return context.resolveExpressions(node);
            }
        }, model);
    }

    public ModelNode resolveModelAttribute(ExpressionResolver resolver, ModelNode model) throws OperationFailedException {
        ModelNode node = new ModelNode();
        if (model.has(this.name)) {
            node.set(model.get(this.name));
        }
        return this.resolveValue(resolver, node);
    }

    public ModelNode resolveValue(final OperationContext context, ModelNode value) throws OperationFailedException {
        return this.resolveValue(new ExpressionResolver(){

            @Override
            public ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
                return context.resolveExpressions(node);
            }
        }, value);
    }

    public ModelNode resolveValue(ExpressionResolver resolver, ModelNode value) throws OperationFailedException {
        ModelNode node = value.clone();
        if (!node.isDefined() && this.defaultValue != null && this.defaultValue.isDefined()) {
            node.set(this.defaultValue);
        }
        ModelNode resolved = resolver.resolveExpressions(node);
        this.validator.validateParameter(this.name, resolved);
        return resolved;
    }

    public boolean isAllowed(ModelNode operationObject) {
        if (this.alternatives != null) {
            for (String alternative : this.alternatives) {
                if (!operationObject.hasDefined(alternative)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isRequired(ModelNode operationObject) {
        return !this.allowNull && !this.hasAlternative(operationObject);
    }

    public boolean hasAlternative(ModelNode operationObject) {
        if (this.alternatives != null) {
            for (String alternative : this.alternatives) {
                if (!operationObject.hasDefined(alternative)) continue;
                return true;
            }
        }
        return false;
    }

    public void marshallAsElement(ModelNode resourceModel, XMLStreamWriter writer) throws XMLStreamException {
        this.marshallAsElement(resourceModel, true, writer);
    }

    public void marshallAsElement(ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
        if (!this.attributeMarshaller.isMarshallableAsElement()) {
            throw ControllerLogger.ROOT_LOGGER.couldNotMarshalAttributeAsElement(this.getName());
        }
        this.attributeMarshaller.marshallAsElement(this, resourceModel, marshallDefault, writer);
    }

    public ModelNode addResourceAttributeDescription(ResourceBundle bundle, String prefix, ModelNode resourceDescription) {
        ModelNode attr = this.getNoTextDescription(false);
        attr.get("description").set(this.getAttributeTextDescription(bundle, prefix));
        ModelNode result = resourceDescription.get(new String[]{"attributes", this.getName()}).set(attr);
        ModelNode deprecated = this.addDeprecatedInfo(result);
        if (deprecated != null) {
            deprecated.get("reason").set(this.getAttributeDeprecatedDescription(bundle, prefix));
        }
        this.addAccessConstraints(result, bundle.getLocale());
        return result;
    }

    public ModelNode addResourceAttributeDescription(ModelNode resourceDescription, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        ModelNode attr = this.getNoTextDescription(false);
        String description = resolver.getResourceAttributeDescription(this.getName(), locale, bundle);
        attr.get("description").set(description);
        ModelNode result = resourceDescription.get(new String[]{"attributes", this.getName()}).set(attr);
        ModelNode deprecated = this.addDeprecatedInfo(result);
        if (deprecated != null) {
            deprecated.get("reason").set(resolver.getResourceAttributeDeprecatedDescription(this.getName(), locale, bundle));
        }
        this.addAccessConstraints(result, locale);
        return result;
    }

    public ModelNode addOperationParameterDescription(ResourceBundle bundle, String prefix, ModelNode operationDescription) {
        ModelNode param = this.getNoTextDescription(true);
        param.get("description").set(this.getAttributeTextDescription(bundle, prefix));
        ModelNode result = operationDescription.get(new String[]{"request-properties", this.getName()}).set(param);
        ModelNode deprecated = this.addDeprecatedInfo(result);
        if (deprecated != null) {
            deprecated.get("reason").set(this.getAttributeDeprecatedDescription(bundle, prefix));
        }
        return result;
    }

    public ModelNode addOperationParameterDescription(ModelNode resourceDescription, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        ModelNode param = this.getNoTextDescription(true);
        String description = resolver.getOperationParameterDescription(operationName, this.getName(), locale, bundle);
        param.get("description").set(description);
        ModelNode result = resourceDescription.get(new String[]{"request-properties", this.getName()}).set(param);
        ModelNode deprecated = this.addDeprecatedInfo(result);
        if (deprecated != null) {
            deprecated.get("reason").set(resolver.getOperationParameterDeprecatedDescription(operationName, this.getName(), locale, bundle));
        }
        return result;
    }

    public ModelNode addOperationReplyDescription(ResourceBundle bundle, String prefix, ModelNode operationDescription) {
        ModelNode param = this.getNoTextDescription(true);
        param.get("description").set(this.getAttributeTextDescription(bundle, prefix));
        ModelNode result = operationDescription.get(new String[]{"reply-properties", this.getName()}).set(param);
        ModelNode deprecated = this.addDeprecatedInfo(result);
        if (deprecated != null) {
            deprecated.get("reason").set(this.getAttributeDeprecatedDescription(bundle, prefix));
        }
        return result;
    }

    public ModelNode addOperationReplyDescription(ModelNode resourceDescription, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        ModelNode param = this.getNoTextDescription(true);
        String description = resolver.getOperationReplyValueTypeDescription(operationName, locale, bundle, this.getName());
        param.get("description").set(description);
        ModelNode result = resourceDescription.get(new String[]{"reply-properties", this.getName()}).set(param);
        ModelNode deprecated = this.addDeprecatedInfo(result);
        if (deprecated != null) {
            deprecated.get("reason").set(resolver.getOperationParameterDeprecatedDescription(operationName, this.getName(), locale, bundle));
        }
        return result;
    }

    public String getAttributeTextDescription(ResourceBundle bundle, String prefix) {
        String bundleKey = prefix == null ? this.name : prefix + "." + this.name;
        return bundle.getString(bundleKey);
    }

    public String getAttributeDeprecatedDescription(ResourceBundle bundle, String prefix) {
        String bundleKey = prefix == null ? this.name : prefix + "." + this.name;
        bundleKey = bundleKey + ".deprecated";
        return bundle.getString(bundleKey);
    }

    public ModelNode addDeprecatedInfo(ModelNode model) {
        if (this.deprecationData == null) {
            return null;
        }
        ModelNode deprecated = model.get("deprecated");
        deprecated.get("since").set(this.deprecationData.getSince().toString());
        deprecated.get("reason");
        return deprecated;
    }

    public ModelNode getNoTextDescription(boolean forOperation) {
        ModelNode result = new ModelNode();
        result.get("type").set(this.type);
        result.get("description");
        if (this.attributeGroup != null && !forOperation) {
            result.get("attribute-group").set(this.attributeGroup);
        }
        result.get("expressions-allowed").set(this.isAllowExpression());
        if (forOperation) {
            result.get("required").set(!this.isAllowNull());
        }
        result.get("nillable").set(this.isAllowNull());
        if (!forOperation && this.nilSignificant != null && this.nilSignificant.booleanValue()) {
            result.get("nil-significant").set(true);
        }
        if (this.defaultValue != null && this.defaultValue.isDefined()) {
            result.get("default").set(this.defaultValue);
        }
        if (this.measurementUnit != null && this.measurementUnit != MeasurementUnit.NONE) {
            result.get("unit").set(this.measurementUnit.getName());
        }
        if (this.alternatives != null) {
            for (String alternative : this.alternatives) {
                result.get("alternatives").add(alternative);
            }
        }
        if (this.requires != null) {
            for (String required : this.requires) {
                result.get("requires").add(required);
            }
        }
        if (this.referenceRecorder != null) {
            result.get("capability-reference").set(this.referenceRecorder.getBaseRequirementName());
        }
        if (this.validator instanceof MinMaxValidator) {
            Long max;
            MinMaxValidator minMax = (MinMaxValidator)((Object)this.validator);
            Long min = minMax.getMin();
            if (min != null) {
                switch (this.type) {
                    case BYTES: 
                    case LIST: 
                    case STRING: 
                    case OBJECT: {
                        result.get("min-length").set(min.longValue());
                        break;
                    }
                    default: {
                        result.get("min").set(min.longValue());
                    }
                }
            }
            if ((max = minMax.getMax()) != null) {
                switch (this.type) {
                    case BYTES: 
                    case LIST: 
                    case STRING: 
                    case OBJECT: {
                        result.get("max-length").set(max.longValue());
                        break;
                    }
                    default: {
                        result.get("max").set(max.longValue());
                    }
                }
            }
        }
        this.addAllowedValuesToDescription(result, this.validator);
        this.arbitraryDescriptors.entrySet().stream().forEach(arbitraryDescriptor -> {
            assert (!result.hasDefined((String)arbitraryDescriptor.getKey()));
            result.get((String)arbitraryDescriptor.getKey()).set((ModelNode)arbitraryDescriptor.getValue());
        });
        return result;
    }

    public void addCapabilityRequirements(OperationContext context, ModelNode attributeValue) {
        if (this.referenceRecorder != null && attributeValue.getType() != ModelType.EXPRESSION) {
            ModelNode value = attributeValue.isDefined() ? attributeValue : (this.defaultValue != null ? this.defaultValue : new ModelNode());
            this.referenceRecorder.addCapabilityRequirements(context, this.name, value.isDefined() ? value.asString() : null);
        }
    }

    public void removeCapabilityRequirements(OperationContext context, ModelNode attributeValue) {
        if (this.referenceRecorder != null && attributeValue.getType() != ModelType.EXPRESSION) {
            ModelNode value = attributeValue.isDefined() ? attributeValue : (this.defaultValue != null ? this.defaultValue : new ModelNode());
            this.referenceRecorder.removeCapabilityRequirements(context, this.name, value.isDefined() ? value.asString() : null);
        }
    }

    public boolean hasCapabilityRequirements() {
        return this.getReferenceRecorder() != null;
    }

    protected CapabilityReferenceRecorder getReferenceRecorder() {
        return this.referenceRecorder;
    }

    protected void addAllowedValuesToDescription(ModelNode result, ParameterValidator validator) {
        block3: {
            AllowedValuesValidator avv;
            List<ModelNode> allowed;
            block2: {
                if (this.allowedValues == null) break block2;
                for (ModelNode allowedValue : this.allowedValues) {
                    result.get("allowed").add(allowedValue);
                }
                break block3;
            }
            if (!(validator instanceof AllowedValuesValidator) || (allowed = (avv = (AllowedValuesValidator)((Object)validator)).getAllowedValues()) == null) break block3;
            for (ModelNode ok : allowed) {
                result.get("allowed").add(ok);
            }
        }
    }

    protected final ModelNode correctValue(ModelNode newValue, ModelNode oldValue) {
        if (this.valueCorrector != null) {
            return this.valueCorrector.correct(newValue, oldValue);
        }
        return newValue;
    }

    protected ModelNode convertParameterExpressions(ModelNode parameter) {
        if (this.isAllowExpression() && COMPLEX_TYPES.contains(this.type)) {
            throw new IllegalStateException();
        }
        return this.isAllowExpression() ? AttributeDefinition.convertStringExpression(parameter) : parameter;
    }

    protected static ModelNode convertStringExpression(ModelNode node) {
        if (node.getType() == ModelType.STRING) {
            return ParseUtils.parsePossibleExpression(node.asString());
        }
        return node;
    }

    private ModelNode validateOperation(ModelNode operationObject, boolean immutableValue) throws OperationFailedException {
        ModelNode node = new ModelNode();
        if (operationObject.has(this.name)) {
            node.set(operationObject.get(this.name));
        }
        if (!immutableValue) {
            node = this.convertParameterExpressions(node);
            node = this.correctValue(node, node);
        }
        if (!node.isDefined() && this.defaultValue != null && this.defaultValue.isDefined()) {
            this.validator.validateParameter(this.name, this.defaultValue);
        } else {
            this.validator.validateParameter(this.name, node);
        }
        return this.convertToExpectedType(node);
    }

    public AttributeMarshaller getAttributeMarshaller() {
        return this.attributeMarshaller;
    }

    public boolean isResourceOnly() {
        return this.resourceOnly;
    }

    public boolean isDeprecated() {
        return this.deprecationData != null;
    }

    public DeprecationData getDeprecationData() {
        return this.deprecationData;
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }

    protected void addAccessConstraints(ModelNode result, Locale locale) {
        AccessConstraintDescriptionProviderUtil.addAccessConstraints(result, this.accessConstraints, locale);
    }

    public AttributeParser getParser() {
        return this.parser;
    }

    public ModelNode getUndefinedMetricValue() {
        return this.undefinedMetricValue;
    }

    public static final class NameAndGroup
    implements Comparable<NameAndGroup> {
        private final String name;
        private final String group;

        public NameAndGroup(AttributeDefinition ad) {
            this(ad.getName(), ad.getAttributeGroup());
        }

        public NameAndGroup(String name) {
            this.name = name;
            this.group = null;
        }

        public NameAndGroup(String name, String group) {
            this.name = name;
            this.group = group;
        }

        public String getName() {
            return this.name;
        }

        public String getGroup() {
            return this.group;
        }

        @Override
        public int compareTo(NameAndGroup o) {
            if (this.group == null) {
                if (o.group != null) {
                    return -1;
                }
            } else {
                if (o.group == null) {
                    return 1;
                }
                int groupComp = this.group.compareTo(o.group);
                if (groupComp != 0) {
                    return groupComp;
                }
            }
            return this.name.compareTo(o.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NameAndGroup that = (NameAndGroup)o;
            return Objects.equals(this.group, that.group) && this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
            return result;
        }
    }
}

