/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.AttributeMarshallers;
import org.jboss.as.controller.AttributeParsers;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.MapAttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public final class PropertiesAttributeDefinition
extends MapAttributeDefinition {
    final boolean wrapXmlElement;
    final String wrapperElement;

    private PropertiesAttributeDefinition(Builder builder) {
        super(builder);
        this.wrapXmlElement = builder.wrapXmlElement;
        this.wrapperElement = builder.wrapperElement;
    }

    @Override
    protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle) {
        this.setValueType(node);
    }

    @Override
    protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        this.setValueType(node);
    }

    @Override
    protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        this.setValueType(node);
    }

    void setValueType(ModelNode node) {
        node.get("value-type").set(ModelType.STRING);
        if (this.isAllowExpression()) {
            node.get("expressions-allowed").set(new ModelNode(true));
        }
    }

    public Map<String, String> unwrap(ExpressionResolver context, ModelNode model) throws OperationFailedException {
        ModelNode value = this.resolveModelAttribute(context, model);
        if (value.isDefined()) {
            return PropertiesAttributeDefinition.unwrapModel(context, value);
        }
        return Collections.emptyMap();
    }

    public static Map<String, String> unwrapModel(ExpressionResolver context, ModelNode model) throws OperationFailedException {
        if (!model.isDefined()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> props = new HashMap<String, String>();
        for (Property p : model.asPropertyList()) {
            ModelNode value = context.resolveExpressions(p.getValue());
            props.put(p.getName(), value.isDefined() ? value.asString() : null);
        }
        return props;
    }

    @Deprecated
    public void parse(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        String[] array = ParseUtils.requireAttributes(reader, Attribute.NAME.getLocalName(), Attribute.VALUE.getLocalName());
        this.parseAndAddParameterElement(array[0], array[1], operation, reader);
        ParseUtils.requireNoContent(reader);
    }

    public boolean isWrapped() {
        return this.wrapXmlElement;
    }

    public String getWrapperElement() {
        return this.wrapperElement;
    }

    public static class Builder
    extends MapAttributeDefinition.Builder<Builder, PropertiesAttributeDefinition> {
        private boolean wrapXmlElement = true;
        private String wrapperElement = null;
        private boolean xmlNameExplicitlySet = false;

        public Builder(String name, boolean allowNull) {
            super(name, allowNull);
        }

        public Builder(PropertiesAttributeDefinition basis) {
            super(basis);
        }

        public Builder(MapAttributeDefinition basis) {
            super(basis);
        }

        @Deprecated
        public Builder setWrapXmlElement(boolean wrap) {
            this.wrapXmlElement = wrap;
            return this;
        }

        @Deprecated
        public Builder setWrapperElement(String name) {
            this.wrapperElement = name;
            return this;
        }

        @Override
        public Builder setXmlName(String xmlName) {
            this.xmlNameExplicitlySet = true;
            return (Builder)super.setXmlName(xmlName);
        }

        @Override
        public PropertiesAttributeDefinition build() {
            String elementName;
            if (this.elementValidator == null) {
                this.elementValidator = new ModelTypeValidator(ModelType.STRING, this.allowNull, this.allowExpression);
            }
            String string = elementName = this.name.equals(this.xmlName) ? null : this.xmlName;
            if (this.attributeMarshaller == null) {
                this.attributeMarshaller = new AttributeMarshallers.PropertiesAttributeMarshaller(this.wrapperElement, this.xmlNameExplicitlySet ? this.xmlName : elementName, this.wrapXmlElement);
            }
            if (this.parser == null) {
                this.parser = new AttributeParsers.PropertiesParser(this.wrapperElement, elementName, this.wrapXmlElement);
            }
            return new PropertiesAttributeDefinition(this);
        }
    }
}

