/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.UnauthorizedException;
import org.jboss.as.controller._private.OperationFailedRuntimeException;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.access.ResourceNotAddressableException;
import org.jboss.as.controller.access.rbac.UnknowRoleException;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.FilteredData;
import org.jboss.as.controller.operations.global.GlobalOperationAttributes;
import org.jboss.as.controller.operations.global.ListOperations;
import org.jboss.as.controller.operations.global.LocaleResolver;
import org.jboss.as.controller.operations.global.MapOperations;
import org.jboss.as.controller.operations.global.QueryOperationHandler;
import org.jboss.as.controller.operations.global.ReadAttributeGroupHandler;
import org.jboss.as.controller.operations.global.ReadAttributeGroupNamesHandler;
import org.jboss.as.controller.operations.global.ReadAttributeHandler;
import org.jboss.as.controller.operations.global.ReadChildrenNamesHandler;
import org.jboss.as.controller.operations.global.ReadChildrenResourcesHandler;
import org.jboss.as.controller.operations.global.ReadChildrenTypesHandler;
import org.jboss.as.controller.operations.global.ReadOperationDescriptionHandler;
import org.jboss.as.controller.operations.global.ReadOperationNamesHandler;
import org.jboss.as.controller.operations.global.ReadResourceDescriptionHandler;
import org.jboss.as.controller.operations.global.ReadResourceHandler;
import org.jboss.as.controller.operations.global.UndefineAttributeHandler;
import org.jboss.as.controller.operations.global.WriteAttributeHandler;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.registry.WildcardReadResourceDescriptionAddressHack;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class GlobalOperationHandlers {
    public static final String CHECK_DEFAULT_RESOURCE_ACCESS = "check-default-resource-access";
    public static final String CHECK_RESOURCE_ACCESS = "check-resource-access";

    public static void registerGlobalOperations(ManagementResourceRegistration root, ProcessType processType) {
        if (processType == ProcessType.HOST_CONTROLLER) {
            root.registerOperationHandler(ReadResourceHandler.DEFINITION, ReadResourceHandler.INSTANCE, true);
            root.registerOperationHandler(ReadAttributeHandler.DEFINITION, ReadAttributeHandler.INSTANCE, true);
            root.registerOperationHandler(ReadAttributeGroupHandler.DEFINITION, ReadAttributeGroupHandler.INSTANCE, true);
        } else {
            root.registerOperationHandler(ReadResourceHandler.RESOLVE_DEFINITION, ReadResourceHandler.RESOLVE_INSTANCE, true);
            root.registerOperationHandler(ReadAttributeHandler.RESOLVE_DEFINITION, ReadAttributeHandler.RESOLVE_INSTANCE, true);
            root.registerOperationHandler(ReadAttributeGroupHandler.RESOLVE_DEFINITION, ReadAttributeGroupHandler.RESOLVE_INSTANCE, true);
        }
        root.registerOperationHandler(ReadResourceDescriptionHandler.DEFINITION, ReadResourceDescriptionHandler.INSTANCE, true);
        root.registerOperationHandler(ReadAttributeGroupNamesHandler.DEFINITION, ReadAttributeGroupNamesHandler.INSTANCE, true);
        root.registerOperationHandler(ReadChildrenNamesHandler.DEFINITION, ReadChildrenNamesHandler.INSTANCE, true);
        root.registerOperationHandler(ReadChildrenTypesHandler.DEFINITION, ReadChildrenTypesHandler.INSTANCE, true);
        root.registerOperationHandler(ReadChildrenResourcesHandler.DEFINITION, ReadChildrenResourcesHandler.INSTANCE, true);
        root.registerOperationHandler(ReadOperationNamesHandler.DEFINITION, ReadOperationNamesHandler.INSTANCE, true);
        root.registerOperationHandler(ReadOperationDescriptionHandler.DEFINITION, ReadOperationDescriptionHandler.INSTANCE, true);
        root.registerOperationHandler(QueryOperationHandler.DEFINITION, QueryOperationHandler.INSTANCE, true);
        root.registerOperationHandler(MapOperations.MAP_PUT_DEFINITION, MapOperations.MAP_PUT_HANDLER, true);
        root.registerOperationHandler(MapOperations.MAP_GET_DEFINITION, MapOperations.MAP_GET_HANDLER, true);
        root.registerOperationHandler(MapOperations.MAP_REMOVE_DEFINITION, MapOperations.MAP_REMOVE_HANDLER, true);
        root.registerOperationHandler(MapOperations.MAP_CLEAR_DEFINITION, MapOperations.MAP_CLEAR_HANDLER, true);
        root.registerOperationHandler(ListOperations.LIST_ADD_DEFINITION, ListOperations.LIST_ADD_HANDLER, true);
        root.registerOperationHandler(ListOperations.LIST_REMOVE_DEFINITION, ListOperations.LIST_REMOVE_HANDLER, true);
        root.registerOperationHandler(ListOperations.LIST_GET_DEFINITION, ListOperations.LIST_GET_HANDLER, true);
        root.registerOperationHandler(ListOperations.LIST_CLEAR_DEFINITION, ListOperations.LIST_CLEAR_HANDLER, true);
        root.registerOperationHandler(ReadResourceDescriptionHandler.CheckResourceAccessHandler.DEFINITION, new OperationStepHandler(){

            @Override
            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                throw new OperationFailedException("This should never be called");
            }
        }, true);
        root.registerOperationHandler(ReadResourceDescriptionHandler.CheckResourceAccessHandler.DEFAULT_DEFINITION, new OperationStepHandler(){

            @Override
            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                throw new OperationFailedException("This should never be called");
            }
        }, true);
        root.registerOperationHandler(WriteAttributeHandler.DEFINITION, WriteAttributeHandler.INSTANCE, true);
        root.registerOperationHandler(UndefineAttributeHandler.DEFINITION, UndefineAttributeHandler.INSTANCE, true);
    }

    private GlobalOperationHandlers() {
    }

    static Map<String, Set<String>> getChildAddresses(OperationContext context, PathAddress addr, ImmutableManagementResourceRegistration registry, Resource resource, String validChildType) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        Set<PathElement> elements = registry.getChildAddresses(PathAddress.EMPTY_ADDRESS);
        for (PathElement element : elements) {
            ImmutableManagementResourceRegistration childReg;
            ImmutableManagementResourceRegistration childRegistration;
            String childType = element.getKey();
            if (validChildType != null && !validChildType.equals(childType) || (childRegistration = registry.getSubModel(PathAddress.pathAddress(element))) == null) continue;
            AliasEntry aliasEntry = childRegistration.getAliasEntry();
            LinkedHashSet<String> set = (LinkedHashSet<String>)result.get(childType);
            if (set == null) {
                set = new LinkedHashSet<String>();
                result.put(childType, set);
            }
            if (aliasEntry == null) {
                if (resource != null && resource.hasChildren(childType)) {
                    Set<String> childNames = resource.getChildrenNames(childType);
                    if (element.isWildcard()) {
                        set.addAll(childNames);
                    } else if (childNames.contains(element.getValue())) {
                        set.add(element.getValue());
                    }
                }
            } else {
                PathAddress childAddr = addr.append(element);
                PathAddress target = aliasEntry.convertToTargetAddress(childAddr, AliasEntry.AliasContext.create(childAddr, context));
                assert (!childAddr.equals(target)) : "Alias was not translated";
                PathAddress targetParent = target.subAddress(0, target.size() - 1);
                Resource parentResource = context.readResourceFromRoot(targetParent, false);
                if (parentResource != null) {
                    PathElement targetElement = target.getLastElement();
                    if (targetElement.isWildcard()) {
                        set.addAll(parentResource.getChildrenNames(targetElement.getKey()));
                    } else if (parentResource.hasChild(targetElement)) {
                        set.add(element.getValue());
                    }
                }
            }
            if (element.isWildcard() || (childReg = registry.getSubModel(PathAddress.pathAddress(element))) == null || !childReg.isRemote()) continue;
            set.add(element.getValue());
        }
        for (String type : registry.getChildNames(PathAddress.EMPTY_ADDRESS)) {
            if (validChildType != null && !validChildType.equals(type) || result.containsKey(type)) continue;
            result.put(type, Collections.emptySet());
        }
        return result;
    }

    static Locale getLocale(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined(GlobalOperationAttributes.LOCALE.getName())) {
            return null;
        }
        String unparsed = GlobalOperationHandlers.normalizeLocale(operation.get(GlobalOperationAttributes.LOCALE.getName()).asString());
        try {
            return LocaleResolver.resolveLocale(unparsed);
        }
        catch (IllegalArgumentException e) {
            GlobalOperationHandlers.reportInvalidLocaleFormat(context, e.getMessage());
            return null;
        }
    }

    static boolean getRecursive(OperationContext context, ModelNode op) throws OperationFailedException {
        ModelNode recursiveNode = GlobalOperationAttributes.RECURSIVE.resolveModelAttribute(context, op);
        int recursiveValue = recursiveNode.isDefined() ? (recursiveNode.asBoolean() ? 1 : 0) : -1;
        int recursiveDepthValue = GlobalOperationAttributes.RECURSIVE_DEPTH.resolveModelAttribute(context, op).asInt(-1);
        return recursiveValue > 0 && recursiveDepthValue == -1 || recursiveValue != 0 && recursiveDepthValue > 0;
    }

    static void setNextRecursive(OperationContext context, ModelNode op, ModelNode nextOp) throws OperationFailedException {
        int recursiveDepthValue = GlobalOperationAttributes.RECURSIVE_DEPTH.resolveModelAttribute(context, op).asInt(-1);
        nextOp.get(GlobalOperationAttributes.RECURSIVE.getName()).set(op.get(GlobalOperationAttributes.RECURSIVE.getName()));
        switch (recursiveDepthValue) {
            case -1: {
                nextOp.get(GlobalOperationAttributes.RECURSIVE_DEPTH.getName()).set(op.get(GlobalOperationAttributes.RECURSIVE_DEPTH.getName()));
                break;
            }
            case 0: {
                nextOp.get(GlobalOperationAttributes.RECURSIVE_DEPTH.getName()).set(recursiveDepthValue);
                break;
            }
            default: {
                nextOp.get(GlobalOperationAttributes.RECURSIVE_DEPTH.getName()).set(recursiveDepthValue - 1);
            }
        }
    }

    private static String normalizeLocale(String toNormalize) {
        return "zh_Hans".equalsIgnoreCase(toNormalize) || "zh-Hans".equalsIgnoreCase(toNormalize) ? "zh_CN" : toNormalize;
    }

    private static void reportInvalidLocaleFormat(OperationContext context, String format) {
        String msg = ControllerLogger.ROOT_LOGGER.invalidLocaleString(format);
        ControllerLogger.MGMT_OP_LOGGER.debug(msg);
    }

    private static final class NoSuchResourceTypeException
    extends OperationFailedRuntimeException {
        private final PathAddress pathAddress;

        private NoSuchResourceTypeException(PathAddress pathAddress) {
            super(ControllerLogger.ROOT_LOGGER.noSuchResourceType(pathAddress));
            this.pathAddress = pathAddress;
        }

        private PathAddress getPathAddress() {
            return this.pathAddress;
        }
    }

    static class AvailableResponseWrapper
    implements OperationStepHandler {
        private final OperationStepHandler wrapped;
        private final AvailableResponse availableResponse;

        AvailableResponseWrapper(OperationStepHandler wrapped, AvailableResponse availableResponse) {
            this.wrapped = wrapped;
            this.availableResponse = availableResponse;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            try {
                this.wrapped.execute(context, operation);
            }
            catch (Resource.NoSuchResourceException e) {
                this.availableResponse.unavailable = true;
            }
        }
    }

    static class AvailableResponse {
        boolean unavailable;
        final ModelNode response;

        AvailableResponse(ModelNode response) {
            this.response = response;
        }
    }

    private static class RegistrationAddressResolver
    extends AbstractAddressResolver {
        RegistrationAddressResolver(ModelNode operation, ModelNode result, OperationStepHandler delegate) {
            super(operation, result, delegate, null, null);
        }

        @Override
        protected void executeMultiTargetChildren(PathAddress base, PathElement currentElement, PathAddress newRemaining, OperationContext context, ImmutableManagementResourceRegistration registration, boolean ignoreMissing) {
            String childType;
            String string = childType = currentElement.getKey().equals("*") ? null : currentElement.getKey();
            if (registration.isRemote()) {
                throw new IllegalStateException();
            }
            Set<PathElement> children = context.getResourceRegistration().getChildAddresses(base);
            if (children == null || children.isEmpty()) {
                throw new NoSuchResourceTypeException(base.append(currentElement));
            }
            boolean foundValid = false;
            PathAddress invalid = null;
            for (PathElement path : children) {
                if (childType != null && !childType.equals(path.getKey()) || path.getKey().equals("server") && path.isWildcard() && newRemaining.size() > 0) continue;
                PathAddress next = base.append(path);
                ImmutableManagementResourceRegistration nr = context.getResourceRegistration().getSubModel(next);
                try {
                    this.execute(next, newRemaining, context, nr, ignoreMissing);
                    foundValid = true;
                }
                catch (NoSuchResourceTypeException e) {
                    if (foundValid) continue;
                    PathAddress failedAddr = e.getPathAddress();
                    if (invalid != null && failedAddr.size() <= invalid.size()) continue;
                    PathAddress newBase = base.append(currentElement);
                    invalid = newBase.append(failedAddr.subAddress(newBase.size()));
                }
            }
            if (!foundValid) {
                if (invalid == null) {
                    invalid = base.append(currentElement);
                }
                throw new NoSuchResourceTypeException(invalid);
            }
        }

        @Override
        protected void executeSingleTargetChild(PathAddress base, PathElement currentElement, PathAddress newRemaining, OperationContext context, boolean ignoreMissing) {
            PathAddress next = base.append(currentElement);
            ImmutableManagementResourceRegistration nr = context.getResourceRegistration().getSubModel(next);
            if (nr == null) {
                throw new NoSuchResourceTypeException(next);
            }
            this.execute(next, newRemaining, context, nr, ignoreMissing);
        }

        @Override
        protected boolean authorize(OperationContext context, PathAddress base, ModelNode operation) {
            PathElement element;
            if (base.size() > 0 && !(element = base.getLastElement()).isWildcard() && element.getKey().equals("host")) {
                ModelNode toAuthorize = operation.clone();
                toAuthorize.get("operation").set("read-resource-description");
                toAuthorize.get("address").set(base.toModelNode());
                AuthorizationResult.Decision decision = context.authorize(toAuthorize, EnumSet.of(Action.ActionEffect.ADDRESS)).getDecision();
                return decision == AuthorizationResult.Decision.PERMIT;
            }
            return true;
        }
    }

    private static class FilterableRemoteOperationStepHandler
    implements OperationStepHandler {
        private final OperationStepHandler proxyHandler;
        private final PathAddress base;
        private final AtomicBoolean filtered;
        private final FilteredData filteredData;
        private final boolean ignoreMissing;

        public FilterableRemoteOperationStepHandler(OperationStepHandler proxyHandler, PathAddress base, AtomicBoolean filtered, FilteredData filteredData, boolean ignoreMissing) {
            this.proxyHandler = proxyHandler;
            this.base = base;
            this.filtered = filtered;
            this.filteredData = filteredData;
            this.ignoreMissing = ignoreMissing;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            block6: {
                try {
                    this.proxyHandler.execute(context, operation);
                    ControllerLogger.MGMT_OP_LOGGER.tracef("Preliminary result for %s is %s", operation, context.hasResult() ? context.getResult() : null);
                }
                catch (UnauthorizedException e) {
                    this.filteredData.addReadRestrictedResource(this.base);
                    this.filtered.set(true);
                    ControllerLogger.MGMT_OP_LOGGER.tracef("Caught UnauthorizedException in remote execution from %s", this.proxyHandler);
                }
                catch (ResourceNotAddressableException e) {
                    this.filteredData.addAccessRestrictedResource(this.base);
                    this.filtered.set(true);
                    ControllerLogger.MGMT_OP_LOGGER.tracef("Caught ResourceNotAddressableException in remote execution from %s", this.proxyHandler);
                }
                catch (Resource.NoSuchResourceException e) {
                    ModelNode toAuthorize = operation.clone();
                    toAuthorize.get("operation").set("read-resource-description");
                    toAuthorize.get("address").set(this.base.toModelNode());
                    AuthorizationResult.Decision decision = context.authorize(toAuthorize, EnumSet.of(Action.ActionEffect.ADDRESS)).getDecision();
                    ControllerLogger.MGMT_OP_LOGGER.tracef("Caught NoSuchResourceException in remote execution from %s. Authorization decision is %s", this.proxyHandler, (Object)decision);
                    if (decision == AuthorizationResult.Decision.DENY) {
                        this.filtered.set(true);
                        if (this.filteredData != null) {
                            this.filteredData.addAccessRestrictedResource(this.base);
                        }
                    }
                    if (this.ignoreMissing) break block6;
                    throw e;
                }
            }
        }
    }

    private static final class ModelAddressResolver
    extends AbstractAddressResolver {
        public ModelAddressResolver(ModelNode operation, ModelNode result, FilteredData filteredData, OperationStepHandler delegate, FilterPredicate predicate) {
            super(operation, result, delegate, filteredData, predicate);
        }

        @Override
        protected void executeMultiTargetChildren(PathAddress base, PathElement currentElement, PathAddress newRemaining, OperationContext context, ImmutableManagementResourceRegistration registration, boolean ignoreMissing) {
            String childType;
            Resource resource = context.readResource(base, false);
            String string = childType = currentElement.getKey().equals("*") ? null : currentElement.getKey();
            if (registration.isRemote()) {
                throw new IllegalStateException();
            }
            Map<String, Set<String>> resolved = GlobalOperationHandlers.getChildAddresses(context, base, registration, resource, childType);
            for (Map.Entry<String, Set<String>> entry : resolved.entrySet()) {
                String key = entry.getKey();
                Set<String> children = entry.getValue();
                if (children.isEmpty()) continue;
                if (currentElement.isWildcard()) {
                    for (String child : children) {
                        PathElement e = PathElement.pathElement(key, child);
                        PathAddress next = base.append(e);
                        ImmutableManagementResourceRegistration nr = context.getResourceRegistration().getSubModel(next);
                        if (!resource.hasChild(e) && (nr == null || !nr.isRemote())) continue;
                        this.safeExecute(next, newRemaining, context, nr, true);
                    }
                    continue;
                }
                String[] segments = currentElement.getSegments();
                boolean ignore = ignoreMissing || segments.length > 1;
                for (String segment : currentElement.getSegments()) {
                    if (!children.contains(segment)) continue;
                    PathElement e = PathElement.pathElement(key, segment);
                    PathAddress next = base.append(e);
                    ImmutableManagementResourceRegistration nr = context.getResourceRegistration().getSubModel(next);
                    if (!resource.hasChild(e) && (nr == null || !nr.isRemote())) continue;
                    this.safeExecute(next, newRemaining, context, nr, ignore);
                }
            }
        }

        @Override
        protected void executeSingleTargetChild(PathAddress base, PathElement currentElement, PathAddress newRemaining, OperationContext context, boolean ignoreMissing) {
            PathAddress next = base.append(currentElement);
            Resource resource = context.readResource(base, false);
            ImmutableManagementResourceRegistration nr = context.getResourceRegistration().getSubModel(next);
            if (resource.hasChild(currentElement) || nr != null && nr.isRemote()) {
                this.safeExecute(next, newRemaining, context, nr, ignoreMissing);
            } else if (!resource.hasChild(currentElement)) {
                throw new Resource.NoSuchResourceException(currentElement);
            }
        }

        @Override
        protected boolean authorize(OperationContext context, PathAddress base, ModelNode operation) {
            try {
                context.readResource(base, false);
            }
            catch (UnknowRoleException ex) {
                context.getFailureDescription().set(ex.getMessage());
                return false;
            }
            return true;
        }
    }

    private static abstract class AbstractAddressResolver
    implements OperationStepHandler {
        private static final FilterPredicate DEFAULT_PREDICATE = item -> !item.isDefined() || !item.hasDefined("address");
        private final ModelNode operation;
        private final ModelNode result;
        private final FilteredData filteredData;
        private final FilterPredicate predicate;
        private final OperationStepHandler handler;

        public AbstractAddressResolver(ModelNode operation, ModelNode result, OperationStepHandler delegate, FilteredData filteredData, FilterPredicate predicate) {
            this.operation = operation;
            this.result = result;
            this.handler = delegate;
            this.predicate = predicate == null ? DEFAULT_PREDICATE : predicate;
            this.filteredData = filteredData;
        }

        @Override
        public void execute(OperationContext context, ModelNode ignored) throws OperationFailedException {
            PathAddress addr = PathAddress.pathAddress(this.operation.require("address"));
            PathAddress aliasAddr = WildcardReadResourceDescriptionAddressHack.detachAliasAddress(context, this.operation);
            PathAddress address = aliasAddr == null ? addr : aliasAddr;
            this.execute(PathAddress.EMPTY_ADDRESS, address, context, context.getRootResourceRegistration(), true);
            context.completeStep(new OperationContext.ResultHandler(){

                @Override
                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                    if (result.getType() == ModelType.LIST) {
                        boolean replace = false;
                        ModelNode replacement = new ModelNode().setEmptyList();
                        for (ModelNode item : result.asList()) {
                            if (predicate.test(item)) {
                                replace = true;
                                continue;
                            }
                            replacement.add(item);
                        }
                        if (replace) {
                            result.set(replacement);
                        }
                    }
                }
            });
        }

        protected void safeExecute(PathAddress base, PathAddress remaining, OperationContext context, ImmutableManagementResourceRegistration registration, boolean ignoreMissing) {
            block5: {
                try {
                    ControllerLogger.MGMT_OP_LOGGER.tracef("safeExecute for %s, remaining is %s", base, remaining);
                    this.execute(base, remaining, context, registration, ignoreMissing);
                }
                catch (UnauthorizedException e) {
                    this.filteredData.addReadRestrictedResource(base);
                    ControllerLogger.MGMT_OP_LOGGER.tracef("Caught UnauthorizedException in %s", this);
                }
                catch (ResourceNotAddressableException e) {
                    this.filteredData.addAccessRestrictedResource(base);
                    ControllerLogger.MGMT_OP_LOGGER.tracef("Caught ResourceNotAddressableException in %s", this);
                }
                catch (Resource.NoSuchResourceException e) {
                    ModelNode toAuthorize = Util.createEmptyOperation("read-resource", base);
                    AuthorizationResult.Decision decision = context.authorize(toAuthorize, EnumSet.of(Action.ActionEffect.ADDRESS)).getDecision();
                    ControllerLogger.MGMT_OP_LOGGER.tracef("Caught NoSuchResourceException in %s. Authorization decision is %s", this, (Object)decision);
                    if (decision == AuthorizationResult.Decision.DENY) {
                        this.filteredData.addAccessRestrictedResource(base);
                    }
                    if (ignoreMissing) break block5;
                    throw e;
                }
            }
        }

        protected void execute(final PathAddress base, PathAddress remaining, OperationContext context, ImmutableManagementResourceRegistration registration, boolean ignoreMissing) {
            if (registration.isRemote()) {
                if (this.isWFCORE621Needed(registration, remaining)) {
                    this.executeWFCORE621(base, remaining, context, registration, ignoreMissing);
                } else {
                    this.executeRemote(base, remaining, context, registration, ignoreMissing);
                }
                return;
            }
            if (!this.authorize(context, base, this.operation)) {
                return;
            }
            if (remaining.size() > 0) {
                PathElement currentElement = remaining.getElement(0);
                PathAddress newRemaining = remaining.subAddress(1);
                if (currentElement.isMultiTarget()) {
                    this.executeMultiTargetChildren(base, currentElement, newRemaining, context, registration, ignoreMissing);
                } else {
                    this.executeSingleTargetChild(base, currentElement, newRemaining, context, ignoreMissing);
                }
            } else {
                ModelNode newOp = this.operation.clone();
                newOp.get("address").set(base.toModelNode());
                final ModelNode resultItem = this.result.add();
                ControllerLogger.MGMT_OP_LOGGER.tracef("Added ModelAddressResolver result item for %s", base);
                final ModelNode resultAddress = resultItem.get("address");
                OperationStepHandler wrapper = new OperationStepHandler(){

                    @Override
                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        try {
                            handler.execute(context, operation);
                            context.completeStep(new OperationContext.ResultHandler(){

                                @Override
                                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                                    ControllerLogger.MGMT_OP_LOGGER.tracef("ModelAddressResolver result for %s is %s", base, resultItem);
                                    if (resultItem.hasDefined("result")) {
                                        resultAddress.set(base.toModelNode());
                                        if (resultItem.hasDefined(new String[]{"response-headers", "access-control"})) {
                                            ModelNode headers = resultItem.get("response-headers");
                                            ModelNode acc = headers.remove("access-control");
                                            if (headers.asInt() == 0) {
                                                resultItem.remove("response-headers");
                                            }
                                            filteredData.populate(acc, PathAddress.EMPTY_ADDRESS);
                                        }
                                    } else {
                                        resultItem.clear();
                                    }
                                }
                            });
                        }
                        catch (Resource.NoSuchResourceException noSuchResourceException) {
                            // empty catch block
                        }
                    }
                };
                context.addStep(resultItem, newOp, wrapper, OperationContext.Stage.MODEL, true);
            }
        }

        protected abstract void executeSingleTargetChild(PathAddress var1, PathElement var2, PathAddress var3, OperationContext var4, boolean var5);

        protected abstract void executeMultiTargetChildren(PathAddress var1, PathElement var2, PathAddress var3, OperationContext var4, ImmutableManagementResourceRegistration var5, boolean var6);

        protected abstract boolean authorize(OperationContext var1, PathAddress var2, ModelNode var3);

        private boolean isWFCORE621Needed(ImmutableManagementResourceRegistration registration, PathAddress remaining) {
            PathElement pe;
            if (remaining.size() > 0 && (pe = remaining.getElement(0)).isMultiTarget() && "server".equals(pe.getKey())) {
                ModelVersion modelVersion = registration.getProxyController(PathAddress.EMPTY_ADDRESS).getKernelModelVersion();
                return modelVersion.getMajor() < 3;
            }
            return false;
        }

        private void executeWFCORE621(final PathAddress base, final PathAddress remaining, OperationContext context, final ImmutableManagementResourceRegistration registration, final boolean ignoreMissing) {
            ControllerLogger.MGMT_OP_LOGGER.tracef("Executing WFCORE-621 op for base %s and remaining %s", base, remaining);
            final boolean wildfly8 = registration.getProxyController(PathAddress.EMPTY_ADDRESS).getKernelModelVersion().getMajor() == 2;
            final ModelNode serverNameResponse = new ModelNode();
            final AtomicBoolean filtered = new AtomicBoolean(false);
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ControllerLogger.MGMT_OP_LOGGER.tracef("Executing WFCORE-621 2nd step for base %s and remaining %s; filtered? %s serverNames=%s", new Object[]{base, remaining, filtered, serverNameResponse});
                    if (filtered.get() || !serverNameResponse.hasDefined("result")) {
                        return;
                    }
                    Set targetServers = AbstractAddressResolver.extractServerNames(serverNameResponse.get("result"), operation, remaining, wildfly8);
                    PathAddress afterServer = remaining.size() > 1 ? remaining.subAddress(1) : PathAddress.EMPTY_ADDRESS;
                    for (String targetServer : targetServers) {
                        PathAddress newBase = base.append(PathElement.pathElement("server", targetServer));
                        this.safeExecute(newBase, afterServer, context, registration, ignoreMissing);
                    }
                }
            }, OperationContext.Stage.MODEL, true);
            String opName = wildfly8 ? "read-children-resources" : "read-children-names";
            ModelNode op = Util.createEmptyOperation(opName, base);
            op.get("child-type").set("server");
            OperationStepHandler proxyHandler = registration.getOperationHandler(PathAddress.EMPTY_ADDRESS, opName);
            FilterableRemoteOperationStepHandler filterableHandler = new FilterableRemoteOperationStepHandler(proxyHandler, base, filtered, this.filteredData, ignoreMissing);
            context.addStep(serverNameResponse, op, filterableHandler, OperationContext.Stage.MODEL, true);
        }

        private static Set<String> extractServerNames(ModelNode serverResultNode, ModelNode operation, PathAddress remaining, boolean wildfly8) {
            PathElement serverPE = remaining.getElement(0);
            HashSet interestingServers = null;
            if (!serverPE.isWildcard()) {
                interestingServers = new HashSet();
                Collections.addAll(interestingServers, serverPE.getSegments());
            }
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            if (wildfly8) {
                for (String serverName : serverResultNode.keys()) {
                    boolean validServer;
                    if (interestingServers != null && !interestingServers.contains(serverName)) continue;
                    ModelNode serverVal = serverResultNode.get(serverName);
                    boolean bl = validServer = serverVal.isDefined() && serverVal.asInt() > 0;
                    if (!validServer && remaining.size() == 1) {
                        String opName = operation.get("operation").asString();
                        if ("read-attribute".equals(opName)) {
                            String attrName = operation.get("name").asString();
                            validServer = "launch-type".equals(attrName) || "server-state".equals(attrName);
                        } else if ("read-resource".equals(opName)) {
                            boolean bl2 = validServer = operation.hasDefined("include-runtime") && operation.get("include-runtime").asBoolean();
                        }
                    }
                    if (!validServer) continue;
                    result.add(serverName);
                }
            } else {
                for (ModelNode serverNameNode : serverResultNode.asList()) {
                    String serverName = serverNameNode.asString();
                    if (interestingServers != null && !interestingServers.contains(serverName)) continue;
                    result.add(serverName);
                }
            }
            return result;
        }

        private void executeRemote(final PathAddress base, final PathAddress remaining, OperationContext context, ImmutableManagementResourceRegistration registration, final boolean ignoreMissing) {
            ModelNode remoteOp = this.operation.clone();
            final PathAddress fullAddress = base.append(remaining);
            remoteOp.get("address").set(fullAddress.toModelNode());
            final ModelNode resultItem = new ModelNode();
            final OperationStepHandler proxyHandler = registration.getOperationHandler(PathAddress.EMPTY_ADDRESS, this.operation.require("operation").asString());
            context.addStep(resultItem, remoteOp, new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    try {
                        ControllerLogger.MGMT_OP_LOGGER.tracef("sending ModelAddressResolver request %s to remote process using %s", operation, proxyHandler);
                        final AtomicBoolean filtered = new AtomicBoolean(false);
                        context.addStep(new FilterableRemoteOperationStepHandler(proxyHandler, base, filtered, filteredData, ignoreMissing), OperationContext.Stage.MODEL, true);
                        context.completeStep(new OperationContext.ResultHandler(){

                            @Override
                            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                                PathAddress rbacPrefix;
                                ControllerLogger.MGMT_OP_LOGGER.tracef("ModelAddressResolver response from remote process is %s", resultItem);
                                if (filtered.get()) {
                                    ControllerLogger.MGMT_OP_LOGGER.trace("Response was filtered");
                                    return;
                                }
                                PathAddress pathAddress = rbacPrefix = base.size() > 1 && base.getElement(1).getKey().equals("server") ? base : PathAddress.EMPTY_ADDRESS;
                                if (remaining.isMultiTarget()) {
                                    if (resultItem.has("result") && resultItem.get("result").getType() == ModelType.LIST) {
                                        for (ModelNode rr : resultItem.get("result").asList()) {
                                            ModelNode nr = result.add();
                                            PathAddress address = PathAddress.pathAddress(rr.get("address"));
                                            int max = Math.min(base.size(), address.size());
                                            int match = 0;
                                            for (int i = 0; i < max; ++i) {
                                                PathElement eb = base.getElement(i);
                                                PathElement ea = address.getElement(i);
                                                if (!eb.getKey().equals(ea.getKey())) continue;
                                                match = i + 1;
                                            }
                                            PathAddress resolvedAddress = base.append(address.subAddress(match));
                                            ControllerLogger.MGMT_OP_LOGGER.tracef("recording multi-target ModelAddressResolver response to %s at %s", fullAddress, resolvedAddress);
                                            nr.get("address").set(resolvedAddress.toModelNode());
                                            nr.get("outcome").set(rr.get("outcome"));
                                            nr.get("result").set(rr.get("result"));
                                            if (!rr.hasDefined("response-headers")) continue;
                                            ModelNode headers = rr.get("response-headers");
                                            ModelNode acc = headers.remove("access-control");
                                            if (headers.asInt() > 0) {
                                                nr.get("response-headers").set(headers);
                                            }
                                            if (acc == null || !acc.isDefined()) continue;
                                            filteredData.populate(acc, rbacPrefix);
                                            ControllerLogger.MGMT_OP_LOGGER.tracef("Populated local filtered data with remote access control headers %s from result item %s", acc, rr);
                                        }
                                        if (resultItem.hasDefined(new String[]{"response-headers", "access-control"})) {
                                            ModelNode acc = resultItem.get(new String[]{"response-headers", "access-control"});
                                            filteredData.populate(acc, PathAddress.EMPTY_ADDRESS);
                                        }
                                    }
                                } else {
                                    ControllerLogger.MGMT_OP_LOGGER.tracef("recording non-multi-target ModelAddressResolver response to %s", fullAddress);
                                    ModelNode nr = result.add();
                                    nr.get("address").set(fullAddress.toModelNode());
                                    nr.get("outcome").set(resultItem.get("outcome"));
                                    nr.get("result").set(resultItem.get("result"));
                                    if (resultItem.hasDefined("response-headers")) {
                                        ModelNode headers = resultItem.get("response-headers");
                                        ModelNode acc = headers.remove("access-control");
                                        if (headers.asInt() > 0) {
                                            nr.get("response-headers").set(headers);
                                        }
                                        if (acc != null && acc.isDefined()) {
                                            filteredData.populate(acc, PathAddress.EMPTY_ADDRESS);
                                            ControllerLogger.MGMT_OP_LOGGER.tracef("Populated local filtered data with remote access control headers %s from result item %s", acc, resultItem);
                                        }
                                    }
                                }
                            }
                        });
                    }
                    catch (Resource.NoSuchResourceException noSuchResourceException) {
                        // empty catch block
                    }
                }
            }, OperationContext.Stage.MODEL, true);
        }
    }

    @FunctionalInterface
    static interface FilterPredicate
    extends Predicate<ModelNode> {
    }

    public static abstract class AbstractMultiTargetHandler
    implements OperationStepHandler {
        public static final ModelNode FAKE_OPERATION;
        private final FilteredData filteredData;
        private final boolean ignoreMissingResource;
        private final FilterPredicate predicate;
        private final boolean registryOnly;

        protected AbstractMultiTargetHandler() {
            this(null, false);
        }

        protected AbstractMultiTargetHandler(boolean registryOnly) {
            this(null, false, null, registryOnly);
        }

        protected AbstractMultiTargetHandler(FilteredData filteredData) {
            this(filteredData, false);
        }

        protected AbstractMultiTargetHandler(FilteredData filteredData, boolean ignoreMissingResource) {
            this(filteredData, ignoreMissingResource, null);
        }

        protected AbstractMultiTargetHandler(FilteredData filteredData, boolean ignoreMissingResource, FilterPredicate predicate) {
            this(filteredData, ignoreMissingResource, predicate, false);
        }

        private AbstractMultiTargetHandler(FilteredData filteredData, boolean ignoreMissingResource, FilterPredicate predicate, boolean registryOnly) {
            this.filteredData = filteredData;
            this.ignoreMissingResource = ignoreMissingResource;
            this.predicate = predicate;
            this.registryOnly = registryOnly;
        }

        protected FilteredData getFilteredData() {
            return this.filteredData;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = context.getCurrentAddress();
            if (address.isMultiTarget()) {
                final FilteredData localFilteredData = this.filteredData == null ? new FilteredData(PathAddress.EMPTY_ADDRESS) : this.filteredData;
                ModelNode result = context.getResult().setEmptyList();
                OperationStepHandler delegateStepHandler = new OperationStepHandler(){

                    @Override
                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        this.doExecute(context, operation, localFilteredData, true);
                    }
                };
                ModelNode fakeOperationResponse = new ModelNode();
                context.addStep(fakeOperationResponse, FAKE_OPERATION.clone(), this.registryOnly ? new RegistrationAddressResolver(operation, result, delegateStepHandler) : new ModelAddressResolver(operation, result, localFilteredData, delegateStepHandler, this.predicate), OperationContext.Stage.MODEL, true);
                context.completeStep(new MultiTargetResultHandler(fakeOperationResponse, localFilteredData, result));
            } else {
                this.doExecute(context, operation, this.filteredData, this.ignoreMissingResource);
            }
        }

        abstract void doExecute(OperationContext var1, ModelNode var2, FilteredData var3, boolean var4) throws OperationFailedException;

        static {
            ModelNode resolve = new ModelNode();
            resolve.get("operation").set("resolve");
            resolve.get("address").setEmptyList();
            resolve.protect();
            FAKE_OPERATION = resolve;
        }

        private static class MultiTargetResultHandler
        implements OperationContext.ResultHandler {
            private final FilteredData localFilteredData;
            private final ModelNode result;
            private final ModelNode fakeOperationResponse;

            public MultiTargetResultHandler(ModelNode fakeOperationResponse, FilteredData localFilteredData, ModelNode result) {
                this.localFilteredData = localFilteredData;
                this.result = result;
                this.fakeOperationResponse = fakeOperationResponse;
            }

            @Override
            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                if (this.fakeOperationResponse != null && this.fakeOperationResponse.hasDefined("failure-description")) {
                    context.getFailureDescription().set(this.fakeOperationResponse.get("failure-description"));
                    return;
                }
                if (this.localFilteredData.hasFilteredData()) {
                    context.getResponseHeaders().get("access-control").set(this.localFilteredData.toModelNode());
                }
                if (resultAction == OperationContext.ResultAction.ROLLBACK && !context.hasFailureDescription() && this.result.isDefined()) {
                    String op = operation.require("operation").asString();
                    HashMap<PathAddress, ModelNode> failures = new HashMap<PathAddress, ModelNode>();
                    for (ModelNode resultItem : this.result.asList()) {
                        if (!resultItem.hasDefined("failure-description")) continue;
                        PathAddress failedAddress = PathAddress.pathAddress(resultItem.get("address"));
                        ModelNode failedDesc = resultItem.get("failure-description");
                        failures.put(failedAddress, failedDesc);
                    }
                    if (failures.size() == 1) {
                        Map.Entry entry = failures.entrySet().iterator().next();
                        if (((ModelNode)entry.getValue()).getType() == ModelType.STRING) {
                            context.getFailureDescription().set(ControllerLogger.ROOT_LOGGER.wildcardOperationFailedAtSingleAddress(op, (PathAddress)entry.getKey(), ((ModelNode)entry.getValue()).asString()));
                        } else {
                            context.getFailureDescription().set(ControllerLogger.ROOT_LOGGER.wildcardOperationFailedAtSingleAddressWithComplexFailure(op, (PathAddress)entry.getKey()));
                        }
                    } else if (failures.size() > 1) {
                        context.getFailureDescription().set(ControllerLogger.ROOT_LOGGER.wildcardOperationFailedAtMultipleAddresses(op, failures.keySet()));
                    }
                }
            }
        }
    }
}

