/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.security;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.logging.ControllerLogger;

public class CredentialStoreURIParser {
    public static final String CR_STORE_SCHEME = "cr-store";
    private String name;
    private String storageFile;
    private final HashMap<String, String> options = new HashMap();
    private String attribute;

    public CredentialStoreURIParser(String uri) throws URISyntaxException {
        URI uriToParse;
        int fragmentInd;
        int schemeInd = 0;
        if (uri.startsWith("cr-store:")) {
            schemeInd = "cr-store:".length();
        }
        if ((fragmentInd = uri.indexOf(35)) == 0) {
            throw ControllerLogger.ROOT_LOGGER.credentialStoreHasNoName(CredentialStoreURIParser.safeCRStoreURI(uri));
        }
        if (fragmentInd > -1) {
            String fragment = uri.substring(fragmentInd + 1);
            if (fragment.indexOf(35) > -1) {
                throw new URISyntaxException(uri, ControllerLogger.ROOT_LOGGER.moreThanOneFragmentDefined(), fragmentInd + fragment.indexOf(35));
            }
            uriToParse = new URI(CR_STORE_SCHEME, uri.substring(schemeInd, fragmentInd), fragment);
        } else {
            uriToParse = new URI(CR_STORE_SCHEME, uri.substring(schemeInd), null);
        }
        this.parse(uriToParse);
    }

    public CredentialStoreURIParser(URI uri) {
        this.parse(uri);
    }

    private void parse(URI uri) {
        if (!uri.isAbsolute()) {
            throw ControllerLogger.ROOT_LOGGER.credentialStoreURIisNotAbsolute(CredentialStoreURIParser.safeCRStoreURI(uri.toString()));
        }
        if (!CR_STORE_SCHEME.equals(uri.getScheme())) {
            throw ControllerLogger.ROOT_LOGGER.credentialStoreURIWrongScheme(CredentialStoreURIParser.safeCRStoreURI(uri.toString()));
        }
        String authority = uri.getAuthority();
        if (authority == null) {
            throw ControllerLogger.ROOT_LOGGER.credentialStoreHasNoName(CredentialStoreURIParser.safeCRStoreURI(uri.toString()));
        }
        this.name = authority;
        String path = uri.getPath();
        this.storageFile = path != null && path.length() > 1 ? path.substring(1) : null;
        this.parseQueryParameter(uri.getQuery(), uri.toString());
        String fragment = uri.getFragment();
        if (fragment != null && fragment.length() >= 0) {
            if (fragment.isEmpty()) {
                throw ControllerLogger.ROOT_LOGGER.credentialStoreURIAttributeEmpty(CredentialStoreURIParser.safeCRStoreURI(uri.toString()));
            }
            this.attribute = fragment;
        } else {
            this.attribute = null;
        }
    }

    private void parseQueryParameter(String query, String uri) {
        if (query == null) {
            return;
        }
        int i = 0;
        boolean state = false;
        StringBuilder token = new StringBuilder();
        String key = null;
        String value = null;
        while (i < query.length()) {
            char c = query.charAt(i);
            if (!state) {
                if (c == '=') {
                    state = true;
                    key = token.toString();
                    value = null;
                    token.setLength(0);
                } else {
                    token.append(c);
                }
                ++i;
                continue;
            }
            if (!state) continue;
            if (c == '\'') {
                if (query.charAt(i - 1) != '=') {
                    throw ControllerLogger.ROOT_LOGGER.credentialStoreURIParameterOpeningQuote(CredentialStoreURIParser.safeCRStoreURI(uri));
                }
                int inQuotes = i + 1;
                c = query.charAt(inQuotes);
                while (inQuotes < query.length() && c != '\'') {
                    token.append(c);
                    c = query.charAt(++inQuotes);
                }
                if (c == '\'') {
                    i = inQuotes + 1;
                    if (i >= query.length() || query.charAt(i) == ';') continue;
                    throw ControllerLogger.ROOT_LOGGER.credentialStoreURIParameterClosingQuote(CredentialStoreURIParser.safeCRStoreURI(uri));
                }
                throw ControllerLogger.ROOT_LOGGER.credentialStoreURIParameterUnexpectedEnd(CredentialStoreURIParser.safeCRStoreURI(uri));
            }
            if (c == ';') {
                value = token.toString();
                if (key == null) {
                    throw ControllerLogger.ROOT_LOGGER.credentialStoreURIParameterNameExpected(CredentialStoreURIParser.safeCRStoreURI(uri));
                }
                this.options.put(key, value);
                ++i;
                key = null;
                value = null;
                token.setLength(0);
                state = false;
                continue;
            }
            token.append(c);
            ++i;
        }
        if (key == null || token.length() <= 0) {
            throw ControllerLogger.ROOT_LOGGER.credentialStoreURIParameterUnexpectedEnd(CredentialStoreURIParser.safeCRStoreURI(uri));
        }
        this.options.put(key, token.toString());
    }

    public String getName() {
        return this.name;
    }

    public String getScheme() {
        return CR_STORE_SCHEME;
    }

    public static String safeCRStoreURI(String uri) {
        int startOfQuery = uri.indexOf(63);
        if (startOfQuery > -1) {
            return uri.substring(0, startOfQuery) + "...";
        }
        return uri;
    }

    public String getStorageFile() {
        return this.storageFile;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public String getParameter(String param) {
        return this.options.get(param);
    }

    public Set<String> getParameters() {
        return this.options.keySet();
    }

    public Map<String, String> getOptionsMap() {
        return new HashMap<String, String>(this.options);
    }
}

