/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.UnauthorizedException;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.access.ResourceAuthorization;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.registry.CapabilityId;
import org.jboss.as.controller.capability.registry.CapabilityRegistration;
import org.jboss.as.controller.capability.registry.CapabilityScope;
import org.jboss.as.controller.capability.registry.ImmutableCapabilityRegistry;
import org.jboss.as.controller.capability.registry.RegistrationPoint;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.FilteredData;
import org.jboss.as.controller.operations.global.GlobalOperationAttributes;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.AliasStepHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class ReadFeatureDescriptionHandler
extends GlobalOperationHandlers.AbstractMultiTargetHandler {
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-feature-description", ControllerResolver.getResolver("global")).setParameters(GlobalOperationAttributes.RECURSIVE, GlobalOperationAttributes.RECURSIVE_DEPTH).setReadOnly().withFlag(OperationEntry.Flag.HIDDEN).setReplyValueType(ModelType.OBJECT).build();
    private final ImmutableCapabilityRegistry capabilityRegistry;
    private static final String PROFILE_PREFIX = "$profile.";
    private static final String DOMAIN_EXTENSION = "domain.extension";
    private static final String HOST_EXTENSION = "host.extension";
    private static final ModelNode PROXY_NO_SUCH_RESOURCE;

    public static OperationStepHandler getInstance(ImmutableCapabilityRegistry capabilityRegistry) {
        return new ReadFeatureDescriptionHandler(capabilityRegistry);
    }

    private ReadFeatureDescriptionHandler(ImmutableCapabilityRegistry capabilityRegistry) {
        super(true);
        this.capabilityRegistry = capabilityRegistry;
    }

    private ReadFeatureAccessControlContext getAccessControlContext() {
        return null;
    }

    @Override
    void doExecute(OperationContext context, ModelNode operation, FilteredData filteredData, boolean ignoreMissingResource) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        ReadFeatureAccessControlContext accessControlContext = this.getAccessControlContext() == null ? new ReadFeatureAccessControlContext(address, null) : this.getAccessControlContext();
        this.doExecute(context, operation, accessControlContext);
    }

    void doExecute(OperationContext context, ModelNode operation, ReadFeatureAccessControlContext accessControlContext) throws OperationFailedException {
        if (accessControlContext.parentAddresses == null) {
            this.doExecuteInternal(context, operation, accessControlContext);
        } else {
            try {
                this.doExecuteInternal(context, operation, accessControlContext);
            }
            catch (UnauthorizedException | Resource.NoSuchResourceException nsre) {
                context.getResult().set(new ModelNode());
            }
        }
    }

    private void doExecuteInternal(OperationContext context, ModelNode operation, ReadFeatureAccessControlContext accessControlContext) throws OperationFailedException {
        String extension;
        for (AttributeDefinition def : DEFINITION.getParameters()) {
            def.validateOperation(operation);
        }
        String opName = operation.require("operation").asString();
        PathAddress opAddr = PathAddress.pathAddress(operation.get("address"));
        boolean recursive = GlobalOperationHandlers.getRecursive(context, operation);
        ImmutableManagementResourceRegistration registry = this.getResourceRegistrationCheckForAlias(context, opAddr);
        PathAddress pa = registry.getPathAddress();
        ModelNode feature = this.describeFeature(Locale.US, registry, CapabilityScope.Factory.create(context.getProcessType(), pa), this.isProfileScope(context.getProcessType(), pa));
        if (pa.size() == 0 && context.getProcessType().isServer()) {
            ModelNode param = new ModelNode();
            param.get("name").set("server-root");
            param.get("default").set("/");
            param.get("feature-id").set(true);
            feature.require("feature").get("params").add(param);
            feature.require("feature").require("annotation").get("addr-params").set("server-root");
        }
        if (pa.getLastElement() != null && "subsystem".equals(pa.getLastElement().getKey()) && (extension = this.getExtension(context, pa.getLastElement().getValue())) != null) {
            ModelNode extensionParam = new ModelNode();
            extensionParam.get("name").set("extension");
            extensionParam.get("default").set(extension);
            feature.get("feature").get("params").add(extensionParam);
            ModelNode packages = feature.get("feature").get("packages").setEmptyList();
            ModelNode packageNode = new ModelNode();
            packageNode.get("package").set(extension);
            packages.add(packageNode);
        }
        final HashMap<PathElement, ModelNode> childResources = recursive ? new HashMap<PathElement, ModelNode>() : Collections.emptyMap();
        ReadFeatureAssemblyHandler assemblyHandler = new ReadFeatureAssemblyHandler(feature, childResources, accessControlContext);
        context.addStep(assemblyHandler, OperationContext.Stage.MODEL, true);
        if (recursive) {
            ModelNode children = !feature.get("feature").get("children").isDefined() ? feature.get("feature").get("children").setEmptyObject() : feature.get("feature").get("children");
            for (PathElement element : registry.getChildAddresses(PathAddress.EMPTY_ADDRESS)) {
                PathAddress address;
                PathAddress relativeAddr = PathAddress.pathAddress(element);
                ImmutableManagementResourceRegistration childReg = registry.getSubModel(relativeAddr);
                boolean readChild = true;
                if (childReg.isRemote()) {
                    readChild = false;
                }
                if (childReg.isAlias()) {
                    readChild = false;
                }
                if (childReg.isRuntimeOnly()) {
                    readChild = false;
                }
                if (!childReg.isFeature()) {
                    readChild = false;
                }
                if (!readChild) continue;
                ModelNode childNode = children.get(element.getKey());
                childNode.get("feature");
                ModelNode rrOp = operation.clone();
                try {
                    address = PathAddress.pathAddress(opAddr, element);
                }
                catch (Exception e) {
                    continue;
                }
                rrOp.get("address").set(address.toModelNode());
                GlobalOperationHandlers.setNextRecursive(context, operation, rrOp);
                ModelNode rrRsp = new ModelNode();
                childResources.put(element, rrRsp);
                OperationStepHandler handler = this.getRecursiveStepHandler(childReg, opName, accessControlContext, address);
                context.addStep(rrRsp, rrOp, handler, OperationContext.Stage.MODEL, true);
            }
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            @Override
            public void handleRollback(OperationContext context, ModelNode operation) {
                if (!context.hasFailureDescription()) {
                    for (ModelNode value : childResources.values()) {
                        if (!value.hasDefined("failure-description")) continue;
                        context.getFailureDescription().set(value.get("failure-description"));
                        break;
                    }
                }
            }
        });
    }

    private String getExtension(OperationContext context, String subsystem) {
        for (String extensionName : context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false).getChildrenNames("extension")) {
            Resource extension = context.readResourceFromRoot(PathAddress.pathAddress("extension", extensionName), false);
            if (!extension.getChildrenNames("subsystem").contains(subsystem)) continue;
            return extensionName;
        }
        return null;
    }

    private OperationStepHandler getRecursiveStepHandler(ImmutableManagementResourceRegistration childReg, String opName, ReadFeatureAccessControlContext accessControlContext, PathAddress address) {
        OperationStepHandler overrideHandler = childReg.getOperationHandler(PathAddress.EMPTY_ADDRESS, opName);
        if (overrideHandler != null && (overrideHandler.getClass() == ReadFeatureDescriptionHandler.class || overrideHandler.getClass() == AliasStepHandler.class)) {
            overrideHandler = null;
        }
        if (overrideHandler != null) {
            return new NestedReadFeatureHandler(this.capabilityRegistry, overrideHandler);
        }
        return new NestedReadFeatureHandler(this.capabilityRegistry, new ReadFeatureAccessControlContext(address, accessControlContext));
    }

    private ImmutableManagementResourceRegistration getResourceRegistrationCheckForAlias(OperationContext context, PathAddress opAddr) {
        ImmutableManagementResourceRegistration root = context.getRootResourceRegistration();
        ImmutableManagementResourceRegistration registry = root.getSubModel(opAddr);
        AliasEntry aliasEntry = registry.getAliasEntry();
        if (aliasEntry == null) {
            return registry;
        }
        PathAddress realAddress = aliasEntry.convertToTargetAddress(opAddr, AliasEntry.AliasContext.create(opAddr, context));
        assert (!realAddress.equals(opAddr)) : "Alias was not translated";
        return root.getSubModel(realAddress);
    }

    private ModelNode describeFeature(Locale locale, ImmutableManagementResourceRegistration registration, CapabilityScope capabilityScope, boolean isProfile) {
        Map<String, String> featureParamMappings;
        ModelNode requestProperties;
        if (!registration.isFeature() || registration.isRuntimeOnly() || registration.isAlias()) {
            return new ModelNode();
        }
        ModelNode result = new ModelNode();
        PathAddress pa = registration.getPathAddress();
        ModelNode resourceDescriptionNode = registration.getModelDescription(PathAddress.EMPTY_ADDRESS).getModelDescription(locale);
        ModelNode feature = result.get("feature");
        feature.get("name").set(registration.getFeature());
        DescriptionProvider addDescriptionProvider = registration.getOperationDescription(PathAddress.EMPTY_ADDRESS, "add");
        if (addDescriptionProvider != null) {
            ModelNode annotation = feature.get("annotation");
            annotation.get("name").set("add");
            requestProperties = addDescriptionProvider.getModelDescription(locale).get("request-properties");
            featureParamMappings = this.addParams(feature, pa, requestProperties);
            this.addOpParam(annotation, requestProperties, featureParamMappings);
        } else {
            requestProperties = new ModelNode().setEmptyList();
            StringJoiner params = new StringJoiner(",");
            params.setEmptyValue("");
            if (resourceDescriptionNode.hasDefined("attributes")) {
                ModelNode attributeNodes = resourceDescriptionNode.require("attributes");
                block4: for (AttributeAccess attAccess : registration.getAttributes(PathAddress.EMPTY_ADDRESS).values()) {
                    if (AttributeAccess.Storage.CONFIGURATION != attAccess.getStorageType() || attAccess.getAccessType() != AttributeAccess.AccessType.READ_WRITE) continue;
                    AttributeDefinition attDef = attAccess.getAttributeDefinition();
                    switch (attDef.getType()) {
                        case LIST: {
                            if (ObjectListAttributeDefinition.class.isAssignableFrom(attDef.getClass())) continue block4;
                            requestProperties.add(attDef.getName(), attributeNodes.get(attDef.getName()));
                            continue block4;
                        }
                        case OBJECT: {
                            continue block4;
                        }
                    }
                    requestProperties.add(attDef.getName(), attributeNodes.get(attDef.getName()));
                }
                featureParamMappings = this.addParams(feature, pa, requestProperties);
                if (requestProperties.isDefined() && !requestProperties.asList().isEmpty()) {
                    ModelNode annotation = feature.get("annotation");
                    annotation.get("name").set("write-attribute");
                    this.addOpParam(annotation, requestProperties, featureParamMappings);
                } else {
                    feature.remove("annotation");
                }
            } else {
                featureParamMappings = Collections.emptyMap();
            }
        }
        HashSet<String> capabilities = new HashSet<String>();
        for (RuntimeCapability cap : registration.getCapabilities()) {
            String capabilityName = cap.getName();
            if (cap.isDynamicallyNamed()) {
                PathAddress aliasAddress = this.createAliasPathAddress(registration, pa);
                capabilityName = cap.getDynamicName(aliasAddress);
            }
            if (isProfile) {
                capabilityName = PROFILE_PREFIX + capabilityName;
            }
            capabilities.add(capabilityName);
            feature.get("provides").add(capabilityName);
        }
        this.processComplexAttributes(feature, registration);
        this.addReferences(feature, registration);
        this.addRequiredCapabilities(feature, registration, requestProperties, capabilityScope, isProfile, capabilities, featureParamMappings);
        return result;
    }

    private void processComplexAttributes(ModelNode parentFeature, ImmutableManagementResourceRegistration registration) {
        for (AttributeAccess attAccess : registration.getAttributes(PathAddress.EMPTY_ADDRESS).values()) {
            if (attAccess.getStorageType() != AttributeAccess.Storage.CONFIGURATION || attAccess.getAccessType() != AttributeAccess.AccessType.READ_WRITE) continue;
            AttributeDefinition attDef = attAccess.getAttributeDefinition();
            switch (attDef.getType()) {
                case LIST: {
                    if (!ObjectListAttributeDefinition.class.isAssignableFrom(attDef.getClass())) break;
                    this.processListAttribute(parentFeature, registration, (ObjectListAttributeDefinition)attDef);
                    break;
                }
                case OBJECT: {
                    if (!ObjectTypeAttributeDefinition.class.isAssignableFrom(attDef.getClass())) break;
                    ObjectTypeAttributeDefinition objAttDef = (ObjectTypeAttributeDefinition)attDef;
                    this.processObjectAttribute(parentFeature, registration, objAttDef);
                    break;
                }
            }
        }
    }

    private void processObjectAttribute(ModelNode parentFeature, ImmutableManagementResourceRegistration registration, ObjectTypeAttributeDefinition objAttDef) {
        ModelNode attFeature = new ModelNode();
        String specName = parentFeature.require("name").asString() + "." + objAttDef.getName();
        attFeature.get("name").set(specName);
        ModelNode annotation = attFeature.get("annotation");
        annotation.get("name").set("write-attribute");
        annotation.get("complex-attribute").set(objAttDef.getName());
        if (parentFeature.hasDefined("annotation")) {
            annotation.get("addr-params").set(parentFeature.require("annotation").require("addr-params"));
            if (parentFeature.require("annotation").hasDefined("addr-params-mapping")) {
                annotation.get("addr-params").set(parentFeature.require("annotation").require("addr-params-mapping"));
            }
        } else {
            this.addParams(attFeature, registration.getPathAddress(), new ModelNode().setEmptyList());
        }
        ModelNode refs = attFeature.get("refs").setEmptyList();
        ModelNode ref = new ModelNode();
        ref.get("feature").set(parentFeature.require("name"));
        refs.add(ref);
        ModelNode params = attFeature.get("params").setEmptyList();
        HashSet<String> idParams = new HashSet<String>();
        if (parentFeature.hasDefined("params")) {
            for (ModelNode param : parentFeature.require("params").asList()) {
                if (!param.hasDefined("feature-id") || !param.get("feature-id").asBoolean()) continue;
                idParams.add(param.get("name").asString());
                params.add(param);
            }
        }
        AttributeDefinition[] attrs = objAttDef.getValueTypes();
        Map<String, String> opParamMapping = Collections.emptyMap();
        ModelNode requestProps = new ModelNode();
        for (AttributeDefinition attr : attrs) {
            ModelNode param = new ModelNode();
            String paramName = attr.getName();
            requestProps.add(new Property(paramName, new ModelNode()));
            if (idParams.contains(paramName)) {
                paramName = paramName + "-feature";
                if (opParamMapping.isEmpty()) {
                    opParamMapping = Collections.singletonMap(attr.getName(), paramName);
                } else {
                    if (opParamMapping.size() == 1) {
                        opParamMapping = new HashMap<String, String>(opParamMapping);
                    }
                    opParamMapping.put(attr.getName(), paramName);
                }
            }
            param.get("name").set(paramName);
            if (!attr.isRequired()) {
                param.get("nillable").set(true);
            }
            if (objAttDef.getDefaultValue() != null && objAttDef.getDefaultValue().isDefined()) {
                param.get("default").set(objAttDef.getDefaultValue());
            }
            if (attr.getType() == ModelType.LIST) {
                param.get("type").set("List<String>");
            }
            params.add(param);
        }
        this.addOpParam(annotation, requestProps, opParamMapping);
        parentFeature.get("children").get(specName).set(attFeature);
    }

    private void processListAttribute(ModelNode parentFeature, ImmutableManagementResourceRegistration registration, ObjectListAttributeDefinition objAttDef) {
        ModelNode parentSpecName = parentFeature.require("name");
        ModelNode attFeature = new ModelNode();
        String specName = parentSpecName.asString() + "." + objAttDef.getName();
        attFeature.get("name").set(specName);
        ModelNode annotation = attFeature.get("annotation");
        annotation.get("name").set("list-add");
        annotation.get("complex-attribute").set(objAttDef.getName());
        if (parentFeature.hasDefined("annotation")) {
            annotation.get("addr-params").set(parentFeature.require("annotation").require("addr-params"));
            if (parentFeature.require("annotation").hasDefined("addr-params-mapping")) {
                annotation.get("addr-params").set(parentFeature.require("annotation").require("addr-params-mapping"));
            }
        } else {
            this.addParams(attFeature, registration.getPathAddress(), new ModelNode().setEmptyList());
        }
        ModelNode refs = attFeature.get("refs").setEmptyList();
        ModelNode ref = new ModelNode();
        ref.get("feature").set(parentSpecName);
        refs.add(ref);
        ModelNode params = attFeature.get("params").setEmptyList();
        HashSet<String> idParams = new HashSet<String>();
        if (parentFeature.hasDefined("params")) {
            for (ModelNode param : parentFeature.require("params").asList()) {
                if (!param.hasDefined("feature-id") || !param.get("feature-id").asBoolean()) continue;
                ModelNode parentParam = new ModelNode();
                String paramName = param.get("name").asString();
                parentParam.get("name").set(paramName);
                params.add(parentParam);
                idParams.add(paramName);
            }
        }
        ObjectTypeAttributeDefinition itemType = objAttDef.getValueType();
        AttributeDefinition[] attrs = itemType.getValueTypes();
        Map<String, String> opParamMapping = Collections.emptyMap();
        ModelNode requestProps = new ModelNode();
        for (AttributeDefinition attr : attrs) {
            ModelNode param = new ModelNode();
            String paramName = attr.getName();
            requestProps.add(new Property(paramName, new ModelNode()));
            if (idParams.contains(paramName)) {
                paramName = paramName + "-feature";
                if (opParamMapping.isEmpty()) {
                    opParamMapping = Collections.singletonMap(attr.getName(), paramName);
                } else {
                    if (opParamMapping.size() == 1) {
                        opParamMapping = new HashMap<String, String>(opParamMapping);
                    }
                    opParamMapping.put(attr.getName(), paramName);
                }
            }
            param.get("name").set(paramName);
            if (!attr.isRequired()) {
                param.get("nillable").set(true);
            }
            if (objAttDef.getDefaultValue() != null && objAttDef.getDefaultValue().isDefined()) {
                param.get("default").set(objAttDef.getDefaultValue());
            }
            if (attr.getType() == ModelType.LIST) {
                param.get("type").set("List<String>");
            }
            params.add(param);
        }
        this.addOpParam(annotation, requestProps, opParamMapping);
        parentFeature.get("children").get(specName).set(attFeature);
    }

    private Map<String, String> addParams(ModelNode feature, PathAddress address, ModelNode requestProperties) {
        ModelNode params = feature.get("params").setEmptyList();
        HashSet<String> paramNames = new HashSet<String>();
        StringJoiner addressParams = new StringJoiner(",");
        for (Object elt : address) {
            String paramName = ((PathElement)elt).getKey();
            ModelNode param = new ModelNode();
            param.get("name").set(paramName);
            if ("profile".equals(((PathElement)elt).getKey()) || "host".equals(((PathElement)elt).getKey())) {
                param.get("default").set("GLN_UNDEFINED");
            } else if (!((PathElement)elt).isWildcard()) {
                param.get("default").set(((PathElement)elt).getValue());
            }
            param.get("feature-id").set(true);
            params.add(param);
            paramNames.add(paramName);
            addressParams.add(paramName);
        }
        HashMap<String, String> featureParamMappings = new HashMap<String, String>();
        for (Property att : requestProperties.asPropertyList()) {
            String paramName;
            ModelNode attDescription = att.getValue();
            ModelNode param = new ModelNode();
            if (paramNames.contains(att.getName()) || ("profile".equals(att.getName()) || "host".equals(att.getName())) && this.isSubsystem(address)) {
                paramName = att.getName() + "-feature";
                featureParamMappings.put(att.getName(), paramName);
            } else {
                paramName = att.getName();
            }
            param.get("name").set(paramName);
            paramNames.add(paramName);
            if (attDescription.hasDefined("nillable") && attDescription.get("nillable").asBoolean()) {
                param.get("nillable").set(true);
            }
            if (attDescription.hasDefined("default") && attDescription.hasDefined("capability-reference")) {
                param.get("default").set(attDescription.get("default"));
            }
            if (attDescription.hasDefined("type") && "LIST".equals(attDescription.get("type").asString())) {
                try {
                    switch (ModelType.valueOf((String)attDescription.get("value-type").asString())) {
                        case STRING: 
                        case INT: 
                        case BIG_DECIMAL: 
                        case BIG_INTEGER: 
                        case DOUBLE: 
                        case LONG: 
                        case BOOLEAN: {
                            param.get("type").set("List<String>");
                            break;
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            params.add(param);
        }
        ModelNode annotationNode = feature.get("annotation");
        annotationNode.get("addr-params").set(addressParams.toString());
        return featureParamMappings;
    }

    private void addReferences(ModelNode feature, ImmutableManagementResourceRegistration registration) {
        PathElement element;
        PathAddress address = registration.getPathAddress();
        if (address == null || PathAddress.EMPTY_ADDRESS.equals(address)) {
            return;
        }
        ModelNode refs = feature.get("refs").setEmptyList();
        if (registration.getParent() != null && registration.getParent().isFeature()) {
            this.addReference(refs, registration.getParent());
        }
        if ("subsystem".equals((element = registration.getPathAddress().getLastElement()).getKey())) {
            ModelNode ref = new ModelNode();
            String rootType = registration.getPathAddress().getElement(0).getKey();
            if ("host".equals(rootType)) {
                ref.get("feature").set(HOST_EXTENSION);
            } else if ("profile".equals(rootType)) {
                ref.get("feature").set(DOMAIN_EXTENSION);
            } else {
                ref.get("feature").set("extension");
            }
            ref.get("include").set(true);
            refs.add(ref);
        }
        if (refs.asList().isEmpty()) {
            feature.remove("refs");
        }
    }

    private void addReference(ModelNode refs, ImmutableManagementResourceRegistration registration) {
        PathAddress address = registration.getPathAddress();
        if (address == null || PathAddress.EMPTY_ADDRESS.equals(address)) {
            return;
        }
        if (registration.isFeature()) {
            ModelNode ref = new ModelNode();
            ref.get("feature").set(registration.getFeature());
            refs.add(ref);
        }
        if (registration.getParent() != null) {
            this.addReference(refs, registration.getParent());
        }
    }

    private void addOpParam(ModelNode annotation, ModelNode requestProperties, Map<String, String> featureParamMappings) {
        if (!requestProperties.isDefined()) {
            return;
        }
        List request = requestProperties.asPropertyList();
        StringJoiner params = new StringJoiner(",");
        StringJoiner paramMappings = new StringJoiner(",");
        boolean keepMapping = false;
        for (Property att : request) {
            String realName = att.getName();
            if (featureParamMappings.containsKey(realName)) {
                keepMapping = true;
                params.add(featureParamMappings.get(realName));
            } else {
                params.add(realName);
            }
            paramMappings.add(realName);
        }
        if (keepMapping) {
            annotation.get("op-params-mapping").set(paramMappings.toString());
        }
        annotation.get("op-params").set(params.toString());
    }

    private void addRequiredCapabilities(ModelNode feature, ImmutableManagementResourceRegistration registration, ModelNode requestProperties, CapabilityScope scope, boolean isProfile, Set<String> capabilities, Map<String, String> featureParamMappings) {
        List request;
        if (requestProperties.isDefined() && !(request = requestProperties.asPropertyList()).isEmpty()) {
            ModelNode required = new ModelNode().setEmptyList();
            boolean filteredOut = false;
            for (String cap : capabilities) {
                if (!cap.startsWith("org.wildfly.domain.server-config.")) continue;
                filteredOut = true;
                break;
            }
            for (Property att : request) {
                String attributeName;
                if (!att.getValue().hasDefined("capability-reference")) continue;
                ModelNode capability = new ModelNode();
                String capabilityName = att.getValue().get("capability-reference").asString();
                String baseName = capabilityName.indexOf(36) > 0 ? capabilityName.substring(0, capabilityName.indexOf(36) - 1) : capabilityName;
                CapabilityRegistration<?> capReg = this.getCapability(new CapabilityId(baseName, scope));
                String string = attributeName = featureParamMappings.containsKey(att.getName()) ? featureParamMappings.get(att.getName()) : att.getName();
                if (capReg == null || capReg.getCapability().isDynamicallyNamed() && capabilityName.indexOf(36) <= 0) {
                    capabilityName = baseName + ".$" + attributeName;
                }
                if (filteredOut) continue;
                if (att.getValue().hasDefined("capability-reference-pattern-elements")) {
                    ArrayList<String> elements = new ArrayList<String>();
                    for (ModelNode elt : att.getValue().get("capability-reference-pattern-elements").asList()) {
                        elements.add("$" + elt.asString());
                    }
                    capabilityName = RuntimeCapability.buildDynamicCapabilityName(baseName, elements.toArray(new String[elements.size()]));
                }
                capability.get("optional").set(att.getValue().hasDefined("nillable") && att.getValue().get("nillable").asBoolean());
                if (isProfile && !capabilityName.startsWith("org.wildfly.network.socket-binding")) {
                    capabilityName = PROFILE_PREFIX + capabilityName;
                }
                capability.get("name").set(capabilityName);
                if (!capabilityName.startsWith("org.wildfly.domain.server-group.") && !capabilityName.startsWith("org.wildfly.domain.socket-binding-group.")) {
                    required.add(capability);
                }
                if (!att.getValue().hasDefined("feature-reference") || !att.getValue().require("feature-reference").asBoolean() || capReg == null) continue;
                ImmutableManagementResourceRegistration root = this.getRootRegistration(registration);
                ModelNode refs = !feature.hasDefined("refs") ? feature.get("refs").setEmptyList() : feature.get("refs");
                if (registration.getParent() != null && registration.getParent().isFeature()) {
                    this.addReference(refs, registration.getParent());
                }
                for (RegistrationPoint regPoint : capReg.getRegistrationPoints()) {
                    ModelNode ref = new ModelNode();
                    ref.get("feature").set(root.getSubModel(regPoint.getAddress()).getFeature());
                    refs.add(ref);
                }
            }
            if (!registration.getRequirements().isEmpty()) {
                PathAddress aliasAddress = this.createAliasPathAddress(registration, registration.getPathAddress());
                for (CapabilityReferenceRecorder requirement : registration.getRequirements()) {
                    String[] dynamicElements;
                    String[] segments = requirement.getRequirementPatternSegments(null, aliasAddress);
                    if (segments == null || segments.length == 0) {
                        dynamicElements = null;
                    } else {
                        dynamicElements = new String[segments.length];
                        for (int i = 0; i < segments.length; ++i) {
                            dynamicElements[i] = "$" + segments[i];
                        }
                    }
                    String baseRequirementName = isProfile ? PROFILE_PREFIX + requirement.getBaseRequirementName() : requirement.getBaseRequirementName();
                    ModelNode capability = new ModelNode();
                    if (dynamicElements == null) {
                        capability.get("name").set(baseRequirementName);
                    } else {
                        capability.get("name").set(RuntimeCapability.buildDynamicCapabilityName(baseRequirementName, dynamicElements));
                    }
                    required.add(capability);
                }
            }
            if (!required.asList().isEmpty()) {
                feature.get("requires").set(required);
            }
        }
    }

    private ImmutableManagementResourceRegistration getRootRegistration(ImmutableManagementResourceRegistration registration) {
        if (!PathAddress.EMPTY_ADDRESS.equals(registration.getPathAddress())) {
            return this.getRootRegistration(registration.getParent());
        }
        return registration;
    }

    private boolean isSubsystem(PathAddress address) {
        for (PathElement elt : address) {
            if (!"subsystem".equals(elt.getKey())) continue;
            return true;
        }
        return false;
    }

    private boolean isProfileScope(ProcessType processType, PathAddress address) {
        if (processType.isServer() || address.size() < 2) {
            return false;
        }
        return "profile".equals(address.getElement(0).getKey());
    }

    private CapabilityRegistration<?> getCapability(CapabilityId capabilityId) {
        CapabilityRegistration<?> capReg = this.capabilityRegistry.getCapability(capabilityId);
        if (capReg == null) {
            for (CapabilityRegistration<?> reg : this.capabilityRegistry.getPossibleCapabilities()) {
                if (!reg.getCapabilityId().getName().equals(capabilityId.getName())) continue;
                capReg = reg;
                break;
            }
        }
        return capReg;
    }

    private PathAddress createAliasPathAddress(ImmutableManagementResourceRegistration registration, PathAddress pa) {
        ImmutableManagementResourceRegistration registry = registration.getParent();
        ArrayList<PathElement> elements = new ArrayList<PathElement>();
        for (int i = pa.size() - 1; i >= 0; --i) {
            PathElement elt = pa.getElement(i);
            ImmutableManagementResourceRegistration childRegistration = registry.getSubModel(PathAddress.pathAddress(PathElement.pathElement(elt.getKey())));
            if (childRegistration == null) {
                elements.add(elt);
            } else {
                String value = "$" + elt.getKey();
                elements.add(PathElement.pathElement(elt.getKey(), value));
            }
            registry = registry.getParent();
        }
        Collections.reverse(elements);
        return PathAddress.pathAddress(elements.toArray(new PathElement[elements.size()]));
    }

    static {
        ModelNode none = new ModelNode();
        none.get("no-such-resource").set("no$such$resource");
        none.protect();
        PROXY_NO_SUCH_RESOURCE = none;
    }

    private class NestedReadFeatureHandler
    extends ReadFeatureDescriptionHandler {
        final ReadFeatureAccessControlContext accessControlContext;
        final OperationStepHandler overrideStepHandler;

        NestedReadFeatureHandler(ImmutableCapabilityRegistry capabilityRegistry, ReadFeatureAccessControlContext accessControlContext) {
            super(capabilityRegistry);
            this.accessControlContext = accessControlContext;
            this.overrideStepHandler = null;
        }

        NestedReadFeatureHandler(ImmutableCapabilityRegistry capabilityRegistry, OperationStepHandler overrideStepHandler) {
            super(capabilityRegistry);
            this.accessControlContext = null;
            this.overrideStepHandler = overrideStepHandler;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (this.accessControlContext != null) {
                this.doExecute(context, operation, this.accessControlContext);
            } else {
                try {
                    this.overrideStepHandler.execute(context, operation);
                }
                catch (Resource.NoSuchResourceException e) {
                    context.getResult().set(PROXY_NO_SUCH_RESOURCE);
                }
                catch (UnauthorizedException e) {
                    context.getResult().set(new ModelNode());
                }
            }
        }
    }

    private static final class ReadFeatureAccessControlContext {
        private final PathAddress opAddress;
        private final List<PathAddress> parentAddresses;
        private List<PathAddress> localResourceAddresses = null;
        private ModelNode defaultWildcardAccessControl;
        private Map<PathAddress, ModelNode> localResourceAccessControlResults = new HashMap<PathAddress, ModelNode>();

        ReadFeatureAccessControlContext(PathAddress opAddress, ReadFeatureAccessControlContext parent) {
            this.opAddress = opAddress;
            this.parentAddresses = parent != null ? parent.parentAddresses : null;
        }

        void checkResourceAccess(OperationContext context, ImmutableManagementResourceRegistration registration, ModelNode nodeDescription) {
            ModelNode defaultAccess = Util.createOperation(this.opAddress.size() > 0 && !this.opAddress.getLastElement().isWildcard() ? "check-default-resource-access" : "check-resource-access", this.opAddress);
            this.defaultWildcardAccessControl = new ModelNode();
            context.addStep(defaultAccess, new CheckResourceAccessHandler(registration.isRuntimeOnly(), true, this.defaultWildcardAccessControl, nodeDescription), OperationContext.Stage.MODEL, true);
            for (PathAddress address : this.localResourceAddresses) {
                ModelNode op = Util.createOperation("check-resource-access", address);
                ModelNode resultHolder = new ModelNode();
                this.localResourceAccessControlResults.put(address, resultHolder);
                context.addStep(op, new CheckResourceAccessHandler(registration.isRuntimeOnly(), false, resultHolder, nodeDescription), OperationContext.Stage.MODEL, true);
            }
        }
    }

    private static class ReadFeatureAssemblyHandler
    implements OperationStepHandler {
        private final ModelNode featureDescription;
        private final Map<PathElement, ModelNode> childResources;
        private final ReadFeatureAccessControlContext accessControlContext;

        private ReadFeatureAssemblyHandler(ModelNode featureDescription, Map<PathElement, ModelNode> childResources, ReadFeatureAccessControlContext accessControlContext) {
            this.featureDescription = featureDescription;
            this.childResources = childResources;
            this.accessControlContext = accessControlContext;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            for (Map.Entry<PathElement, ModelNode> entry : this.childResources.entrySet()) {
                PathElement element = entry.getKey();
                ModelNode value = entry.getValue();
                if (!value.has("failure-description")) {
                    ModelNode actualValue = value.get("result");
                    if (actualValue.equals(PROXY_NO_SUCH_RESOURCE)) {
                        this.featureDescription.get("feature").get("children").remove(element.getKey());
                        continue;
                    }
                    if (actualValue.isDefined()) {
                        if (this.featureDescription.get("feature").get("children").has(element.getKey())) {
                            this.featureDescription.get("feature").get("children").remove(element.getKey());
                        }
                        if (!actualValue.hasDefined("feature")) continue;
                        String name = value.get(new String[]{"result", "feature", "name"}).asString();
                        this.featureDescription.get(new String[]{"feature", "children", name}).set(actualValue.get("feature"));
                        continue;
                    }
                    if (!this.featureDescription.get("feature").get("children").has(element.getKey())) continue;
                    this.featureDescription.get("feature").get("children").remove(element.getKey());
                    continue;
                }
                if (!value.hasDefined("failure-description")) continue;
                context.getFailureDescription().set(value.get("failure-description"));
                break;
            }
            if (this.accessControlContext.defaultWildcardAccessControl != null && this.accessControlContext.localResourceAccessControlResults != null) {
                ModelNode defaultControl;
                ModelNode accessControl = new ModelNode();
                accessControl.setEmptyObject();
                if (this.accessControlContext.defaultWildcardAccessControl != null) {
                    accessControl.get("default").set(this.accessControlContext.defaultWildcardAccessControl);
                    defaultControl = this.accessControlContext.defaultWildcardAccessControl;
                } else {
                    defaultControl = new ModelNode();
                }
                if (this.accessControlContext.localResourceAccessControlResults != null) {
                    ModelNode exceptions = accessControl.get("exceptions");
                    exceptions.setEmptyObject();
                    for (Map.Entry entry : this.accessControlContext.localResourceAccessControlResults.entrySet()) {
                        if (!((ModelNode)entry.getValue()).isDefined() || ((ModelNode)entry.getValue()).equals(defaultControl)) continue;
                        ModelNode exceptionAddr = ((PathAddress)entry.getKey()).toModelNode();
                        ModelNode exception = (ModelNode)entry.getValue();
                        exception.get("address").set(exceptionAddr);
                        exceptions.get(exceptionAddr.asString()).set((ModelNode)entry.getValue());
                    }
                }
            }
            context.getResult().set(this.featureDescription);
        }
    }

    private static final class CheckResourceAccessHandler
    implements OperationStepHandler {
        private final boolean runtimeResource;
        private final boolean defaultSetting;
        private final ModelNode accessControlResult;
        private final ModelNode nodeDescription;

        CheckResourceAccessHandler(boolean runtimeResource, boolean defaultSetting, ModelNode accessControlResult, ModelNode nodeDescription) {
            this.runtimeResource = runtimeResource;
            this.defaultSetting = defaultSetting;
            this.accessControlResult = accessControlResult;
            this.nodeDescription = nodeDescription;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode result = new ModelNode();
            boolean customDefaultCheck = operation.get("operation").asString().equals("check-default-resource-access");
            ResourceAuthorization authResp = context.authorizeResource(true, customDefaultCheck);
            if (authResp == null || authResp.getResourceResult(Action.ActionEffect.ADDRESS).getDecision() == AuthorizationResult.Decision.DENY) {
                if (this.defaultSetting && authResp != null) {
                    result.get(Action.ActionEffect.ADDRESS.toString()).set(false);
                }
            } else {
                this.addResourceAuthorizationResults(result, authResp);
                ModelNode attributes = new ModelNode();
                attributes.setEmptyObject();
                if (result.get("read").asBoolean()) {
                    if (this.nodeDescription.hasDefined("attributes")) {
                        for (Property attrProp : this.nodeDescription.require("attributes").asPropertyList()) {
                            ModelNode attributeResult = new ModelNode();
                            AttributeAccess.Storage storage = AttributeAccess.Storage.valueOf(attrProp.getValue().get("storage").asString().toUpperCase(Locale.ENGLISH));
                            this.addAttributeAuthorizationResults(attributeResult, attrProp.getName(), authResp, storage == AttributeAccess.Storage.RUNTIME);
                            if (!attributeResult.isDefined()) continue;
                            attributes.get(attrProp.getName()).set(attributeResult);
                        }
                    }
                    result.get("attributes").set(attributes);
                }
            }
            this.accessControlResult.set(result);
        }

        private void addResourceAuthorizationResults(ModelNode result, ResourceAuthorization authResp) {
            if (this.runtimeResource) {
                this.addResourceAuthorizationResult(result, authResp, Action.ActionEffect.READ_RUNTIME);
                this.addResourceAuthorizationResult(result, authResp, Action.ActionEffect.WRITE_RUNTIME);
            } else {
                this.addResourceAuthorizationResult(result, authResp, Action.ActionEffect.READ_CONFIG);
                this.addResourceAuthorizationResult(result, authResp, Action.ActionEffect.WRITE_CONFIG);
            }
        }

        private void addResourceAuthorizationResult(ModelNode result, ResourceAuthorization authResp, Action.ActionEffect actionEffect) {
            AuthorizationResult authResult = authResp.getResourceResult(actionEffect);
            result.get(actionEffect == Action.ActionEffect.READ_CONFIG || actionEffect == Action.ActionEffect.READ_RUNTIME ? "read" : "write").set(authResult.getDecision() == AuthorizationResult.Decision.PERMIT);
        }

        private void addAttributeAuthorizationResults(ModelNode result, String attributeName, ResourceAuthorization authResp, boolean runtime) {
            if (runtime) {
                this.addAttributeAuthorizationResult(result, attributeName, authResp, Action.ActionEffect.READ_RUNTIME);
                this.addAttributeAuthorizationResult(result, attributeName, authResp, Action.ActionEffect.WRITE_RUNTIME);
            } else {
                this.addAttributeAuthorizationResult(result, attributeName, authResp, Action.ActionEffect.READ_CONFIG);
                this.addAttributeAuthorizationResult(result, attributeName, authResp, Action.ActionEffect.WRITE_CONFIG);
            }
        }

        private void addAttributeAuthorizationResult(ModelNode result, String attributeName, ResourceAuthorization authResp, Action.ActionEffect actionEffect) {
            AuthorizationResult authorizationResult = authResp.getAttributeResult(attributeName, actionEffect);
            if (authorizationResult != null) {
                result.get(actionEffect == Action.ActionEffect.READ_CONFIG || actionEffect == Action.ActionEffect.READ_RUNTIME ? "read" : "write").set(authorizationResult.getDecision() == AuthorizationResult.Decision.PERMIT);
            }
        }
    }
}

