/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class EnumValidator<E extends Enum<E>>
extends ModelTypeValidator
implements AllowedValuesValidator {
    private final EnumSet<E> allowedValues;
    private final Class<E> enumType;
    private final Map<String, E> toStringMap = new HashMap<String, E>();

    @SafeVarargs
    public EnumValidator(Class<E> enumType, E ... allowed) {
        this(enumType, EnumValidator.setOf(enumType, allowed), true);
    }

    public EnumValidator(Class<E> enumType, EnumSet<E> allowed) {
        this(enumType, allowed, false);
    }

    private EnumValidator(Class<E> enumType, EnumSet<E> allowed, boolean safe) {
        super(ModelType.STRING);
        if (safe) {
            this.enumType = enumType;
            this.allowedValues = allowed;
        } else {
            assert (enumType != null);
            assert (allowed != null);
            this.enumType = enumType;
            this.allowedValues = EnumSet.copyOf(allowed);
        }
        for (Enum value : this.allowedValues) {
            this.toStringMap.put(value.toString(), value);
        }
    }

    @SafeVarargs
    @Deprecated
    public EnumValidator(Class<E> enumType, boolean nullable, E ... allowed) {
        this(enumType, nullable, false, (Enum[])allowed);
    }

    @Deprecated
    public EnumValidator(Class<E> enumType, boolean nullable, boolean allowExpressions) {
        super(ModelType.STRING, nullable, allowExpressions);
        assert (enumType != null);
        this.enumType = enumType;
        this.allowedValues = EnumSet.allOf(enumType);
        for (Enum value : this.allowedValues) {
            this.toStringMap.put(value.toString(), value);
        }
    }

    @SafeVarargs
    @Deprecated
    public EnumValidator(Class<E> enumType, boolean nullable, boolean allowExpressions, E ... allowed) {
        super(ModelType.STRING, nullable, allowExpressions);
        this.enumType = enumType;
        this.allowedValues = EnumValidator.setOf(enumType, allowed);
        for (E value : allowed) {
            this.toStringMap.put(((Enum)value).toString(), value);
        }
    }

    @SafeVarargs
    private static <T extends Enum<T>> EnumSet<T> setOf(Class<T> enumType, T ... allowed) {
        assert (enumType != null);
        assert (allowed != null);
        EnumSet<T> set = EnumSet.noneOf(enumType);
        Collections.addAll(set, allowed);
        return set;
    }

    @SafeVarargs
    public static <E extends Enum<E>> EnumValidator<E> create(Class<E> enumType, E ... allowed) {
        if (allowed == null || allowed.length == 0) {
            return EnumValidator.create(enumType, EnumSet.allOf(enumType));
        }
        return new EnumValidator(enumType, allowed);
    }

    public static <E extends Enum<E>> EnumValidator<E> create(Class<E> enumType, EnumSet<E> allowed) {
        return new EnumValidator<E>(enumType, allowed);
    }

    @SafeVarargs
    @Deprecated
    public static <E extends Enum<E>> EnumValidator<E> create(Class<E> enumType, boolean nullable, E ... allowed) {
        return new EnumValidator(enumType, nullable, allowed);
    }

    @Deprecated
    public static <E extends Enum<E>> EnumValidator<E> create(Class<E> enumType, boolean nullable, boolean allowExpressions) {
        return new EnumValidator<E>(enumType, nullable, allowExpressions);
    }

    @SafeVarargs
    @Deprecated
    public static <E extends Enum<E>> EnumValidator<E> create(Class<E> enumType, boolean nullable, boolean allowExpressions, E ... allowed) {
        return new EnumValidator(enumType, nullable, allowExpressions, allowed);
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        ModelType type = value.getType();
        if (type == ModelType.STRING) {
            String tuString = ExpressionResolver.SIMPLE.resolveExpressions(value).asString();
            Enum enumValue = (Enum)this.toStringMap.get(tuString);
            if (enumValue == null) {
                try {
                    enumValue = Enum.valueOf(this.enumType, tuString.toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException e) {
                    throw ControllerLogger.ROOT_LOGGER.invalidEnumValue(tuString, parameterName, this.toStringMap.keySet());
                }
            }
            if (!this.allowedValues.contains(enumValue)) {
                throw ControllerLogger.ROOT_LOGGER.invalidEnumValue(tuString, parameterName, this.toStringMap.keySet());
            }
            try {
                value.set(enumValue.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public List<ModelNode> getAllowedValues() {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        for (Enum value : this.allowedValues) {
            if (value.toString() != null) {
                result.add(new ModelNode().set(value.toString()));
                continue;
            }
            result.add(new ModelNode().set(value.name()));
        }
        return result;
    }
}

