/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.deployment;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.plugin.cli.CommandExecutor;
import org.wildfly.plugin.cli.Commands;
import org.wildfly.plugin.common.AbstractServerConnection;
import org.wildfly.plugin.core.DeploymentDescription;
import org.wildfly.plugin.core.DeploymentManager;
import org.wildfly.plugin.core.DeploymentResult;
import org.wildfly.plugin.core.UndeployDescription;
import org.wildfly.plugin.deployment.MatchPatternStrategy;
import org.wildfly.plugin.deployment.MojoDeploymentException;
import org.wildfly.plugin.deployment.PackageType;
import org.wildfly.plugin.deployment.domain.Domain;

@Mojo(name="undeploy", threadSafe=true)
public class UndeployMojo
extends AbstractServerConnection {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Deprecated
    @Parameter
    private Domain domain;
    @Parameter(alias="server-groups", property="wildfly.serverGroups")
    private List<String> serverGroups;
    @Parameter(property="wildfly.deployment.name")
    private String name;
    @Deprecated
    @Parameter(alias="before-deployment")
    private Commands beforeDeployment;
    @Deprecated
    @Parameter(alias="after-deployment")
    private Commands afterDeployment;
    @Parameter(alias="check-packaging", property="wildfly.checkPackaging", defaultValue="true")
    private boolean checkPackaging;
    @Parameter(alias="match-pattern")
    private String matchPattern;
    @Parameter(alias="match-pattern-strategy")
    private String matchPatternStrategy = MatchPatternStrategy.FAIL.toString();
    @Parameter(defaultValue="true", property="undeploy.ignoreMissingDeployment")
    private boolean ignoreMissingDeployment;
    @Parameter(defaultValue="false", property="wildfly.skip")
    private boolean skip;
    @Inject
    private CommandExecutor commandExecutor;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)String.format("Skipping undeploy of %s:%s", this.project.getGroupId(), this.project.getArtifactId()));
            return;
        }
        PackageType packageType = PackageType.resolve(this.project);
        if (this.name == null) {
            this.name = String.format("%s.%s", this.project.getBuild().getFinalName(), packageType.getFileExtension());
        }
        if (this.checkPackaging && packageType.isIgnored()) {
            this.getLog().debug((CharSequence)String.format("Ignoring packaging type %s.", packageType.getPackaging()));
        } else {
            DeploymentResult result;
            try (ModelControllerClient client = this.createClient();){
                if (this.beforeDeployment != null) {
                    this.commandExecutor.execute(client, this.beforeDeployment);
                }
                boolean failOnMissing = !this.ignoreMissingDeployment;
                DeploymentManager deploymentManager = DeploymentManager.Factory.create((ModelControllerClient)client);
                if (this.matchPattern == null) {
                    result = deploymentManager.undeploy(UndeployDescription.of((String)this.name).addServerGroups(this.getServerGroups()).setFailOnMissing(failOnMissing));
                } else {
                    Set<UndeployDescription> matchedDeployments = this.findDeployments(deploymentManager, failOnMissing);
                    if (matchedDeployments.isEmpty()) {
                        if (failOnMissing) {
                            throw new MojoDeploymentException("No deployments matched the match-pattern %s.", this.matchPattern);
                        }
                        return;
                    }
                    result = deploymentManager.undeploy(matchedDeployments);
                }
                if (this.afterDeployment != null) {
                    this.commandExecutor.execute(client, this.afterDeployment);
                }
            }
            catch (IOException e) {
                throw new MojoFailureException("Failed to execute undeploy goal.", (Throwable)e);
            }
            if (!result.successful()) {
                throw new MojoDeploymentException("Failed to undeploy %s. Reason: %s", this.name, result.getFailureMessage());
            }
        }
    }

    @Override
    public String goal() {
        return "undeploy";
    }

    private Set<UndeployDescription> findDeployments(DeploymentManager deploymentManager, boolean failOnMissing) throws IOException, MojoDeploymentException {
        if (this.name == null && this.matchPattern == null) {
            throw new IllegalArgumentException("deploymentName and matchPattern are null. One of them must be set in order to find an existing deployment.");
        }
        MatchPatternStrategy matchPatternStrategy = this.getMatchPatternStrategy();
        TreeSet<UndeployDescription> matchedDeployments = new TreeSet<UndeployDescription>();
        Set deployments = deploymentManager.getDeployments();
        Pattern pattern = Pattern.compile(this.matchPattern);
        for (DeploymentDescription deployment : deployments) {
            boolean matchFound = false;
            String deploymentName = deployment.getName();
            Collection<String> serverGroups = this.getServerGroups();
            if (!pattern.matcher(deploymentName).matches()) continue;
            if (serverGroups.isEmpty()) {
                matchFound = true;
                matchedDeployments.add(UndeployDescription.of((String)deploymentName).setFailOnMissing(failOnMissing));
            } else {
                UndeployDescription undeployDescription = UndeployDescription.of((String)deploymentName);
                for (String serverGroup : serverGroups) {
                    if (!deployment.getServerGroups().contains(serverGroup)) continue;
                    matchFound = true;
                    undeployDescription.addServerGroup(serverGroup);
                }
                if (matchFound) {
                    matchedDeployments.add(undeployDescription.setFailOnMissing(failOnMissing));
                }
            }
            if (!matchFound || matchPatternStrategy != MatchPatternStrategy.FIRST) continue;
            break;
        }
        if (matchPatternStrategy == MatchPatternStrategy.FAIL && matchedDeployments.size() > 1) {
            throw new MojoDeploymentException("Deployment failed, found %d deployed artifacts for pattern '%s' (%s)", matchedDeployments.size(), this.matchPattern, matchedDeployments);
        }
        return matchedDeployments;
    }

    private MatchPatternStrategy getMatchPatternStrategy() {
        if (MatchPatternStrategy.FAIL.toString().equalsIgnoreCase(this.matchPatternStrategy)) {
            return MatchPatternStrategy.FAIL;
        }
        if (MatchPatternStrategy.FIRST.toString().equalsIgnoreCase(this.matchPatternStrategy)) {
            return MatchPatternStrategy.FIRST;
        }
        if (MatchPatternStrategy.ALL.toString().equalsIgnoreCase(this.matchPatternStrategy)) {
            return MatchPatternStrategy.ALL;
        }
        throw new IllegalStateException(String.format("matchPatternStrategy '%s' is not a valid strategy. Valid strategies are %s, %s and %s", new Object[]{this.matchPatternStrategy, MatchPatternStrategy.ALL, MatchPatternStrategy.FAIL, MatchPatternStrategy.FIRST}));
    }

    private Collection<String> getServerGroups() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (this.domain != null) {
            result.addAll(this.domain.getServerGroups());
        }
        if (this.serverGroups != null) {
            result.addAll(this.serverGroups);
        }
        return result;
    }
}

